/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger.gui;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.eclipse.vjet.dsf.jsdebugger.gui.BreakpointCache;
import org.eclipse.vjet.dsf.jsdebugger.gui.ContextWindow;
import org.eclipse.vjet.dsf.jsdebugger.gui.FileTextArea;
import org.eclipse.vjet.dsf.jsdebugger.gui.FileWindow;
import org.eclipse.vjet.dsf.jsdebugger.gui.FindFunction;
import org.eclipse.vjet.dsf.jsdebugger.gui.JSInternalConsole;
import org.eclipse.vjet.dsf.jsdebugger.gui.Menubar;
import org.eclipse.vjet.dsf.jsdebugger.gui.MessageDialogWrapper;
import org.eclipse.vjet.dsf.jsdebugger.gui.MoreWindows;
import org.eclipse.vjet.dsf.jsdebugger.gui.RunProxy;
import org.eclipse.vjet.dsf.jsdi.IDebuggerControl;
import org.eclipse.vjet.dsf.jsdi.IGuiCallback;
import org.eclipse.vjet.dsf.jsdi.ISourceInfo;
import org.eclipse.vjet.dsf.jsdi.StackFrameInfo;
import org.mozilla.mod.javascript.Kit;

public class SwingGui
extends JFrame
implements IGuiCallback {
    private static final long serialVersionUID = -8217029773456711621L;
    IDebuggerControl m_debuggerControl;
    private Runnable m_exitAction;
    private JDesktopPane m_desk;
    private ContextWindow m_contextWindow;
    private Menubar m_menubar;
    private JToolBar m_toolBar;
    private JSInternalConsole m_console;
    private JSplitPane m_split1;
    private JLabel m_statusBar;
    private Hashtable<String, JFrame> m_toplevels = new Hashtable();
    private Hashtable<String, FileWindow> m_fileWindows = new Hashtable();
    private FileWindow m_currentWindow;
    private EventQueue m_awtEventQueue;
    static JFileChooser s_fileChooserDlg = null;

    public SwingGui(String title) {
        super(title);
        this.init();
    }

    public void connect(IDebuggerControl debuggerControl) {
        this.m_debuggerControl = debuggerControl;
        try {
            this.m_debuggerControl.setGuiCallback((IGuiCallback)this);
        }
        catch (RemoteException remoteException) {}
        if (this.m_fileWindows.size() == 0) {
            return;
        }
        this.clear();
    }

    private void clear() {
        FileWindow[] windows = new FileWindow[this.m_fileWindows.size()];
        this.m_fileWindows.values().toArray(windows);
        FileWindow[] fileWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            FileWindow window = fileWindowArray[n2];
            this.m_desk.remove(window);
            window.dispose();
            ++n2;
        }
        this.m_desk.revalidate();
        this.m_desk.updateUI();
        this.m_fileWindows.clear();
        this.m_contextWindow.reset();
    }

    public Menubar getMenubar() {
        return this.m_menubar;
    }

    public void setExitAction(Runnable r) {
        this.m_exitAction = r;
    }

    public JSInternalConsole getConsole() {
        return this.m_console;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.m_console.consoleTextArea.requestFocus();
            this.m_contextWindow.m_split.setDividerLocation(0.5);
            try {
                this.m_console.setMaximum(true);
                this.m_console.setSelected(true);
                this.m_console.show();
                this.m_console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {}
        }
    }

    void addTopLevel(String key, JFrame frame) {
        if (frame != this) {
            this.m_toplevels.put(key, frame);
        }
    }

    private void init() {
        JButton stepOutButton;
        JButton stepOverButton;
        JButton stepIntoButton;
        JButton goButton;
        JButton breakButton;
        this.m_menubar = new Menubar(this);
        this.setJMenuBar(this.m_menubar);
        this.m_toolBar = new JToolBar();
        String[] toolTips = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int count = 0;
        JButton button = breakButton = new JButton("Break");
        button.setToolTipText("Break");
        button.setActionCommand("Break");
        button.addActionListener(this.m_menubar);
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button = goButton = new JButton("Go");
        button.setToolTipText("Go");
        button.setActionCommand("Go");
        button.addActionListener(this.m_menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepIntoButton = new JButton("Step Into");
        button.setToolTipText("Step Into");
        button.setActionCommand("Step Into");
        button.addActionListener(this.m_menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepOverButton = new JButton("Step Over");
        button.setToolTipText("Step Over");
        button.setActionCommand("Step Over");
        button.setEnabled(false);
        button.addActionListener(this.m_menubar);
        button.setToolTipText(toolTips[count++]);
        button = stepOutButton = new JButton("Step Out");
        button.setToolTipText("Step Out");
        button.setActionCommand("Step Out");
        button.setEnabled(false);
        button.addActionListener(this.m_menubar);
        button.setToolTipText(toolTips[count++]);
        Dimension dim = stepOverButton.getPreferredSize();
        breakButton.setPreferredSize(dim);
        breakButton.setMinimumSize(dim);
        breakButton.setMaximumSize(dim);
        breakButton.setSize(dim);
        goButton.setPreferredSize(dim);
        goButton.setMinimumSize(dim);
        goButton.setMaximumSize(dim);
        stepIntoButton.setPreferredSize(dim);
        stepIntoButton.setMinimumSize(dim);
        stepIntoButton.setMaximumSize(dim);
        stepOverButton.setPreferredSize(dim);
        stepOverButton.setMinimumSize(dim);
        stepOverButton.setMaximumSize(dim);
        stepOutButton.setPreferredSize(dim);
        stepOutButton.setMinimumSize(dim);
        stepOutButton.setMaximumSize(dim);
        this.m_toolBar.add(breakButton);
        this.m_toolBar.add(goButton);
        this.m_toolBar.add(stepIntoButton);
        this.m_toolBar.add(stepOverButton);
        this.m_toolBar.add(stepOutButton);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_toolBar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        this.m_desk = new JDesktopPane();
        this.m_desk.setPreferredSize(new Dimension(600, 300));
        this.m_desk.setMinimumSize(new Dimension(150, 50));
        this.m_console = new JSInternalConsole("JavaScript Console");
        this.m_desk.add(this.m_console);
        this.m_contextWindow = new ContextWindow(this);
        this.m_contextWindow.setPreferredSize(new Dimension(600, 120));
        this.m_contextWindow.setMinimumSize(new Dimension(50, 50));
        this.m_split1 = new JSplitPane(0, this.m_desk, this.m_contextWindow);
        this.m_split1.setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.m_split1, 0.66);
        contentPane.add((Component)this.m_split1, "Center");
        this.m_statusBar = new JLabel();
        this.m_statusBar.setText("Thread: ");
        contentPane.add((Component)this.m_statusBar, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingGui.this.exit();
            }
        });
    }

    public static void initFileChooser() {
        if (s_fileChooserDlg != null) {
            return;
        }
        s_fileChooserDlg = new JFileChooser();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String ext;
                if (f.isDirectory()) {
                    return true;
                }
                String n = f.getName();
                int i = n.lastIndexOf(46);
                return i > 0 && i < n.length() - 1 && (ext = n.substring(i + 1).toLowerCase()).equals("js");
            }

            @Override
            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        s_fileChooserDlg.addChoosableFileFilter(filter);
    }

    private void exit() {
        if (this.m_exitAction != null) {
            SwingUtilities.invokeLater(this.m_exitAction);
        }
        try {
            if (this.m_debuggerControl != null) {
                this.m_debuggerControl.setReturnValue(5);
            } else {
                System.exit(0);
            }
        }
        catch (RemoteException remoteException) {}
    }

    FileWindow getFileWindow(String url) {
        if (url == null || url.equals("<stdin>")) {
            return null;
        }
        return this.m_fileWindows.get(url);
    }

    static String getShortName(String url) {
        int lastSlash = url.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = url.lastIndexOf(92);
        }
        String shortName = url;
        if (lastSlash >= 0 && lastSlash + 1 < url.length()) {
            shortName = url.substring(lastSlash + 1);
        }
        return shortName;
    }

    void removeWindow(FileWindow w) {
        this.m_fileWindows.remove(w.getUrl());
        JMenu windowMenu = this.getWindowMenu();
        int count = windowMenu.getItemCount();
        JMenuItem lastItem = windowMenu.getItem(count - 1);
        String name = SwingGui.getShortName(w.getUrl());
        int i = 5;
        while (i < count) {
            int pos;
            String text;
            JMenuItem item = windowMenu.getItem(i);
            if (item != null && (text = item.getText()).substring((pos = text.indexOf(32)) + 1).equals(name)) {
                windowMenu.remove(item);
                if (count == 6) {
                    windowMenu.remove(4);
                    break;
                }
                int j = i - 4;
                while (i < count - 1) {
                    JMenuItem thisItem = windowMenu.getItem(i);
                    if (thisItem != null) {
                        text = thisItem.getText();
                        if (text.equals("More Windows...")) break;
                        pos = text.indexOf(32);
                        thisItem.setText(String.valueOf((char)(48 + j)) + " " + text.substring(pos + 1));
                        thisItem.setMnemonic(48 + j);
                        ++j;
                    }
                    ++i;
                }
                if (count - 6 != 0 || lastItem == item || !lastItem.getText().equals("More Windows...")) break;
                windowMenu.remove(lastItem);
                break;
            }
            ++i;
        }
        windowMenu.revalidate();
    }

    void showStopLine(String sourceName, int lineNumber) {
        if (sourceName == null || sourceName.equals("<stdin>")) {
            if (this.m_console.isVisible()) {
                this.m_console.show();
            }
        } else {
            this.showFileWindow(sourceName, -1);
            FileWindow w = this.getFileWindow(sourceName);
            if (w != null) {
                this.setFilePosition(w, lineNumber);
            }
        }
    }

    protected void showFileWindow(String sourceUrl, int lineNumber) {
        FileWindow w = this.getFileWindow(sourceUrl);
        if (w == null) {
            try {
                ISourceInfo si = this.m_debuggerControl.getSourceInfo(sourceUrl);
                this.createFileWindow(si, -1);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            w = this.getFileWindow(sourceUrl);
        }
        if (lineNumber > -1) {
            int start = w.getPosition(lineNumber - 1);
            int end = w.getPosition(lineNumber) - 1;
            w.m_textArea.select(start);
            w.m_textArea.setCaretPosition(start);
            w.m_textArea.moveCaretPosition(end);
        }
        try {
            if (w.isIcon()) {
                w.setIcon(false);
            }
            w.setVisible(true);
            w.moveToFront();
            w.setSelected(true);
            this.requestFocus();
            w.requestFocus();
            w.m_textArea.requestFocus();
        }
        catch (Exception exception) {}
    }

    protected void createFileWindow(ISourceInfo sourceInfo, int line) throws RemoteException {
        boolean activate = true;
        String url = sourceInfo.getUri();
        FileWindow w = new FileWindow(this, sourceInfo);
        this.m_fileWindows.put(url, w);
        if (line != -1) {
            if (this.m_currentWindow != null) {
                this.m_currentWindow.setPosition(-1);
            }
            try {
                w.setPosition(w.m_textArea.getLineStartOffset(line - 1));
            }
            catch (BadLocationException badLocationException) {
                try {
                    w.setPosition(w.m_textArea.getLineStartOffset(0));
                }
                catch (BadLocationException badLocationException2) {
                    w.setPosition(-1);
                }
            }
        }
        this.m_desk.add(w);
        if (line != -1) {
            this.m_currentWindow = w;
        }
        this.m_menubar.addFile(url);
        w.setVisible(true);
        if (activate) {
            try {
                w.setMaximum(true);
                w.setSelected(true);
                w.moveToFront();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean updateFileWindow(ISourceInfo sourceInfo) throws RemoteException {
        String fileName = sourceInfo.getUri();
        FileWindow w = this.getFileWindow(fileName);
        if (w != null) {
            w.updateText(sourceInfo);
            w.show();
            return true;
        }
        return false;
    }

    private void setFilePosition(FileWindow w, int line) {
        boolean activate = true;
        FileTextArea ta = w.m_textArea;
        try {
            if (line == -1) {
                w.setPosition(-1);
                if (this.m_currentWindow == w) {
                    this.m_currentWindow = null;
                }
            } else {
                int loc = ta.getLineStartOffset(line - 1);
                if (this.m_currentWindow != null && this.m_currentWindow != w) {
                    this.m_currentWindow.setPosition(-1);
                }
                w.setPosition(loc);
                this.m_currentWindow = w;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (activate) {
            if (w.isIcon()) {
                this.m_desk.getDesktopManager().deiconifyFrame(w);
            }
            this.m_desk.getDesktopManager().activateFrame(w);
            try {
                w.show();
                w.toFront();
                w.setSelected(true);
            }
            catch (Exception exception) {}
        }
    }

    void enterInterruptImpl(StackFrameInfo frameInfo, String threadTitle, String alertMessage) throws RemoteException {
        this.m_statusBar.setText("Thread: " + threadTitle);
        this.showStopLine(frameInfo.getSourceName(), frameInfo.getLineNumber());
        if (alertMessage != null) {
            MessageDialogWrapper.showMessageDialog(this, alertMessage, "Exception in Script", 0);
        }
        this.updateEnabled(true);
        JComboBox ctx = this.m_contextWindow.m_context;
        Vector<String> toolTips = this.m_contextWindow.m_toolTips;
        this.m_contextWindow.disableUpdate();
        int frameCount = this.m_debuggerControl.getFrameCount();
        ctx.removeAllItems();
        ctx.setSelectedItem(null);
        toolTips.removeAllElements();
        int i = 0;
        while (i < frameCount) {
            StackFrameInfo frame = this.m_debuggerControl.getFrameInfo(i);
            String url = frame.getSourceName();
            int lineNumber = frame.getLineNumber();
            String shortName = url;
            if (url.length() > 20) {
                shortName = "..." + url.substring(url.length() - 17);
            }
            String location = "\"" + shortName + "\", line " + lineNumber;
            ctx.insertItemAt(location, i);
            location = "\"" + url + "\", line " + lineNumber;
            toolTips.addElement(location);
            ++i;
        }
        this.m_contextWindow.enableUpdate();
        ctx.setSelectedIndex(0);
        ctx.setMinimumSize(new Dimension(50, ctx.getMinimumSize().height));
    }

    private JMenu getWindowMenu() {
        return this.m_menubar.getMenu(3);
    }

    private String chooseFile(String title) {
        int returnVal;
        if (s_fileChooserDlg == null) {
            return null;
        }
        s_fileChooserDlg.setDialogTitle(title);
        File CWD = null;
        String dir = System.getProperty("user.dir");
        if (dir != null) {
            CWD = new File(dir);
        }
        if (CWD != null) {
            s_fileChooserDlg.setCurrentDirectory(CWD);
        }
        if ((returnVal = s_fileChooserDlg.showOpenDialog(this)) == 0) {
            try {
                String result = s_fileChooserDlg.getSelectedFile().getCanonicalPath();
                CWD = s_fileChooserDlg.getSelectedFile().getParentFile();
                Properties props = System.getProperties();
                props.put("user.dir", CWD.getPath());
                System.setProperties(props);
                return result;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {}
        }
        return null;
    }

    private JInternalFrame getSelectedFrame() {
        JInternalFrame[] frames = this.m_desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                return frames[i];
            }
            ++i;
        }
        return frames[frames.length - 1];
    }

    private void updateEnabled(boolean interrupted) {
        ((Menubar)this.getJMenuBar()).updateEnabled(interrupted);
        int ci = 0;
        int cc = this.m_toolBar.getComponentCount();
        while (ci < cc) {
            boolean enableButton = ci == 0 ? !interrupted : interrupted;
            this.m_toolBar.getComponent(ci).setEnabled(enableButton);
            ++ci;
        }
        if (interrupted) {
            this.m_toolBar.setEnabled(true);
            int state = this.getExtendedState();
            if (state == 1) {
                this.setExtendedState(0);
            }
            this.toFront();
            this.m_contextWindow.enable();
        } else {
            if (this.m_currentWindow != null) {
                this.m_currentWindow.setPosition(-1);
            }
            this.m_contextWindow.disable();
        }
    }

    static void setResizeWeight(JSplitPane pane, double weight) {
        try {
            Method m = JSplitPane.class.getMethod("setResizeWeight", Double.TYPE);
            m.invoke((Object)pane, new Double(weight));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    private String readFile(String fileName) {
        String text;
        try {
            FileReader r = new FileReader(fileName);
            try {
                text = Kit.readReader((Reader)r);
            }
            finally {
                ((Reader)r).close();
            }
        }
        catch (IOException ex) {
            MessageDialogWrapper.showMessageDialog(this, ex.getMessage(), "Error reading " + fileName, 0);
            text = null;
        }
        return text;
    }

    public void updateSourceText(ISourceInfo sourceInfo) {
        RunProxy proxy = new RunProxy(this, 3);
        proxy.m_sourceInfo = sourceInfo;
        SwingUtilities.invokeLater(proxy);
    }

    public void enterInterrupt(StackFrameInfo frameInfo, String threadTitle, String alertMessage) throws RemoteException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enterInterruptImpl(frameInfo, threadTitle, alertMessage);
        } else {
            RunProxy proxy = new RunProxy(this, 4);
            proxy.m_lastFrame = frameInfo;
            proxy.m_threadTitle = threadTitle;
            proxy.m_alertMessage = alertMessage;
            SwingUtilities.invokeLater(proxy);
        }
    }

    public boolean isGuiEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public void dispatchNextGuiEvent() throws InterruptedException {
        AWTEvent event;
        EventQueue queue = this.m_awtEventQueue;
        if (queue == null) {
            this.m_awtEventQueue = queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        if ((event = queue.getNextEvent()) instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else {
            Object source = event.getSource();
            if (source instanceof Component) {
                Component comp = (Component)source;
                comp.dispatchEvent(event);
            } else if (source instanceof MenuComponent) {
                ((MenuComponent)source).dispatchEvent(event);
            }
        }
    }

    public int[] getBreakPoints(String url) {
        BreakpointCache.Breakpoints bpCache = BreakpointCache.getBreakpoints(url);
        if (bpCache == null) {
            return null;
        }
        return bpCache.getBreakpoints();
    }

    public void detach(boolean shutdown) {
        this.clear();
        if (shutdown) {
            this.setVisible(false);
            this.dispose();
        }
        this.m_debuggerControl = null;
    }

    public void actionPerformed(ActionEvent e) {
        JDialog dlg;
        String fileName;
        String cmd = e.getActionCommand();
        int returnValue = -1;
        if (cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste")) {
            JInternalFrame f = this.getSelectedFrame();
            if (f != null && f instanceof ActionListener) {
                ((ActionListener)((Object)f)).actionPerformed(e);
            }
        } else if (cmd.equals("Step Over")) {
            returnValue = 0;
        } else if (cmd.equals("Step Into")) {
            returnValue = 1;
        } else if (cmd.equals("Step Out")) {
            returnValue = 2;
        } else if (cmd.equals("Go")) {
            returnValue = 3;
        } else if (cmd.equals("Break")) {
            try {
                this.m_debuggerControl.setBreak();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        } else if (cmd.equals("Exit")) {
            this.exit();
        } else if (cmd.equals("Open")) {
            String text;
            fileName = this.chooseFile("Select a file to compile");
            if (fileName != null && (text = this.readFile(fileName)) != null) {
                RunProxy proxy = new RunProxy(this, 1);
                proxy.m_fileName = fileName;
                proxy.m_text = text;
                new Thread(proxy).start();
            }
        } else if (cmd.equals("Load")) {
            String text;
            fileName = this.chooseFile("Select a file to execute");
            if (fileName != null && (text = this.readFile(fileName)) != null) {
                RunProxy proxy = new RunProxy(this, 2);
                proxy.m_fileName = fileName;
                proxy.m_text = text;
                new Thread(proxy).start();
            }
        } else if (cmd.equals("More Windows...")) {
            dlg = new MoreWindows(this, this.m_fileWindows, "Window", "Files");
            ((MoreWindows)dlg).showDialog(this);
        } else if (cmd.equals("Console")) {
            if (this.m_console.isIcon()) {
                this.m_desk.getDesktopManager().deiconifyFrame(this.m_console);
            }
            this.m_console.show();
            this.m_desk.getDesktopManager().activateFrame(this.m_console);
            this.m_console.consoleTextArea.requestFocus();
        } else if (!(cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste"))) {
            JInternalFrame[] frames;
            if (cmd.equals("Go to function...")) {
                dlg = new FindFunction(this, "Go to function", "Function");
                ((FindFunction)dlg).showDialog(this);
            } else if (cmd.equals("Tile")) {
                frames = this.m_desk.getAllFrames();
                int count = frames.length;
                int cols = (int)Math.sqrt(count);
                int rows = cols;
                if (rows * cols < count && rows * ++cols < count) {
                    ++rows;
                }
                Dimension size = this.m_desk.getSize();
                int w = size.width / cols;
                int h = size.height / rows;
                int x = 0;
                int y = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < cols) {
                        int index = i * cols + j;
                        if (index >= frames.length) break;
                        JInternalFrame f = frames[index];
                        try {
                            f.setIcon(false);
                            f.setMaximum(false);
                        }
                        catch (Exception exception) {}
                        this.m_desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                        x += w;
                        ++j;
                    }
                    y += h;
                    x = 0;
                    ++i;
                }
            } else if (cmd.equals("Cascade")) {
                frames = this.m_desk.getAllFrames();
                int count = frames.length;
                int y = 0;
                int x = 0;
                int h = this.m_desk.getHeight();
                int d = h / count;
                if (d > 30) {
                    d = 30;
                }
                int i = count - 1;
                while (i >= 0) {
                    JInternalFrame f = frames[i];
                    try {
                        f.setIcon(false);
                        f.setMaximum(false);
                    }
                    catch (Exception exception) {}
                    Dimension dimen = f.getPreferredSize();
                    int w = dimen.width;
                    h = dimen.height;
                    this.m_desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                    --i;
                    x += d;
                    y += d;
                }
            } else {
                FileWindow obj = this.getFileWindow(cmd);
                if (obj != null) {
                    FileWindow w = obj;
                    try {
                        if (w.isIcon()) {
                            w.setIcon(false);
                        }
                        w.setVisible(true);
                        w.moveToFront();
                        w.setSelected(true);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (returnValue != -1) {
            this.updateEnabled(false);
            try {
                this.m_debuggerControl.setReturnValue(returnValue);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
    }
}

