/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.config.ListenerConfig;
import org.eclipse.vjet.dsf.common.trace.config.ListenerKey;
import org.eclipse.vjet.dsf.common.trace.config.TracerConfig;
import org.eclipse.vjet.dsf.common.trace.listener.DefaultTraceEventListener;
import org.eclipse.vjet.dsf.common.trace.listener.ListenerId;
import org.eclipse.vjet.dsf.common.tracer.TraceManager;

public final class TraceConfigMgr {
    public static final String ID = "org.eclipse.vjet.dsf.common.trace.config";
    public static final String ALIAS = "v4trace";
    public static final String GROUP = "v4.dsf";
    public static final String DESC = "v4 trace config";
    public static final String PTY_ENABLE_TRACE = "EnableTrace";
    public static final String PTY_ENABLE_VERBOSE = "EnableVerbose";
    public static final String PTY_PREFIX_ENABLE = "Enable_";
    public static final String PTY_PREFIX_ADD_FILTER_TO_TRACER = "AddFilterToTracer_";
    public static final String PTY_PREFIX_REMOVE_FILTER_FROM_TRACER = "RemoveFilterFromTracer_";
    public static final String PTY_PREFIX_ADD_LISTENER = "AddListener_";
    public static final String PTY_PREFIX_REMOVE_LISTENER = "RemoveListener_";
    public static final String PTY_PREFIX_ADD_FILTER_TO_LISTENER = "AddFilterToListener_";
    public static final String PTY_PREFIX_REMOVE_FILTER_FROM_LISTENER = "RemoveFilterFromListener_";
    public static final String PTY_PREFIX_ADD_HANDLER = "AddHandler_";
    public static final String PTY_PREFIX_REMOVE_HANDLER = "RemoveHandler_";
    public static final String DELIMITER = ":";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private boolean m_isTraceOn;
    private boolean m_isVerboseOn;
    private List<String> m_enabledScopes = new ArrayList<String>(1);
    private List<String> m_disabledScopes = new ArrayList<String>(1);
    private Map<String, TracerConfig> m_tracerConfigs = new HashMap<String, TracerConfig>(1);
    private Map<ListenerKey, ListenerConfig> m_listenerConfigs = new HashMap<ListenerKey, ListenerConfig>(1);
    private static TraceConfigMgr s_instance = new TraceConfigMgr();

    private TraceConfigMgr() {
        this.reset();
    }

    public static TraceConfigMgr getInstance() {
        return s_instance;
    }

    public void setTraceOn(boolean isTraceOn) {
        this.m_isTraceOn = isTraceOn;
    }

    public boolean isVerboseOn() {
        return this.m_isVerboseOn;
    }

    public void setVerboseOn(boolean isVerboseOn) {
        this.m_isVerboseOn = isVerboseOn;
    }

    public boolean isTraceOn() {
        return this.m_isTraceOn;
    }

    public synchronized void setEnabled(Class callingClass, Boolean enable) {
        if (callingClass == null) {
            return;
        }
        this.setEnabled(TraceManager.getScope(callingClass), enable);
    }

    public synchronized void setEnabled(String scope, Boolean enable) {
        if (scope == null) {
            return;
        }
        if (Boolean.TRUE.equals(enable)) {
            if (!this.m_enabledScopes.contains(scope)) {
                this.m_enabledScopes.add(scope);
                if (this.m_disabledScopes.contains(scope)) {
                    this.m_disabledScopes.remove(scope);
                }
            }
        } else if (Boolean.FALSE.equals(enable)) {
            if (!this.m_disabledScopes.contains(scope)) {
                this.m_disabledScopes.add(scope);
                if (this.m_enabledScopes.contains(scope)) {
                    this.m_enabledScopes.remove(scope);
                }
            }
        } else {
            this.m_enabledScopes.remove(scope);
            this.m_disabledScopes.remove(scope);
        }
    }

    public synchronized List<String> getEnabledScopes() {
        return Collections.unmodifiableList(this.m_enabledScopes);
    }

    public synchronized List<String> getDisabledScopes() {
        return Collections.unmodifiableList(this.m_disabledScopes);
    }

    public synchronized TracerConfig getTracerConfig(String scope) {
        return this.getTracerConfig(scope, false);
    }

    public synchronized TracerConfig getTracerConfig(String scope, boolean create) {
        TracerConfig config;
        if (scope == null) {
            DsfExceptionHelper.chuck((String)"scope is null");
        }
        if ((config = this.m_tracerConfigs.get(scope)) == null && create) {
            config = new TracerConfig(scope);
            this.m_tracerConfigs.put(scope, config);
        }
        return config;
    }

    public synchronized void removeTracerConfig(String scope) {
        this.m_tracerConfigs.remove(scope);
    }

    public synchronized ListenerConfig getListenerConfig(ListenerKey listenerKey) {
        return this.getListenerConfig(listenerKey, false);
    }

    public synchronized ListenerConfig getListenerConfig(ListenerKey listenerKey, boolean create) {
        ListenerConfig config;
        if (listenerKey == null) {
            DsfExceptionHelper.chuck((String)"listenerKey is null");
        }
        if ((config = this.m_listenerConfigs.get(listenerKey)) == null && create) {
            config = new ListenerConfig(listenerKey);
            this.m_listenerConfigs.put(listenerKey, config);
        }
        return config;
    }

    public synchronized void removeListenerConfig(ListenerKey listenerKey) {
        this.m_listenerConfigs.remove(listenerKey);
    }

    public void reset() {
        this.m_isTraceOn = false;
        this.m_isVerboseOn = false;
        this.m_enabledScopes.clear();
        this.m_disabledScopes.clear();
        this.m_tracerConfigs.clear();
        this.m_listenerConfigs.clear();
        this.m_enabledScopes.add("");
        this.getTracerConfig("", true).addListener(new ListenerKey(DefaultTraceEventListener.class, new ListenerId("DefaultListenerForRoot")));
    }
}

