/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.utility.tests.ClassToolsTests;

public class ClassToolsTests
extends TestCase {
    private static String testStaticField;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.ClassToolsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.ClassToolsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ClassToolsTests(String name) {
        super(name);
    }

    public static String compilerDependentClassNameFor(String className) {
        int index = className.indexOf("$1$");
        if (index == -1) {
            return className;
        }
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return String.valueOf(className.substring(0, index + 2)) + className.substring(index + 3);
        }
        return className;
    }

    private static String munge(String className) {
        return ClassToolsTests.compilerDependentClassNameFor(className);
    }

    public void testAllFields() {
        int fieldCount = 0;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fieldCount += clazz.getDeclaredFields().length;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.AbstractList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fieldCount += clazz2.getDeclaredFields().length;
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.util.AbstractCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fieldCount += clazz3.getDeclaredFields().length;
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fieldCount += clazz4.getDeclaredFields().length;
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = ClassTools.allFields((Class)clazz5);
        ClassToolsTests.assertEquals((int)fieldCount, (int)fields.length);
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.names(fields), (Object)"modCount"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.names(fields), (Object)"serialVersionUID"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.names(fields), (Object)"capacityIncrement"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.names(fields), (Object)"elementCount"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.names(fields), (Object)"elementData"));
        ClassToolsTests.assertTrue((boolean)fields[0].isAccessible());
    }

    public void testAllMethods() {
        int methodCount = 0;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        methodCount += clazz.getDeclaredMethods().length;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.AbstractList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        methodCount += clazz2.getDeclaredMethods().length;
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.util.AbstractCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        methodCount += clazz3.getDeclaredMethods().length;
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        methodCount += clazz4.getDeclaredMethods().length;
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method[] methods = ClassTools.allMethods((Class)clazz5);
        ClassToolsTests.assertEquals((int)methodCount, (int)methods.length);
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.names(methods), (Object)"wait"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.names(methods), (Object)"addElement"));
        ClassToolsTests.assertTrue((boolean)methods[0].isAccessible());
    }

    public void testNewInstanceClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Vector v = (Vector)ClassTools.newInstance((Class)clazz);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
    }

    public void testNewInstanceClassClassObject() {
        int initialCapacity = 200;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Vector v = (Vector)ClassTools.newInstance(clazz, Integer.TYPE, (Object)new Integer(initialCapacity));
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ClassTools.getFieldValue((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
    }

    public void testNewInstanceClassClassArrayObjectArray() {
        int initialCapacity = 200;
        Class[] parmTypes = new Class[]{Integer.TYPE};
        Object[] parms = new Object[]{new Integer(initialCapacity)};
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Vector v = (Vector)ClassTools.newInstance((Class)clazz, (Class[])parmTypes, (Object[])parms);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ClassTools.getFieldValue((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
        parms[0] = new Integer(-1);
        boolean exCaught = false;
        try {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.util.Vector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            v = (Vector)ClassTools.newInstance((Class)clazz2, (Class[])parmTypes, (Object[])parms);
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"RuntimeException not thrown", (boolean)exCaught);
        Class<?> clazz3 = class$6;
        if (clazz3 == null) {
            try {
                clazz3 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        parmTypes[0] = clazz3;
        parms[0] = "foo";
        exCaught = false;
        try {
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.util.Vector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            v = (Vector)ClassTools.attemptNewInstance((Class)clazz4, (Class[])parmTypes, (Object[])parms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"NoSuchMethodException not thrown", (boolean)exCaught);
    }

    public void testGetFieldValue() {
        int initialCapacity = 200;
        Vector v = new Vector(initialCapacity);
        Object[] elementData = (Object[])ClassTools.getFieldValue(v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
        Integer modCountInteger = (Integer)ClassTools.getFieldValue(v, (String)"modCount");
        int modCount = modCountInteger;
        ClassToolsTests.assertEquals((int)0, (int)modCount);
        boolean exCaught = false;
        Object bogusFieldValue = null;
        try {
            bogusFieldValue = ClassTools.attemptToGetFieldValue(v, (String)"bogusField");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchFieldException not thrown: " + bogusFieldValue), (boolean)exCaught);
    }

    public void testInvokeMethodObjectString() {
        Vector<String> v = new Vector<String>();
        int size = (Integer)ClassTools.invokeMethod(v, (String)"size");
        ClassToolsTests.assertEquals((int)0, (int)size);
        v.addElement("foo");
        size = (Integer)ClassTools.invokeMethod(v, (String)"size");
        ClassToolsTests.assertEquals((int)1, (int)size);
    }

    public void testInvokeMethodObjectStringClassObject() {
        Vector v = new Vector();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean booleanResult = (Boolean)ClassTools.invokeMethod(v, (String)"add", (Class)clazz, (Object)"foo");
        ClassToolsTests.assertTrue((boolean)booleanResult);
        ClassToolsTests.assertTrue((boolean)v.contains("foo"));
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object voidResult = ClassTools.invokeMethod(v, (String)"addElement", (Class)clazz2, (Object)"bar");
        ClassToolsTests.assertNull((Object)voidResult);
    }

    public void testInvokeMethodObjectStringClassArrayObjectArray() {
        Vector v = new Vector();
        Class[] parmTypes = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        parmTypes[0] = clazz;
        Object[] parms = new Object[]{"foo"};
        boolean booleanResult = (Boolean)ClassTools.invokeMethod(v, (String)"add", (Class[])parmTypes, (Object[])parms);
        ClassToolsTests.assertTrue((boolean)booleanResult);
        ClassToolsTests.assertTrue((boolean)v.contains("foo"));
        boolean exCaught = false;
        Object bogusMethodReturnValue = null;
        try {
            bogusMethodReturnValue = ClassTools.attemptToInvokeMethod(v, (String)"bogusMethod", (Class[])parmTypes, (Object[])parms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusMethodReturnValue), (boolean)exCaught);
    }

    public void testInvokeStaticMethodClassString() {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.lang.Math");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Double randomObject = (Double)ClassTools.invokeStaticMethod((Class)clazz, (String)"random");
        ClassToolsTests.assertNotNull((Object)randomObject);
        double random = randomObject;
        ClassToolsTests.assertTrue((random >= 0.0 ? 1 : 0) != 0);
        ClassToolsTests.assertTrue((random < 1.0 ? 1 : 0) != 0);
    }

    public void testInvokeStaticMethodClassStringClassObject() {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String s = (String)ClassTools.invokeStaticMethod((Class)clazz, (String)"valueOf", Boolean.TYPE, (Object)Boolean.TRUE);
        ClassToolsTests.assertNotNull((Object)s);
        ClassToolsTests.assertEquals((String)"true", (String)s);
    }

    public void testInvokeStaticMethodClassStringClassArrayObjectArray() {
        Class[] parmTypes = new Class[]{Boolean.TYPE};
        Object[] parms = new Object[]{Boolean.TRUE};
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String s = (String)ClassTools.invokeStaticMethod((Class)clazz, (String)"valueOf", (Class[])parmTypes, (Object[])parms);
        ClassToolsTests.assertNotNull((Object)s);
        ClassToolsTests.assertEquals((String)"true", (String)s);
        boolean exCaught = false;
        Object bogusStaticMethodReturnValue = null;
        try {
            Class<?> clazz2 = class$6;
            if (clazz2 == null) {
                try {
                    clazz2 = class$6 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bogusStaticMethodReturnValue = ClassTools.attemptToInvokeStaticMethod((Class)clazz2, (String)"bogusStaticMethod", (Class[])parmTypes, (Object[])parms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
        exCaught = false;
        try {
            Class<?> clazz3 = class$6;
            if (clazz3 == null) {
                try {
                    clazz3 = class$6 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bogusStaticMethodReturnValue = ClassTools.attemptToInvokeStaticMethod((Class)clazz3, (String)"toString");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
    }

    public void testSetFieldValue() {
        Vector v = new Vector();
        Object[] newElementData = new Object[5];
        newElementData[0] = "foo";
        ClassTools.setFieldValue(v, (String)"elementData", (Object)newElementData);
        ClassTools.setFieldValue(v, (String)"elementCount", (Object)new Integer(1));
        ClassTools.setFieldValue(v, (String)"modCount", (Object)new Integer(1));
        ClassToolsTests.assertTrue((boolean)v.contains("foo"));
        boolean exCaught = false;
        try {
            ClassTools.attemptToSetFieldValue(v, (String)"bogusField", (Object)"foo");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }

    public void testSetStaticFieldValue() {
        ClassTools.setStaticFieldValue(((Object)((Object)this)).getClass(), (String)"testStaticField", (Object)"new value");
        ClassToolsTests.assertEquals((String)testStaticField, (String)"new value");
        boolean exCaught = false;
        try {
            ClassTools.attemptToSetStaticFieldValue(((Object)((Object)this)).getClass(), (String)"bogusStaticField", (Object)"new value");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }

    public void testShortName() {
        ClassToolsTests.assertEquals((String)"Vector", (String)ClassTools.shortClassNameForObject(new Vector()));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)"Vector", (String)ClassTools.shortNameFor((Class)clazz));
    }

    public void testNestedName() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        Map.Entry entry = map.entrySet().iterator().next();
        ClassToolsTests.assertEquals((String)"Entry", (String)ClassTools.nestedClassNameForObject(entry));
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)"Entry", (String)ClassTools.nestedNameFor((Class)clazz));
    }

    public void testPackageName() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)"java.util", (String)ClassTools.packageNameFor((Class)clazz));
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)"java.util", (String)ClassTools.packageNameFor((Class)clazz2));
    }

    public void testArrayDepthFor() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthFor((Class)clazz));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthFor(Integer.TYPE));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthFor(Void.TYPE));
        Class<?> clazz2 = class$11;
        if (clazz2 == null) {
            try {
                clazz2 = class$11 = Class.forName("[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthFor((Class)clazz2));
        Class<?> clazz3 = class$12;
        if (clazz3 == null) {
            try {
                clazz3 = class$12 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthFor((Class)clazz3));
        Class<?> clazz4 = class$13;
        if (clazz4 == null) {
            try {
                clazz4 = class$13 = Class.forName("[[[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthFor((Class)clazz4));
        Class<?> clazz5 = class$14;
        if (clazz5 == null) {
            try {
                clazz5 = class$14 = Class.forName("[[[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthFor((Class)clazz5));
    }

    public void testArrayDepthForObject() {
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForObject(new Vector()));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForObject((Object)new Vector[0]));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForObject((Object)new int[0]));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForObject((Object)new Vector[0][0][0]));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForObject((Object)new int[0][0][0]));
    }

    public void testArrayDepthForClassNamed() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForClassNamed((String)clazz.getName()));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForClassNamed((String)Integer.TYPE.getName()));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForClassNamed((String)Void.TYPE.getName()));
        Class<?> clazz2 = class$11;
        if (clazz2 == null) {
            try {
                clazz2 = class$11 = Class.forName("[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForClassNamed((String)clazz2.getName()));
        Class<?> clazz3 = class$12;
        if (clazz3 == null) {
            try {
                clazz3 = class$12 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForClassNamed((String)clazz3.getName()));
        Class<?> clazz4 = class$13;
        if (clazz4 == null) {
            try {
                clazz4 = class$13 = Class.forName("[[[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForClassNamed((String)clazz4.getName()));
        Class<?> clazz5 = class$14;
        if (clazz5 == null) {
            try {
                clazz5 = class$14 = Class.forName("[[[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForClassNamed((String)clazz5.getName()));
    }

    public void testElementTypeFor() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$1) == null) {
            try {
                clazz3 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals(clazz4, (Object)ClassTools.elementTypeFor((Class)clazz3));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeFor(Integer.TYPE));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.elementTypeFor(Void.TYPE));
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$11) == null) {
            try {
                clazz2 = class$11 = Class.forName("[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals(clazz5, (Object)ClassTools.elementTypeFor((Class)clazz2));
        Class<?> clazz6 = class$12;
        if (clazz6 == null) {
            try {
                clazz6 = class$12 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeFor((Class)clazz6));
        Class<?> clazz7 = class$1;
        if (clazz7 == null) {
            try {
                clazz7 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$13) == null) {
            try {
                clazz = class$13 = Class.forName("[[[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals(clazz7, (Object)ClassTools.elementTypeFor((Class)clazz));
        Class<?> clazz8 = class$14;
        if (clazz8 == null) {
            try {
                clazz8 = class$14 = Class.forName("[[[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeFor((Class)clazz8));
    }

    public void testElementTypeForObject() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals(clazz, (Object)ClassTools.elementTypeForObject(new Vector()));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((Object)clazz2, (Object)ClassTools.elementTypeForObject((Object)new Vector[0]));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeForObject((Object)new int[0]));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals(clazz3, (Object)ClassTools.elementTypeForObject((Object)new Vector[0][0][0]));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeForObject((Object)new int[0][0][0]));
    }

    public void testElementTypeNameFor() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string, (String)ClassTools.elementTypeNameFor((Class)clazz2));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameFor(Integer.TYPE));
        ClassToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassTools.elementTypeNameFor(Void.TYPE));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string2 = clazz3.getName();
        Class<?> clazz4 = class$11;
        if (clazz4 == null) {
            try {
                clazz4 = class$11 = Class.forName("[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string2, (String)ClassTools.elementTypeNameFor((Class)clazz4));
        String string3 = Integer.TYPE.getName();
        Class<?> clazz5 = class$12;
        if (clazz5 == null) {
            try {
                clazz5 = class$12 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string3, (String)ClassTools.elementTypeNameFor((Class)clazz5));
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string4 = clazz6.getName();
        Class<?> clazz7 = class$13;
        if (clazz7 == null) {
            try {
                clazz7 = class$13 = Class.forName("[[[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string4, (String)ClassTools.elementTypeNameFor((Class)clazz7));
        String string5 = Integer.TYPE.getName();
        Class<?> clazz8 = class$14;
        if (clazz8 == null) {
            try {
                clazz8 = class$14 = Class.forName("[[[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string5, (String)ClassTools.elementTypeNameFor((Class)clazz8));
    }

    public void testElementTypeNameForClassNamed() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string, (String)ClassTools.elementTypeNameForClassNamed((String)clazz2.getName()));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)Integer.TYPE.getName()));
        ClassToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)Void.TYPE.getName()));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string2 = clazz3.getName();
        Class<?> clazz4 = class$11;
        if (clazz4 == null) {
            try {
                clazz4 = class$11 = Class.forName("[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string2, (String)ClassTools.elementTypeNameForClassNamed((String)clazz4.getName()));
        String string3 = Integer.TYPE.getName();
        Class<?> clazz5 = class$12;
        if (clazz5 == null) {
            try {
                clazz5 = class$12 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string3, (String)ClassTools.elementTypeNameForClassNamed((String)clazz5.getName()));
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string4 = clazz6.getName();
        Class<?> clazz7 = class$13;
        if (clazz7 == null) {
            try {
                clazz7 = class$13 = Class.forName("[[[Ljava.util.Vector;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string4, (String)ClassTools.elementTypeNameForClassNamed((String)clazz7.getName()));
        String string5 = Integer.TYPE.getName();
        Class<?> clazz8 = class$14;
        if (clazz8 == null) {
            try {
                clazz8 = class$14 = Class.forName("[[[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)string5, (String)ClassTools.elementTypeNameForClassNamed((String)clazz8.getName()));
    }

    public void testClassCodes() {
        ClassToolsTests.assertEquals((String)"byte", (String)ClassTools.classNameForCode((char)'B'));
        ClassToolsTests.assertEquals((String)"char", (String)ClassTools.classNameForCode((char)'C'));
        ClassToolsTests.assertEquals((String)"double", (String)ClassTools.classNameForCode((char)'D'));
        ClassToolsTests.assertEquals((String)"float", (String)ClassTools.classNameForCode((char)'F'));
        ClassToolsTests.assertEquals((String)"int", (String)ClassTools.classNameForCode((char)'I'));
        ClassToolsTests.assertEquals((String)"long", (String)ClassTools.classNameForCode((char)'J'));
        ClassToolsTests.assertEquals((String)"short", (String)ClassTools.classNameForCode((char)'S'));
        ClassToolsTests.assertEquals((String)"boolean", (String)ClassTools.classNameForCode((char)'Z'));
        ClassToolsTests.assertEquals((String)"void", (String)ClassTools.classNameForCode((char)'V'));
        boolean exCaught = false;
        try {
            ClassTools.classNameForCode((char)'X');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"IllegalArgumentException not thrown", (boolean)exCaught);
    }

    public void testClassNamedIsTopLevel() throws Exception {
        Class<?> clazz = class$15;
        if (clazz == null) {
            try {
                clazz = class$15 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsTopLevel((String)clazz.getName()));
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)clazz2.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
    }

    public void testClassNamedIsMember() throws Exception {
        Class<?> clazz = class$15;
        if (clazz == null) {
            try {
                clazz = class$15 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)clazz.getName()));
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)clazz2.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$a1"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$a1$aaa$bbb"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$1a1$aaa"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$1a"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$a12345$b12345"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$12345a"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$333"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map3$333"));
    }

    public void testClassNamedIsLocal() throws Exception {
        class LocalClass {
            final /* synthetic */ ClassToolsTests this$0;

            LocalClass(ClassToolsTests classToolsTests) {
                this.this$0 = classToolsTests;
            }

            void foo() {
                System.getProperty("foo");
            }
        }
        new LocalClass(this).foo();
        Class<?> clazz = class$15;
        if (clazz == null) {
            try {
                clazz = class$15 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)clazz.getName()));
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)clazz2.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$a1"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$a1$aaa$bbb"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$11$aaa"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$1$a"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2$abc"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2$abc1"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$1a"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2abc"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2abc1"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$a12345$b12345"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$12345$a1234"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$333"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map3$333"));
    }

    public void testClassNamedIsAnonymous() throws Exception {
        Class<?> clazz = class$15;
        if (clazz == null) {
            try {
                clazz = class$15 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)clazz.getName()));
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)clazz2.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsAnonymous((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$a1"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$a1$aaa$bbb"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$1a1$aaa"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$1$a"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$1a"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$a12345$b12345"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$12345$a1234"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$333"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map3$333"));
    }

    public void testCodeForClass() {
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.codeForClass(Integer.TYPE));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.codeForClass(Byte.TYPE));
    }

    public void testCodeForClassNamed() {
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.codeForClassNamed((String)Integer.TYPE.getName()));
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.codeForClassNamed((String)"int"));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.codeForClassNamed((String)Byte.TYPE.getName()));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.codeForClassNamed((String)"byte"));
    }

    public void testClassForTypeDeclaration() throws Exception {
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.classForTypeDeclaration((String)"int", (int)0));
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((Object)clazz, (Object)ClassTools.classForTypeDeclaration((String)"int", (int)1));
        Class<?> clazz2 = class$14;
        if (clazz2 == null) {
            try {
                clazz2 = class$14 = Class.forName("[[[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((Object)clazz2, (Object)ClassTools.classForTypeDeclaration((String)"int", (int)3));
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((Object)clazz3, (Object)ClassTools.classForTypeDeclaration((String)"java.lang.Object", (int)0));
        Class<?> clazz4 = class$17;
        if (clazz4 == null) {
            try {
                clazz4 = class$17 = Class.forName("[[[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((Object)clazz4, (Object)ClassTools.classForTypeDeclaration((String)"java.lang.Object", (int)3));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.classForTypeDeclaration((String)"void", (int)0));
        try {
            ClassTools.classForTypeDeclaration((String)Void.TYPE.getName(), (int)1);
            ClassToolsTests.fail((String)"should not get here...");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void testClassNameForTypeDeclaration() throws Exception {
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"int", (int)0));
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)clazz.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"int", (int)1));
        Class<?> clazz2 = class$14;
        if (clazz2 == null) {
            try {
                clazz2 = class$14 = Class.forName("[[[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)clazz2.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"int", (int)3));
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)clazz3.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"java.lang.Object", (int)0));
        Class<?> clazz4 = class$17;
        if (clazz4 == null) {
            try {
                clazz4 = class$17 = Class.forName("[[[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassToolsTests.assertEquals((String)clazz4.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"java.lang.Object", (int)3));
        ClassToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"void", (int)0));
        try {
            ClassTools.classNameForTypeDeclaration((String)Void.TYPE.getName(), (int)1);
            ClassToolsTests.fail((String)"should not get here...");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private Iterator names(Field[] fields) {
        return new TransformationIterator(CollectionTools.iterator((Object[])fields)){

            protected Object transform(Object next) {
                return ((Field)next).getName();
            }
        };
    }

    private Iterator names(Method[] methods) {
        return new TransformationIterator(CollectionTools.iterator((Object[])methods)){

            protected Object transform(Object next) {
                return ((Method)next).getName();
            }
        };
    }
}

