/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.clipboard;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;

public final class PropertiesClipboardCommand
extends ClipboardCommand {
    private static final long serialVersionUID = 0L;
    private final Map<String, String> m_propertyTitleToSource = Maps.newTreeMap();

    public PropertiesClipboardCommand(JavaInfo javaInfo) throws Exception {
        Property[] propertyArray = javaInfo.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericPropertyImpl genericProperty;
            String clipboardSource;
            Property property = propertyArray[n2];
            if (property instanceof GenericPropertyImpl && !property.getCategory().isSystem() && property.isModified() && (clipboardSource = (genericProperty = (GenericPropertyImpl)property).getClipboardSource()) != null) {
                this.m_propertyTitleToSource.put(property.getTitle(), clipboardSource);
            }
            ++n2;
        }
    }

    @Override
    public void execute(JavaInfo javaInfo) throws Exception {
        Property[] propertyArray = javaInfo.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (property instanceof GenericPropertyImpl) {
                GenericPropertyImpl genericProperty = (GenericPropertyImpl)property;
                String clipboardSource = this.m_propertyTitleToSource.get(property.getTitle());
                if (clipboardSource != null) {
                    genericProperty.setExpression(clipboardSource, Property.UNKNOWN_VALUE);
                }
            }
            ++n2;
        }
    }
}

