/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.geometry;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.geometry.AbstractGeometryDialog;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.support.RectangleSupport;

public final class RectanglePropertyEditor
extends TextDialogPropertyEditor {
    public static final PropertyEditor INSTANCE = new RectanglePropertyEditor();

    private RectanglePropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value == Property.UNKNOWN_VALUE) {
            return null;
        }
        return RectangleSupport.toString(value);
    }

    protected void openDialog(Property property) throws Exception {
        Object value = property.getValue();
        Object rectangle = value == Property.UNKNOWN_VALUE ? RectangleSupport.newRectangle(0, 0, 0, 0) : value;
        RectangleDialog rectangleDialog = new RectangleDialog(property.getTitle(), rectangle);
        int result = rectangleDialog.open();
        if (result == 9) {
            property.setValue(Property.UNKNOWN_VALUE);
        } else if (result == 0) {
            property.setValue(rectangle);
        }
    }

    private static final class RectangleDialog
    extends AbstractGeometryDialog {
        public RectangleDialog(String title, Object rectangle) {
            super(title, rectangle);
        }

        protected void createEditors() {
            this.createEditor(ModelMessages.RectanglePropertyEditor_xLabel, "x");
            this.createEditor(ModelMessages.RectanglePropertyEditor_yLabel, "y");
            this.createEditor(ModelMessages.RectanglePropertyEditor_widthLabel, "width");
            this.createEditor(ModelMessages.RectanglePropertyEditor_heightLabel, "height");
        }
    }
}

