/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.wb.core.model.ObjectInfo;

public final class ObjectPathHelper {
    private final ITreeContentProvider m_componentsProvider;

    public ObjectPathHelper(ITreeContentProvider componentsProvider) {
        this.m_componentsProvider = componentsProvider;
    }

    public int[][] getObjectsPaths(Object[] objects) {
        int[][] paths = new int[objects.length][];
        int objectIndex = 0;
        while (objectIndex < objects.length) {
            Object object = objects[objectIndex];
            paths[objectIndex] = this.getObjectPath(object);
            ++objectIndex;
        }
        return paths;
    }

    private int[] getObjectPath(Object object) {
        Object parent;
        ArrayIntList path = new ArrayIntList();
        while ((parent = this.m_componentsProvider.getParent(object)) != null) {
            int index = ArrayUtils.indexOf((Object[])this.m_componentsProvider.getChildren(parent), (Object)object);
            path.add(index);
            object = parent;
        }
        int[] finalPath = path.toArray();
        ArrayUtils.reverse((int[])finalPath);
        return finalPath;
    }

    public Object[] getObjectsForPaths(int[][] paths) {
        Object[] objects = new Object[paths.length];
        int i = 0;
        while (i < paths.length) {
            int[] path = paths[i];
            Object object = this.getObjectForPath(path);
            if (object != null) {
                objects[i] = object;
            }
            ++i;
        }
        return objects;
    }

    private Object getObjectForPath(int[] path) {
        try {
            Object object = this.m_componentsProvider.getElements(null)[0];
            int[] nArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                object = this.m_componentsProvider.getChildren(object)[index];
                ++n2;
            }
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getObjectsDump(ObjectInfo objectInfo, int level) {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.repeat((String)" ", (int)level));
        result.append(objectInfo.getClass().getName());
        result.append("\n");
        for (ObjectInfo child : objectInfo.getChildren()) {
            result.append(ObjectPathHelper.getObjectsDump(child, level + 1));
        }
        return result.toString();
    }
}

