/*
 *  Copyright (C) Henrique Peron
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/* This file contains data of .KL-files. They have been generated
   by Henrique Peron using FreeDOS KC */

/* KC: compiles keyboard descriptors in KEY language to a KeybCB,
   wrapped in a KL file (for use of FD-KEYB 2.X)
   Copyright (C) 2004 by Aitor SANTAMARIA_MERINO */


// Bulgaria (101-key)
Bit8u layout_BG[687] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x42, 0x47, 0x2c, 0xba, 0x01, 0x42, 0x47, 0x07,
0x03, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x03, 0x99, 0x01, 0x00,
0x00, 0x00, 0x00, 0x68, 0x03, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x03, 0x97, 0x02, 0x00,
0x00, 0x00, 0x00, 0x57, 0x03, 0xae, 0x01, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x03, 0xa7, 0x00, 0x00,
0x00, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x03, 0x02, 0x03, 0x00, 0x00, 0x40, 0x04, 0x02, 0x03, 0x00, 0x00, 0x23, 0x05,
0x02, 0x03, 0x00, 0x00, 0xcf, 0x07, 0x02, 0x03, 0x00, 0x00, 0x5e, 0x08, 0x02, 0x03, 0x00, 0x00,
0x26, 0x09, 0x02, 0x03, 0x00, 0x00, 0x24, 0x1a, 0x02, 0x03, 0x00, 0x00, 0x5b, 0x1b, 0x02, 0x03,
0x00, 0x00, 0x5d, 0x2b, 0x02, 0x03, 0x00, 0x00, 0x7c, 0x33, 0x02, 0x03, 0x00, 0x00, 0x3c, 0x34,
0x02, 0x03, 0x00, 0x00, 0x3e, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x03, 0x01, 0x01,
0x00, 0x3f, 0x04, 0x01, 0x01, 0x00, 0x2b, 0x05, 0x02, 0x05, 0x00, 0x22, 0xa0, 0x07, 0x01, 0x01,
0x00, 0x3d, 0x08, 0x01, 0x01, 0x00, 0x3a, 0x09, 0x01, 0x01, 0x00, 0x2f, 0x0a, 0x03, 0x05, 0x00,
0x5f, 0x00, 0x1f, 0x0b, 0x01, 0x01, 0x00, 0xef, 0x0c, 0x01, 0x01, 0x00, 0x49, 0x0d, 0x01, 0x00,
0x2e, 0x56, 0x10, 0x01, 0x00, 0x2c, 0xf2, 0x11, 0x41, 0x00, 0xe7, 0xe8, 0x12, 0x42, 0x00, 0xa8,
0xa9, 0xcf, 0x13, 0x41, 0x00, 0xb7, 0xb8, 0x14, 0x41, 0x00, 0xf5, 0xf6, 0x15, 0x41, 0x00, 0xf9,
0xfa, 0x16, 0x41, 0x00, 0xc6, 0xc7, 0x17, 0x41, 0x00, 0xe3, 0xe4, 0x18, 0x41, 0x00, 0xa6, 0xa7,
0x19, 0x41, 0x00, 0xf3, 0xf4, 0x1a, 0x41, 0x00, 0xa4, 0xa5, 0x1b, 0x01, 0x00, 0x3b, 0xfd, 0x1e,
0x41, 0x00, 0xed, 0xee, 0x1f, 0xc1, 0x00, 0xde, 0x1f, 0xe0, 0x00, 0x20, 0x41, 0x00, 0xa0, 0xa1,
0x21, 0x41, 0x00, 0xd6, 0xd7, 0x22, 0x41, 0x00, 0xe9, 0xea, 0x23, 0x41, 0x00, 0xac, 0xad, 0x24,
0x41, 0x00, 0xe5, 0xe6, 0x25, 0x41, 0x00, 0xd4, 0xd5, 0x26, 0x41, 0x00, 0xeb, 0xec, 0x27, 0x41,
0x00, 0xd2, 0xd3, 0x28, 0x41, 0x00, 0xfb, 0xfc, 0x2a, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x78,
0x2b, 0x01, 0x00, 0x29, 0x28, 0x2c, 0x41, 0x00, 0x9c, 0x9d, 0x2d, 0x41, 0x00, 0xbd, 0xbe, 0x2e,
0x41, 0x00, 0x9e, 0x9f, 0x2f, 0x41, 0x00, 0xf7, 0xf8, 0x30, 0x41, 0x00, 0xaa, 0xab, 0x31, 0x41,
0x00, 0xb5, 0xb6, 0x32, 0x41, 0x00, 0xd8, 0xdd, 0x33, 0x41, 0x00, 0xe1, 0xe2, 0x34, 0x41, 0x00,
0xd0, 0xd1, 0x35, 0x41, 0x00, 0xa2, 0xa3, 0x00, 0x05, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x12, 0x42,
0x03, 0x00, 0x00, 0xcf, 0x36, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x79, 0x00, 0x03, 0x01, 0x01,
0x00, 0x3f, 0x04, 0x01, 0x01, 0x00, 0x2b, 0x05, 0x01, 0x01, 0x00, 0x22, 0x07, 0x01, 0x01, 0x00,
0x3d, 0x08, 0x01, 0x01, 0x00, 0x3a, 0x09, 0x01, 0x01, 0x00, 0x2f, 0x0a, 0x03, 0x05, 0x00, 0x5f,
0x00, 0x1f, 0x0b, 0x01, 0x01, 0x00, 0xef, 0x0c, 0x01, 0x01, 0x00, 0x49, 0x0d, 0x01, 0x00, 0x2e,
0x56, 0x10, 0x01, 0x00, 0x2c, 0xf2, 0x11, 0x41, 0x00, 0xe7, 0xe8, 0x12, 0x41, 0x00, 0xa8, 0xa9,
0x13, 0x41, 0x00, 0xb7, 0xb8, 0x14, 0x41, 0x00, 0xf5, 0xf6, 0x15, 0x41, 0x00, 0xf9, 0xfa, 0x16,
0x41, 0x00, 0xc6, 0xc7, 0x17, 0x41, 0x00, 0xe3, 0xe4, 0x18, 0x41, 0x00, 0xa6, 0xa7, 0x19, 0x41,
0x00, 0xf3, 0xf4, 0x1a, 0x41, 0x00, 0xa4, 0xa5, 0x1b, 0x01, 0x00, 0x3b, 0xfd, 0x1e, 0x41, 0x00,
0xed, 0xee, 0x1f, 0xc1, 0x00, 0xde, 0x1f, 0xe0, 0x00, 0x20, 0x41, 0x00, 0xa0, 0xa1, 0x21, 0x41,
0x00, 0xd6, 0xd7, 0x22, 0x41, 0x00, 0xe9, 0xea, 0x23, 0x41, 0x00, 0xac, 0xad, 0x24, 0x41, 0x00,
0xe5, 0xe6, 0x25, 0x41, 0x00, 0xd4, 0xd5, 0x26, 0x41, 0x00, 0xeb, 0xec, 0x27, 0x41, 0x00, 0xd2,
0xd3, 0x28, 0x41, 0x00, 0xfb, 0xfc, 0x2a, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x2b, 0x01,
0x00, 0x29, 0x28, 0x2c, 0x41, 0x00, 0x9c, 0x9d, 0x2d, 0x41, 0x00, 0xbd, 0xbe, 0x2e, 0x41, 0x00,
0x9e, 0x9f, 0x2f, 0x41, 0x00, 0xf7, 0xf8, 0x30, 0x41, 0x00, 0xaa, 0xab, 0x31, 0x41, 0x00, 0xb5,
0xb6, 0x32, 0x41, 0x00, 0xd8, 0xdd, 0x33, 0x41, 0x00, 0xe1, 0xe2, 0x34, 0x41, 0x00, 0xd0, 0xd1,
0x35, 0x41, 0x00, 0xa2, 0xa3, 0x00, 0x36, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x00  };

// Czech Republic (Standard)
Bit8u layout_CZ243[1003] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x04, 0xf3, 0x00, 0x43, 0x5a, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00,
0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x03, 0x36, 0x01, 0xb8, 0x01, 0x00, 0x00, 0x5a, 0x03,
0x79, 0x02, 0x80, 0x02, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x80, 0x02, 0x00, 0x00, 0x63, 0x03,
0x07, 0x03, 0x74, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x2b, 0x31, 0xc8, 0x03, 0x01, 0x01, 0xa0,
0x32, 0x04, 0x03, 0x05, 0xa0, 0x33, 0xc9, 0x1e, 0x05, 0x01, 0x01, 0xa0, 0x34, 0x06, 0x02, 0x05,
0xa0, 0x35, 0xca, 0x07, 0x01, 0x01, 0xa0, 0x36, 0x08, 0x02, 0x04, 0xec, 0x37, 0xcb, 0x09, 0x02,
0x00, 0xa0, 0x38, 0xfa, 0x0a, 0x02, 0x04, 0xa1, 0x39, 0xcc, 0x0b, 0x01, 0x00, 0x82, 0x30, 0x0c,
0x02, 0x04, 0x3d, 0x25, 0xcd, 0x0d, 0x02, 0x07, 0xcc, 0xa0, 0xce, 0x10, 0x42, 0x03, 0x00, 0x00,
0x5c, 0x11, 0x42, 0x03, 0x00, 0x00, 0x7c, 0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x43, 0x04, 0x7a,
0x5a, 0x00, 0x1a, 0x16, 0x41, 0x00, 0x75, 0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00,
0x6f, 0x4f, 0x1a, 0x02, 0x00, 0xa3, 0x2f, 0xf6, 0x1b, 0x02, 0x00, 0x29, 0x28, 0x9e, 0x1e, 0x42,
0x00, 0x61, 0x41, 0x3c, 0x21, 0x42, 0x03, 0x00, 0x00, 0x5b, 0x22, 0x42, 0x03, 0x00, 0x00, 0x5d,
0x27, 0x02, 0x01, 0xa0, 0x22, 0x24, 0x28, 0x02, 0x00, 0xf5, 0x21, 0xe1, 0x29, 0x01, 0x02, 0x3b,
0xca, 0x2b, 0x02, 0x01, 0xcd, 0x27, 0xcf, 0x2c, 0x43, 0x00, 0x79, 0x59, 0x3e, 0x19, 0x2d, 0x42,
0x03, 0x00, 0x00, 0x23, 0x2e, 0x42, 0x00, 0x63, 0x43, 0x26, 0x2f, 0x42, 0x03, 0x00, 0x00, 0x40,
0x30, 0x42, 0x03, 0x00, 0x00, 0x7b, 0x31, 0x42, 0x00, 0x6e, 0x4e, 0x7d, 0x32, 0x42, 0x03, 0x00,
0x00, 0xe6, 0x33, 0x01, 0x01, 0x00, 0x3f, 0x34, 0x02, 0x01, 0x00, 0x3a, 0x2a, 0x35, 0x03, 0x04,
0x2d, 0x5f, 0x00, 0x1f, 0x39, 0x00, 0x00, 0x20, 0x56, 0x03, 0x00, 0x26, 0x2a, 0x3c, 0x1c, 0x00,
0x02, 0x02, 0x03, 0x00, 0x00, 0x7e, 0x03, 0x02, 0x06, 0xd8, 0x00, 0xc8, 0x04, 0x00, 0x00, 0xe7,
0x05, 0x02, 0x06, 0x9f, 0x00, 0xca, 0x06, 0x02, 0x06, 0xfd, 0x00, 0xcb, 0x07, 0x02, 0x06, 0xa7,
0x00, 0xcc, 0x08, 0x02, 0x03, 0x00, 0x00, 0x60, 0x09, 0x02, 0x07, 0x00, 0x00, 0xcd, 0x0a, 0x02,
0x07, 0x00, 0x00, 0xce, 0x0b, 0x02, 0x07, 0x00, 0x00, 0xcf, 0x0c, 0x02, 0x07, 0x00, 0x00, 0xd0,
0x0d, 0x02, 0x07, 0xce, 0xc8, 0xd1, 0x12, 0x42, 0x03, 0x00, 0x00, 0xaa, 0x13, 0x41, 0x00, 0x72,
0x52, 0x14, 0x41, 0x00, 0x74, 0x54, 0x1f, 0x42, 0x00, 0x73, 0x53, 0xd0, 0x20, 0x42, 0x00, 0x64,
0x44, 0xd1, 0x25, 0x42, 0x03, 0x00, 0x00, 0x88, 0x26, 0x42, 0x00, 0x6c, 0x4c, 0x9d, 0x27, 0x00,
0x00, 0x85, 0x29, 0x01, 0x03, 0x00, 0xcb, 0x2b, 0x00, 0x01, 0xd0, 0x32, 0x02, 0x07, 0x00, 0x00,
0xa0, 0x00, 0xf3, 0x13, 0x63, 0x9f, 0x64, 0xd4, 0x65, 0xd8, 0x6c, 0x96, 0x6e, 0xe5, 0x72, 0xfd,
0x73, 0xe7, 0x74, 0x9c, 0x7a, 0xa7, 0x43, 0xac, 0x44, 0xd2, 0x45, 0xb7, 0x4c, 0x95, 0x4e, 0xd5,
0x52, 0xfc, 0x53, 0xe6, 0x54, 0x9b, 0x5a, 0xa6, 0x20, 0xf3, 0x5e, 0x07, 0x61, 0x83, 0x69, 0x8c,
0x6f, 0x93, 0x41, 0xb6, 0x49, 0xd7, 0x4f, 0xe2, 0x20, 0x5e, 0xf4, 0x03, 0x61, 0xc7, 0x41, 0xc6,
0x20, 0xf4, 0xf8, 0x03, 0x75, 0x85, 0x55, 0xde, 0x20, 0xf8, 0xf2, 0x05, 0x61, 0xa5, 0x65, 0xa9,
0x41, 0xa4, 0x45, 0xa8, 0x20, 0xf2, 0xfa, 0x03, 0x7a, 0xbe, 0x5a, 0xbd, 0x20, 0xfa, 0x27, 0x19,
0x61, 0xa0, 0x63, 0x86, 0x65, 0x82, 0x69, 0xa1, 0x6c, 0x92, 0x6e, 0xe4, 0x6f, 0xa2, 0x72, 0xea,
0x73, 0x98, 0x75, 0xa3, 0x79, 0xec, 0x7a, 0xab, 0x41, 0xb5, 0x43, 0x8f, 0x45, 0x90, 0x49, 0xd6,
0x4c, 0x91, 0x4e, 0xe3, 0x4f, 0xe0, 0x52, 0xe8, 0x53, 0x97, 0x55, 0xe9, 0x59, 0xed, 0x5a, 0x8d,
0x20, 0xef, 0xf1, 0x05, 0x6f, 0x8b, 0x75, 0xfb, 0x4f, 0x8a, 0x55, 0xeb, 0x20, 0xf1, 0xf9, 0x09,
0x61, 0x84, 0x65, 0x89, 0x6f, 0x94, 0x75, 0x81, 0x41, 0x8e, 0x45, 0xd3, 0x4f, 0x99, 0x55, 0x9a,
0x20, 0xf9, 0xf7, 0x07, 0x63, 0x87, 0x73, 0xad, 0x74, 0xee, 0x43, 0x80, 0x53, 0xb8, 0x54, 0xdd,
0x20, 0xf7, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4,
0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88,
0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea,
0x20, 0x5e, 0xf8, 0x03, 0x61, 0x86, 0x41, 0x8f, 0x20, 0xf8, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a,
0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb,
0x20, 0x60, 0xef, 0x0d, 0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec,
0x41, 0xb5, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c,
0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3,
0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0xf7, 0x03, 0x63, 0x87, 0x43, 0x80, 0x20, 0xf7,
0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x7e, 0x03, 0x02, 0x06, 0x88, 0x00, 0xc8, 0x04, 0x00, 0x00,
0xa8, 0x05, 0x00, 0x00, 0x87, 0x06, 0x00, 0x00, 0xa9, 0x07, 0x00, 0x00, 0x91, 0x08, 0x02, 0x02,
0x98, 0x00, 0x60, 0x09, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x0a, 0x02, 0x07, 0x00, 0x00, 0xcb, 0x0c,
0x02, 0x07, 0x00, 0x00, 0xcc, 0x0d, 0x02, 0x07, 0xcb, 0xc8, 0xa0, 0x13, 0x41, 0x00, 0x72, 0x52,
0x14, 0x41, 0x00, 0x74, 0x54, 0x1b, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x1f, 0x41, 0x00, 0x73, 0x53,
0x20, 0x41, 0x00, 0x64, 0x44, 0x26, 0x41, 0x00, 0x6c, 0x4c, 0x27, 0x00, 0x00, 0x96, 0x28, 0x00,
0x00, 0xad, 0x29, 0x01, 0x03, 0x00, 0xca, 0x2b, 0x02, 0x07, 0xcc, 0x00, 0xa0, 0x00, 0x76, 0x13,
0x63, 0x87, 0x64, 0x83, 0x65, 0x88, 0x6c, 0x8c, 0x6e, 0xa4, 0x72, 0xa9, 0x73, 0xa8, 0x74, 0x9f,
0x7a, 0x91, 0x43, 0x80, 0x44, 0x85, 0x45, 0x89, 0x4c, 0x9c, 0x4e, 0xa5, 0x52, 0x9e, 0x53, 0x9b,
0x54, 0x86, 0x5a, 0x92, 0x20, 0x76, 0x5e, 0x03, 0x6f, 0x93, 0x4f, 0xa7, 0x20, 0x5e, 0xf8, 0x03,
0x75, 0x96, 0x55, 0xa6, 0x20, 0xf8, 0x27, 0x11, 0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6c, 0x8d,
0x6f, 0xa2, 0x72, 0xaa, 0x75, 0xa3, 0x79, 0x98, 0x41, 0x8f, 0x45, 0x90, 0x49, 0x8b, 0x4c, 0x8a,
0x4f, 0x95, 0x52, 0xab, 0x55, 0x97, 0x59, 0x9d, 0x20, 0x27, 0x22, 0x07, 0x61, 0x84, 0x6f, 0x94,
0x75, 0x81, 0x41, 0x8e, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0x00  };

// France (Standard)
Bit8u layout_FR[581] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x46, 0x52, 0x2c, 0xbd, 0x00, 0x46, 0x52, 0x05,
0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x03, 0x68, 0x01, 0x6f,
0x01, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x6f, 0x01, 0x00, 0x00, 0x5b, 0x03, 0xca, 0x01, 0xd9,
0x01, 0x00, 0x00, 0xb5, 0x01, 0x1c, 0x01, 0x2d, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x00,
0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x02, 0x41, 0x00, 0x26, 0x31, 0x03, 0x42, 0x04, 0x82, 0x32, 0xc9, 0x04, 0x42,
0x00, 0x22, 0x33, 0x23, 0x05, 0x42, 0x00, 0x27, 0x34, 0x7b, 0x06, 0x43, 0x00, 0x28, 0x35, 0x5b,
0x1b, 0x07, 0x43, 0x00, 0x2d, 0x36, 0x7c, 0x1f, 0x08, 0x42, 0x04, 0x8a, 0x37, 0xc8, 0x09, 0x43,
0x00, 0x5f, 0x38, 0x5c, 0x1c, 0x0a, 0x42, 0x00, 0x87, 0x39, 0x5e, 0x0b, 0x42, 0x00, 0x85, 0x30,
0x40, 0x0c, 0x43, 0x00, 0x29, 0xf8, 0x5d, 0x1d, 0x0d, 0x42, 0x03, 0x00, 0x00, 0x7d, 0x10, 0x43,
0x04, 0x61, 0x41, 0x00, 0x01, 0x11, 0x43, 0x04, 0x7a, 0x5a, 0x00, 0x1a, 0x12, 0x41, 0x00, 0x65,
0x45, 0x15, 0x41, 0x00, 0x79, 0x59, 0x16, 0x41, 0x00, 0x75, 0x55, 0x17, 0x41, 0x00, 0x69, 0x49,
0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1a, 0x43, 0x07, 0xca, 0xcb, 0x00, 0x1e, 0x1b, 0x42, 0x00, 0x24,
0x9c, 0xcf, 0x1e, 0x43, 0x04, 0x71, 0x51, 0x00, 0x11, 0x27, 0x43, 0x04, 0x6d, 0x4d, 0x00, 0x0d,
0x28, 0x41, 0x00, 0x97, 0x25, 0x29, 0x41, 0x00, 0xfd, 0xfc, 0x2b, 0x41, 0x00, 0x2a, 0xe6, 0x2c,
0x43, 0x04, 0x77, 0x57, 0x00, 0x17, 0x31, 0x41, 0x00, 0x6e, 0x4e, 0x32, 0x41, 0x00, 0x2c, 0x3f,
0x33, 0x42, 0x00, 0x3b, 0x2e, 0x3c, 0x34, 0x42, 0x00, 0x3a, 0x2f, 0x3e, 0x35, 0x41, 0x00, 0x21,
0xf5, 0x39, 0x00, 0x00, 0x20, 0x56, 0x41, 0x00, 0x3c, 0x3e, 0x00, 0x1b, 0x42, 0x07, 0x00, 0x00,
0xa0, 0x29, 0x41, 0x03, 0x00, 0xa0, 0x35, 0x41, 0x01, 0x00, 0x15, 0x00, 0x60, 0x06, 0x61, 0x85,
0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x7e, 0x03, 0x6e, 0xa4, 0x4e, 0xa5,
0x20, 0x7e, 0x5e, 0x06, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x20, 0x5e,
0x22, 0x0a, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e,
0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x60, 0x0b,
0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde,
0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7,
0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93,
0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e, 0xf9, 0x0c,
0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3,
0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x18,
0x44, 0x0b, 0x00, 0x00, 0xab, 0x00, 0xac, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d,
0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60,
0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e,
0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2,
0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e, 0x22, 0x0d, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b,
0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a,
0x59, 0xf3, 0x20, 0x22, 0x00  };

// Greece (319)
Bit8u layout_GK[1117] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x13, 0x00, 0x00, 0x47, 0x4b, 0x2c, 0x00, 0x00, 0x45, 0x4c, 0x2c,
0x3f, 0x01, 0x47, 0x4b, 0x2c, 0x3f, 0x01, 0x45, 0x4c, 0x09, 0x03, 0x00, 0x00, 0x00, 0x00, 0x0d,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x03, 0x3a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x65, 0x03, 0x79,
0x01, 0x49, 0x02, 0x00, 0x00, 0xe1, 0x02, 0x24, 0x03, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x02, 0x7e,
0x02, 0x2d, 0x03, 0x00, 0x00, 0x53, 0x03, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x53, 0x03, 0x5a,
0x03, 0x13, 0x04, 0x00, 0x00, 0x5a, 0x03, 0xf7, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x52, 0x03, 0x00,
0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x01, 0x01,
0x00, 0x22, 0x07, 0x01, 0x01, 0x00, 0x26, 0x08, 0x01, 0x01, 0x00, 0x2f, 0x09, 0x01, 0x01, 0x00,
0x28, 0x0a, 0x01, 0x01, 0x00, 0x29, 0x0b, 0x01, 0x01, 0x00, 0x3d, 0x0c, 0x01, 0x00, 0x27, 0x3f,
0x0d, 0x01, 0x00, 0x2b, 0x2a, 0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x41, 0x00, 0x79, 0x59, 0x16,
0x41, 0x00, 0x75, 0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1e, 0x41,
0x00, 0x61, 0x41, 0x27, 0x01, 0x03, 0xcb, 0xcc, 0x28, 0x01, 0x03, 0xca, 0xc9, 0x29, 0x03, 0x04,
0x5c, 0x7c, 0x00, 0x1c, 0x2b, 0x01, 0x01, 0xc8, 0x40, 0x2e, 0x41, 0x00, 0x63, 0x43, 0x31, 0x41,
0x00, 0x6e, 0x4e, 0x33, 0x02, 0x00, 0x2c, 0x3b, 0x3c, 0x34, 0x02, 0x00, 0x2e, 0x3a, 0x3e, 0x35,
0x03, 0x04, 0x2d, 0x5f, 0x00, 0x1f, 0x39, 0x00, 0x00, 0x20, 0x56, 0x01, 0x00, 0x3c, 0x3e, 0x00,
0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f,
0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x7e,
0x07, 0x61, 0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e,
0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49,
0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e, 0xef, 0x0f, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82, 0x69,
0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5, 0x43, 0x80, 0x45, 0x90, 0x49, 0xd6, 0x4f,
0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f,
0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20,
0xf9, 0x00, 0x04, 0x01, 0x01, 0x00, 0x9c, 0x07, 0x01, 0x01, 0x00, 0x89, 0x0c, 0x01, 0x01, 0x00,
0xf8, 0x10, 0x01, 0x00, 0x88, 0x8e, 0x11, 0x01, 0x00, 0xed, 0x8a, 0x12, 0x42, 0x00, 0xde, 0xa8,
0x87, 0x13, 0x41, 0x00, 0xeb, 0xc7, 0x14, 0x41, 0x00, 0xee, 0xd0, 0x15, 0x41, 0x00, 0xf2, 0xd1,
0x16, 0x41, 0x00, 0xe2, 0xac, 0x17, 0x41, 0x00, 0xe3, 0xad, 0x18, 0x41, 0x00, 0xe9, 0xbe, 0x19,
0x41, 0x00, 0xea, 0xc6, 0x1a, 0x01, 0x01, 0x00, 0xae, 0x1b, 0x01, 0x01, 0x00, 0xaf, 0x1e, 0x41,
0x00, 0xd6, 0xa4, 0x1f, 0x41, 0x00, 0xec, 0xcf, 0x20, 0x41, 0x00, 0xdd, 0xa7, 0x21, 0x41, 0x00,
0xf3, 0xd2, 0x22, 0x41, 0x00, 0xd8, 0xa6, 0x23, 0x41, 0x00, 0xe1, 0xaa, 0x24, 0x41, 0x00, 0xe8,
0xbd, 0x25, 0x41, 0x00, 0xe4, 0xb5, 0x26, 0x41, 0x00, 0xe5, 0xb6, 0x27, 0x02, 0x07, 0xc8, 0xc9,
0xca, 0x28, 0x01, 0x00, 0x8c, 0x8b, 0x29, 0x01, 0x00, 0xab, 0xf1, 0x2a, 0x04, 0x1f, 0x00, 0x00,
0x00, 0x00, 0x78, 0x2b, 0x01, 0x00, 0x99, 0x9a, 0x2c, 0xc1, 0x00, 0xe0, 0x00, 0xa9, 0x2c, 0x2d,
0x41, 0x00, 0xf4, 0xd3, 0x2e, 0x41, 0x00, 0xf6, 0xd4, 0x2f, 0x41, 0x00, 0xfa, 0xd5, 0x30, 0x41,
0x00, 0xd7, 0xa5, 0x31, 0x41, 0x00, 0xe7, 0xb8, 0x32, 0x41, 0x00, 0xe6, 0xb7, 0x56, 0x01, 0x00,
0xf5, 0x97, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0x87, 0x36, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00,
0x79, 0x00, 0xef, 0x0f, 0xd6, 0x9b, 0xde, 0x9d, 0xe1, 0x9e, 0xe3, 0x9f, 0xe9, 0xa2, 0xf2, 0xa3,
0xfa, 0xfd, 0xa4, 0x86, 0xa8, 0x8d, 0xaa, 0x8f, 0xad, 0x90, 0xbe, 0x92, 0xd1, 0x95, 0xd5, 0x98,
0x20, 0xef, 0xf9, 0x05, 0xe3, 0xa0, 0xf2, 0xfb, 0xad, 0x91, 0xd1, 0x96, 0x20, 0xf9, 0xf7, 0x03,
0xe3, 0xa1, 0xf2, 0xfc, 0x20, 0xf7, 0x00, 0x0c, 0x01, 0x01, 0x00, 0xf8, 0x10, 0x01, 0x00, 0xf9,
0x51, 0x11, 0x01, 0x00, 0xaa, 0x57, 0x12, 0x41, 0x00, 0x9c, 0x84, 0x13, 0x41, 0x00, 0xa8, 0x90,
0x14, 0x41, 0x00, 0xab, 0x92, 0x15, 0x41, 0x00, 0xac, 0x93, 0x16, 0x41, 0x00, 0x9f, 0x87, 0x17,
0x41, 0x00, 0xa0, 0x88, 0x18, 0x41, 0x00, 0xa6, 0x8e, 0x19, 0x41, 0x00, 0xa7, 0x8f, 0x1e, 0x41,
0x00, 0x98, 0x80, 0x1f, 0x41, 0x00, 0xa9, 0x91, 0x20, 0x41, 0x00, 0x9b, 0x83, 0x21, 0x41, 0x00,
0xad, 0x94, 0x22, 0x41, 0x00, 0x9a, 0x82, 0x23, 0x41, 0x00, 0x9e, 0x86, 0x24, 0x41, 0x00, 0xa5,
0x8d, 0x25, 0x41, 0x00, 0xa1, 0x89, 0x26, 0x41, 0x00, 0xa2, 0x8a, 0x27, 0x01, 0x03, 0xc8, 0xc9,
0x29, 0x01, 0x00, 0x60, 0xf1, 0x2a, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x2b, 0x01, 0x00,
0xfd, 0x7c, 0x2c, 0x41, 0x00, 0x9d, 0x85, 0x2d, 0x41, 0x00, 0xae, 0x95, 0x2e, 0x41, 0x00, 0xaf,
0x96, 0x2f, 0xc1, 0x00, 0xe0, 0x00, 0x97, 0x2f, 0x30, 0x41, 0x00, 0x99, 0x81, 0x31, 0x41, 0x00,
0xa4, 0x8c, 0x32, 0x41, 0x00, 0xa3, 0x8b, 0x56, 0x01, 0x00, 0x15, 0x7c, 0x00, 0x36, 0x04, 0x1f,
0x00, 0x00, 0x00, 0x00, 0x7b, 0x00, 0x27, 0x0f, 0x98, 0xe1, 0x9c, 0xe2, 0x9e, 0xe3, 0xa0, 0xe5,
0xa6, 0xe6, 0xac, 0xe7, 0xe0, 0xe9, 0x80, 0xea, 0x84, 0xeb, 0x86, 0xec, 0x88, 0xed, 0x8e, 0xee,
0x93, 0xef, 0x97, 0xf0, 0x20, 0x27, 0x22, 0x05, 0xa0, 0xe4, 0xac, 0xe8, 0x88, 0xf4, 0x93, 0xf5,
0x20, 0x22, 0x00, 0x0c, 0x01, 0x01, 0x00, 0xf8, 0x10, 0x10, 0x00, 0x00, 0x11, 0x01, 0x00, 0xed,
0x7c, 0x12, 0x41, 0x00, 0xde, 0xa8, 0x13, 0x41, 0x00, 0xeb, 0xc7, 0x14, 0x41, 0x00, 0xee, 0xd0,
0x15, 0x41, 0x00, 0xf2, 0xd1, 0x16, 0x41, 0x00, 0xe2, 0xac, 0x17, 0x41, 0x00, 0xe3, 0xad, 0x18,
0x41, 0x00, 0xe9, 0xbe, 0x19, 0x41, 0x00, 0xea, 0xc6, 0x1a, 0x01, 0x01, 0x00, 0xae, 0x1b, 0x01,
0x01, 0x00, 0xaf, 0x1e, 0x41, 0x00, 0xd6, 0xa4, 0x1f, 0x41, 0x00, 0xec, 0xcf, 0x20, 0x41, 0x00,
0xdd, 0xa7, 0x21, 0x41, 0x00, 0xf3, 0xd2, 0x22, 0x41, 0x00, 0xd8, 0xa6, 0x23, 0x41, 0x00, 0xe1,
0xaa, 0x24, 0x41, 0x00, 0xe8, 0xbd, 0x25, 0x41, 0x00, 0xe4, 0xb5, 0x26, 0x41, 0x00, 0xe5, 0xb6,
0x27, 0x02, 0x07, 0xc8, 0xc9, 0xca, 0x29, 0x01, 0x00, 0xab, 0xf1, 0x2a, 0x04, 0x1f, 0x00, 0x00,
0x00, 0x00, 0x7c, 0x2b, 0x01, 0x00, 0x5c, 0x7c, 0x2c, 0xc1, 0x00, 0xe0, 0x00, 0xa9, 0x2c, 0x2d,
0x41, 0x00, 0xf4, 0xd3, 0x2e, 0x41, 0x00, 0xf6, 0xd4, 0x2f, 0x41, 0x00, 0xfa, 0xd5, 0x30, 0x41,
0x00, 0xd7, 0xa5, 0x31, 0x41, 0x00, 0xe7, 0xb8, 0x32, 0x41, 0x00, 0xe6, 0xb7, 0x56, 0x01, 0x00,
0xf5, 0x7c, 0x00, 0x36, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x7d, 0x00, 0xef, 0x0f, 0xd6, 0x9b,
0xde, 0x9d, 0xe1, 0x9e, 0xe3, 0x9f, 0xe9, 0xa2, 0xf2, 0xa3, 0xfa, 0xfd, 0xa4, 0x86, 0xa8, 0x8d,
0xaa, 0x8f, 0xad, 0x90, 0xbe, 0x92, 0xd1, 0x95, 0xd5, 0x98, 0x20, 0xef, 0xf9, 0x03, 0xe3, 0xa0,
0xf2, 0xfb, 0x20, 0xf9, 0x27, 0x03, 0xe3, 0xa1, 0xf2, 0xfc, 0x20, 0x27, 0x00  };

// Germany (Standard)
Bit8u layout_GR[596] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x13, 0x00, 0x00, 0x47, 0x52, 0x2c, 0x00, 0x00, 0x44, 0x45, 0x2c,
0x81, 0x00, 0x47, 0x52, 0x2c, 0x81, 0x00, 0x44, 0x45, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x05,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x03, 0x19, 0x01, 0x20, 0x01, 0x00, 0x00, 0x52, 0x03, 0x00,
0x00, 0x20, 0x01, 0x00, 0x00, 0xb5, 0x01, 0x12, 0x01, 0x71, 0x01, 0x00, 0x00, 0x54, 0x03, 0xa2,
0x01, 0xd8, 0x01, 0x00, 0x00, 0x55, 0x03, 0x01, 0x02, 0x1e, 0x02, 0x00, 0x00, 0x00, 0x08, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03,
0x00, 0x00, 0x7c, 0x03, 0x02, 0x01, 0x00, 0x22, 0xfd, 0x04, 0x02, 0x01, 0x00, 0xf5, 0xfc, 0x07,
0x01, 0x01, 0x00, 0x26, 0x08, 0x02, 0x01, 0x00, 0x2f, 0x7b, 0x09, 0x03, 0x01, 0x00, 0x28, 0x5b,
0x1b, 0x0a, 0x03, 0x01, 0x00, 0x29, 0x5d, 0x1d, 0x0b, 0x02, 0x01, 0x00, 0x3d, 0x7d, 0x0c, 0x03,
0x00, 0xe1, 0x3f, 0x5c, 0x1c, 0x0d, 0x01, 0x03, 0xca, 0xc8, 0x10, 0x42, 0x03, 0x00, 0x00, 0x40,
0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x43, 0x04, 0x7a, 0x5a, 0x00, 0x1a, 0x16, 0x41, 0x00, 0x75,
0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1a, 0x41, 0x00, 0x81, 0x9a,
0x1b, 0x02, 0x00, 0x2b, 0x2a, 0x7e, 0x1e, 0x41, 0x00, 0x61, 0x41, 0x27, 0x41, 0x00, 0x94, 0x99,
0x28, 0x41, 0x00, 0x84, 0x8e, 0x29, 0x03, 0x05, 0xc9, 0xf8, 0x00, 0x1e, 0x2b, 0x01, 0x00, 0x23,
0x27, 0x2c, 0x43, 0x00, 0x79, 0x59, 0x3c, 0x19, 0x2d, 0x42, 0x03, 0x00, 0x00, 0x3e, 0x2e, 0x41,
0x00, 0x63, 0x43, 0x31, 0x42, 0x03, 0x00, 0x00, 0x23, 0x32, 0x42, 0x03, 0x00, 0x00, 0xe6, 0x33,
0x01, 0x01, 0x00, 0x3b, 0x34, 0x01, 0x01, 0x00, 0x3a, 0x35, 0x03, 0x04, 0x2d, 0x5f, 0x00, 0x1f,
0x39, 0x00, 0x00, 0x20, 0x56, 0x02, 0x00, 0x3c, 0x3e, 0x7c, 0x00, 0x04, 0x02, 0x05, 0x00, 0x15,
0xa0, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69,
0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20,
0x60, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45,
0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e, 0xef, 0x0f, 0x61, 0xa0, 0x63, 0x87, 0x65,
0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5, 0x43, 0x80, 0x45, 0x90, 0x49,
0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0xef, 0x00, 0x60, 0x06, 0x61, 0x85, 0x65, 0x8a,
0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x5e, 0x06, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c,
0x6f, 0x93, 0x75, 0x96, 0x20, 0x5e, 0x27, 0x09, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1,
0x6f, 0xa2, 0x75, 0xa3, 0x43, 0x80, 0x45, 0x90, 0x20, 0x27, 0x00, 0x03, 0x02, 0x07, 0x00, 0x00,
0xa0, 0x04, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x0d, 0x01, 0x03, 0xc8, 0xa0, 0x12, 0x42, 0x03, 0x00,
0x00, 0xaa, 0x1f, 0x41, 0x00, 0x73, 0x53, 0x26, 0x41, 0x00, 0x6c, 0x4c, 0x29, 0x00, 0x01, 0xa0,
0x2d, 0x41, 0x00, 0x78, 0x58, 0x31, 0x41, 0x00, 0x6e, 0x4e, 0x32, 0x42, 0x07, 0x00, 0x00, 0xa0,
0x00, 0xef, 0x13, 0x61, 0xa5, 0x63, 0x86, 0x65, 0xa9, 0x6c, 0x88, 0x6e, 0xe4, 0x6f, 0xa2, 0x73,
0x98, 0x78, 0xab, 0x7a, 0xbe, 0x41, 0xa4, 0x43, 0x8f, 0x45, 0xa8, 0x4c, 0x9d, 0x4e, 0xe3, 0x4f,
0xe0, 0x53, 0x97, 0x58, 0x8d, 0x5a, 0xbd, 0x20, 0xef, 0x00, 0x0d, 0x10, 0x00, 0x00, 0x1f, 0x41,
0x00, 0x73, 0x53, 0x22, 0x41, 0x00, 0x67, 0x47, 0x23, 0x41, 0x00, 0x68, 0x48, 0x24, 0x41, 0x00,
0x6a, 0x4a, 0x29, 0x00, 0x01, 0xc8, 0x00, 0x5e, 0x0d, 0x63, 0x86, 0x67, 0x9b, 0x68, 0xa9, 0x6a,
0x9f, 0x73, 0xc7, 0x75, 0xed, 0x43, 0x8f, 0x47, 0x9d, 0x48, 0xa8, 0x4a, 0xac, 0x53, 0xc6, 0x55,
0xec, 0x20, 0x5e, 0x00  };

// Croatia
Bit8u layout_HR[993] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x27, 0x00, 0x00, 0x42, 0x41, 0x2c, 0x00, 0x00, 0x48, 0x52, 0x2c,
0x00, 0x00, 0x53, 0x49, 0x2c, 0x00, 0x00, 0x59, 0x55, 0x2c, 0xea, 0x00, 0x42, 0x41, 0x2c, 0xea,
0x00, 0x48, 0x52, 0x2c, 0xea, 0x00, 0x53, 0x49, 0x2c, 0xea, 0x00, 0x59, 0x55, 0x05, 0x02, 0x00,
0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x03, 0xde, 0x01, 0x65, 0x02, 0x00,
0x00, 0x71, 0x00, 0x29, 0x01, 0x7f, 0x01, 0x00, 0x00, 0x5a, 0x03, 0x26, 0x03, 0x2d, 0x03, 0x00,
0x00, 0x52, 0x03, 0x00, 0x00, 0x2d, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x07, 0x00, 0x00, 0xc8, 0x03,
0x01, 0x01, 0x00, 0x22, 0x04, 0x03, 0x07, 0x00, 0x00, 0xc9, 0x1e, 0x06, 0x02, 0x07, 0x00, 0x00,
0xca, 0x07, 0x01, 0x01, 0x00, 0x26, 0x08, 0x02, 0x05, 0x00, 0x2f, 0xcb, 0x09, 0x02, 0x01, 0x00,
0x28, 0xfa, 0x0a, 0x02, 0x05, 0x00, 0x29, 0xcc, 0x0b, 0x01, 0x01, 0x00, 0x3d, 0x0c, 0x02, 0x04,
0x27, 0x3f, 0xcd, 0x0d, 0x02, 0x04, 0x2b, 0x2a, 0xce, 0x10, 0x42, 0x03, 0x00, 0x00, 0x5c, 0x11,
0x42, 0x03, 0x00, 0x00, 0x7c, 0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x43, 0x04, 0x7a, 0x5a, 0x00,
0x1a, 0x16, 0x41, 0x00, 0x75, 0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f,
0x1a, 0x42, 0x03, 0xa0, 0xa0, 0xf6, 0x1b, 0x42, 0x03, 0xa0, 0xa0, 0x9e, 0x1e, 0x41, 0x00, 0x61,
0x41, 0x21, 0x42, 0x03, 0x00, 0x00, 0x5b, 0x22, 0x42, 0x03, 0x00, 0x00, 0x5d, 0x27, 0x43, 0x07,
0xa0, 0xa0, 0x00, 0x1d, 0x28, 0x42, 0x03, 0xa0, 0xa0, 0xe1, 0x29, 0x01, 0x03, 0xce, 0xcd, 0x2b,
0x42, 0x03, 0xa0, 0xa0, 0xcf, 0x2c, 0x43, 0x04, 0x79, 0x59, 0x00, 0x19, 0x2e, 0x41, 0x00, 0x63,
0x43, 0x2f, 0x42, 0x03, 0x00, 0x00, 0x40, 0x30, 0x42, 0x03, 0x00, 0x00, 0x7b, 0x31, 0x42, 0x00,
0x6e, 0x4e, 0x7d, 0x32, 0x42, 0x03, 0x00, 0x00, 0xf5, 0x33, 0x02, 0x01, 0x00, 0x3b, 0x3c, 0x34,
0x02, 0x01, 0x00, 0x3a, 0x3e, 0x35, 0x03, 0x04, 0x2d, 0x5f, 0x00, 0x1f, 0x39, 0x00, 0x00, 0x20,
0x56, 0x01, 0x00, 0x3c, 0x3e, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x7e, 0x03, 0x02, 0x07, 0x00,
0x00, 0xc8, 0x06, 0x02, 0x03, 0x00, 0x00, 0xf8, 0x08, 0x02, 0x07, 0x00, 0x00, 0xca, 0x0a, 0x02,
0x07, 0x00, 0x00, 0xcb, 0x0c, 0x02, 0x07, 0x00, 0x00, 0xcc, 0x0d, 0x02, 0x07, 0x00, 0x00, 0xcd,
0x1a, 0x41, 0x00, 0xa4, 0xa5, 0x1b, 0x42, 0x04, 0x9b, 0x9d, 0xa0, 0x1f, 0x41, 0x00, 0x73, 0x53,
0x27, 0x41, 0x00, 0x91, 0x92, 0x28, 0x41, 0x00, 0x86, 0x8f, 0x29, 0x01, 0x03, 0xcd, 0xcc, 0x2b,
0x42, 0x04, 0xa6, 0xa7, 0xa0, 0x32, 0x42, 0x03, 0x00, 0x00, 0x15, 0x00, 0x76, 0x07, 0x63, 0x91,
0x73, 0xa4, 0x7a, 0xa6, 0x43, 0x92, 0x53, 0xa5, 0x5a, 0xa7, 0x20, 0x76, 0x5e, 0x06, 0x61, 0x83,
0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x20, 0x5e, 0x60, 0x06, 0x61, 0x85, 0x65, 0x8a,
0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x27, 0x09, 0x61, 0xa0, 0x63, 0x86, 0x65, 0x82,
0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x43, 0x8f, 0x45, 0x90, 0x20, 0x27, 0x22, 0x0a, 0x61, 0x84,
0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x4f, 0x99, 0x55, 0x9a,
0x20, 0x22, 0x2c, 0x03, 0x63, 0x87, 0x43, 0x80, 0x20, 0x2c, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00,
0x7e, 0x03, 0x02, 0x07, 0x00, 0x00, 0xc8, 0x05, 0x02, 0x07, 0x00, 0x00, 0xca, 0x06, 0x02, 0x07,
0x00, 0x00, 0xcb, 0x07, 0x02, 0x07, 0x00, 0x00, 0xcc, 0x08, 0x02, 0x03, 0x00, 0x00, 0x60, 0x09,
0x02, 0x07, 0x00, 0x00, 0xcd, 0x0a, 0x02, 0x07, 0x00, 0x00, 0xce, 0x0b, 0x02, 0x07, 0x00, 0x00,
0xcf, 0x0c, 0x02, 0x07, 0x00, 0x00, 0xd0, 0x0d, 0x02, 0x07, 0x00, 0x00, 0xd1, 0x12, 0x42, 0x03,
0x00, 0x00, 0xaa, 0x13, 0x41, 0x00, 0x72, 0x52, 0x14, 0x41, 0x00, 0x74, 0x54, 0x1a, 0x41, 0x00,
0xe7, 0xe6, 0x1b, 0x41, 0x00, 0xd0, 0xd1, 0x1f, 0x41, 0x00, 0x73, 0x53, 0x20, 0x41, 0x00, 0x64,
0x44, 0x25, 0x42, 0x03, 0x00, 0x00, 0x88, 0x26, 0x42, 0x00, 0x6c, 0x4c, 0x9d, 0x27, 0x41, 0x00,
0x9f, 0xac, 0x28, 0x41, 0x00, 0x86, 0x8f, 0x29, 0x01, 0x03, 0xd1, 0xd0, 0x2b, 0x41, 0x00, 0xa7,
0xa6, 0x00, 0xf3, 0x13, 0x63, 0x9f, 0x64, 0xd4, 0x65, 0xd8, 0x6c, 0x96, 0x6e, 0xe5, 0x72, 0xfd,
0x73, 0xe7, 0x74, 0x9c, 0x7a, 0xa7, 0x43, 0xac, 0x44, 0xd2, 0x45, 0xb7, 0x4c, 0x95, 0x4e, 0xd5,
0x52, 0xfc, 0x53, 0xe6, 0x54, 0x9b, 0x5a, 0xa6, 0x20, 0xf3, 0x5e, 0x07, 0x61, 0x83, 0x69, 0x8c,
0x6f, 0x93, 0x41, 0xb6, 0x49, 0xd7, 0x4f, 0xe2, 0x20, 0x5e, 0xf4, 0x03, 0x61, 0xc7, 0x41, 0xc6,
0x20, 0xf4, 0xf8, 0x03, 0x75, 0x85, 0x55, 0xde, 0x20, 0xf8, 0xf2, 0x05, 0x61, 0xa5, 0x65, 0xa9,
0x41, 0xa4, 0x45, 0xa8, 0x20, 0xf2, 0xfa, 0x03, 0x7a, 0xbe, 0x5a, 0xbd, 0x20, 0xfa, 0xef, 0x19,
0x61, 0xa0, 0x63, 0x86, 0x65, 0x82, 0x69, 0xa1, 0x6c, 0x92, 0x6e, 0xe4, 0x6f, 0xa2, 0x72, 0xea,
0x73, 0x98, 0x75, 0xa3, 0x79, 0xec, 0x7a, 0xab, 0x41, 0xb5, 0x43, 0x8f, 0x45, 0x90, 0x49, 0xd6,
0x4c, 0x91, 0x4e, 0xe3, 0x4f, 0xe0, 0x52, 0xe8, 0x53, 0x97, 0x55, 0xe9, 0x59, 0xed, 0x5a, 0x8d,
0x20, 0xef, 0xf1, 0x05, 0x6f, 0x8b, 0x75, 0xfb, 0x4f, 0x8a, 0x55, 0xeb, 0x20, 0xf1, 0xf9, 0x09,
0x61, 0x84, 0x65, 0x89, 0x6f, 0x94, 0x75, 0x81, 0x41, 0x8e, 0x45, 0xd3, 0x4f, 0x99, 0x55, 0x9a,
0x20, 0xf9, 0xf7, 0x07, 0x63, 0x87, 0x73, 0xad, 0x74, 0xee, 0x43, 0x80, 0x53, 0xb8, 0x54, 0xdd,
0x20, 0xf7, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4,
0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88,
0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea,
0x20, 0x5e, 0xf8, 0x03, 0x61, 0x86, 0x41, 0x8f, 0x20, 0xf8, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a,
0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb,
0x20, 0x60, 0xef, 0x0d, 0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec,
0x41, 0xb5, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c,
0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3,
0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0xf7, 0x03, 0x63, 0x87, 0x43, 0x80, 0x20, 0xf7,
0x00 };

// Hungary (101-key)
Bit8u layout_HU[964] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x04, 0x00, 0x00, 0x48, 0x55, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00,
0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x03, 0xd3, 0x01, 0x44, 0x02, 0x00, 0x00, 0x5a, 0x03,
0x45, 0x01, 0x4c, 0x01, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x4c, 0x01, 0x00, 0x00, 0xb5, 0xe1,
0x05, 0x03, 0x59, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x07, 0x00, 0xcc, 0xc8, 0x03, 0x01, 0x03, 0x00,
0xcd, 0x04, 0x03, 0x05, 0x00, 0x2b, 0xc9, 0x1e, 0x05, 0x01, 0x01, 0x00, 0x21, 0x06, 0x02, 0x07,
0x00, 0x00, 0xca, 0x07, 0x01, 0x01, 0x00, 0x2f, 0x08, 0x02, 0x05, 0x00, 0x3d, 0xcb, 0x09, 0x02,
0x01, 0x00, 0x28, 0xfa, 0x0a, 0x02, 0x01, 0x00, 0x29, 0xef, 0x0b, 0x41, 0x00, 0x94, 0x99, 0x0c,
0x42, 0x00, 0x81, 0x9a, 0xf9, 0x0d, 0xc2, 0x04, 0xa2, 0x0d, 0xe0, 0x00, 0xce, 0x83, 0x10, 0x42,
0x03, 0x00, 0x00, 0x5c, 0x11, 0x42, 0x03, 0x00, 0x00, 0x7c, 0x12, 0x42, 0x00, 0x65, 0x45, 0x8e,
0x13, 0x42, 0x03, 0x00, 0x00, 0xf5, 0x14, 0x42, 0x03, 0x00, 0x00, 0xcf, 0x15, 0x41, 0x00, 0x79,
0x59, 0x16, 0x41, 0x00, 0x75, 0x55, 0x17, 0x42, 0x00, 0x69, 0x49, 0xd6, 0x18, 0x41, 0x00, 0x6f,
0x4f, 0x1a, 0x42, 0x03, 0xa0, 0xa0, 0xf6, 0x1b, 0x42, 0x00, 0xa3, 0xe9, 0x9e, 0x1e, 0x42, 0x00,
0x61, 0x41, 0x84, 0x21, 0x42, 0x03, 0x00, 0x00, 0x5b, 0x22, 0x42, 0x03, 0x00, 0x00, 0x5d, 0x24,
0x42, 0x03, 0x00, 0x00, 0xa1, 0x27, 0x42, 0x00, 0x82, 0x90, 0x24, 0x28, 0x42, 0x00, 0xa0, 0xb5,
0xe1, 0x29, 0x42, 0x00, 0xa1, 0xd6, 0x30, 0x2b, 0x42, 0x03, 0xa0, 0xa0, 0x5c, 0x2c, 0x42, 0x00,
0x7a, 0x5a, 0x3e, 0x2d, 0x42, 0x03, 0x00, 0x00, 0x23, 0x2e, 0x42, 0x00, 0x63, 0x43, 0x26, 0x2f,
0x42, 0x03, 0x00, 0x00, 0x40, 0x30, 0x42, 0x03, 0x00, 0x00, 0x7b, 0x31, 0x42, 0x00, 0x6e, 0x4e,
0x7d, 0x32, 0x42, 0x03, 0x00, 0x00, 0x3c, 0x33, 0x02, 0x00, 0x2c, 0x3f, 0x3b, 0x34, 0x02, 0x00,
0x2e, 0x3a, 0x3e, 0x35, 0x03, 0x00, 0x2d, 0x5f, 0x2a, 0x1f, 0x39, 0x00, 0x00, 0x20, 0x00, 0x16,
0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7,
0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93,
0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e, 0xf8, 0x03,
0x61, 0x86, 0x41, 0x8f, 0x20, 0xf8, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95,
0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x27, 0x0d,
0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5, 0x45, 0x90,
0x49, 0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0x27, 0x22, 0x0c, 0x61, 0x84, 0x65, 0x89,
0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99,
0x55, 0x9a, 0x20, 0x22, 0xf7, 0x03, 0x63, 0x87, 0x43, 0x80, 0x20, 0xf7, 0x00, 0x02, 0x02, 0x03,
0x00, 0xce, 0x7e, 0x03, 0x02, 0x07, 0x00, 0xd0, 0xc8, 0x04, 0x01, 0x03, 0x00, 0xcf, 0x05, 0x02,
0x07, 0x00, 0x00, 0xca, 0x06, 0x02, 0x07, 0x00, 0x00, 0xcb, 0x07, 0x02, 0x07, 0x00, 0x00, 0xcc,
0x08, 0x02, 0x03, 0x00, 0x00, 0x60, 0x09, 0x02, 0x07, 0x00, 0x00, 0xcd, 0x0b, 0x42, 0x03, 0x00,
0x00, 0xf1, 0x0d, 0xc2, 0x05, 0x00, 0x0d, 0xe0, 0x00, 0xd1, 0x83, 0x13, 0x41, 0x00, 0x72, 0x52,
0x14, 0x41, 0x00, 0x74, 0x54, 0x16, 0x42, 0x03, 0x00, 0x00, 0xaa, 0x1a, 0x41, 0x00, 0x8b, 0x8a,
0x1f, 0x42, 0x00, 0x73, 0x53, 0xd0, 0x20, 0x42, 0x00, 0x64, 0x44, 0xd1, 0x25, 0x42, 0x03, 0x00,
0x00, 0x88, 0x26, 0x42, 0x00, 0x6c, 0x4c, 0x9d, 0x2b, 0x41, 0x00, 0xfb, 0xeb, 0x00, 0xf3, 0x13,
0x63, 0x9f, 0x64, 0xd4, 0x65, 0xd8, 0x6c, 0x96, 0x6e, 0xe5, 0x72, 0xfd, 0x73, 0xe7, 0x74, 0x9c,
0x7a, 0xa7, 0x43, 0xac, 0x44, 0xd2, 0x45, 0xb7, 0x4c, 0x95, 0x4e, 0xd5, 0x52, 0xfc, 0x53, 0xe6,
0x54, 0x9b, 0x5a, 0xa6, 0x20, 0xf3, 0x5e, 0x07, 0x61, 0x83, 0x69, 0x8c, 0x6f, 0x93, 0x41, 0xb6,
0x49, 0xd7, 0x4f, 0xe2, 0x20, 0x5e, 0xf4, 0x03, 0x61, 0xc7, 0x41, 0xc6, 0x20, 0xf4, 0xf8, 0x03,
0x75, 0x85, 0x55, 0xde, 0x20, 0xf8, 0xf2, 0x05, 0x61, 0xa5, 0x65, 0xa9, 0x41, 0xa4, 0x45, 0xa8,
0x20, 0xf2, 0xfa, 0x03, 0x7a, 0xbe, 0x5a, 0xbd, 0x20, 0xfa, 0x27, 0x19, 0x61, 0xa0, 0x63, 0x86,
0x65, 0x82, 0x69, 0xa1, 0x6c, 0x92, 0x6e, 0xe4, 0x6f, 0xa2, 0x72, 0xea, 0x73, 0x98, 0x75, 0xa3,
0x79, 0xec, 0x7a, 0xab, 0x41, 0xb5, 0x43, 0x8f, 0x45, 0x90, 0x49, 0xd6, 0x4c, 0x91, 0x4e, 0xe3,
0x4f, 0xe0, 0x52, 0xe8, 0x53, 0x97, 0x55, 0xe9, 0x59, 0xed, 0x5a, 0x8d, 0x20, 0x27, 0x2b, 0x05,
0x6f, 0x8b, 0x75, 0xfb, 0x4f, 0x8a, 0x55, 0xeb, 0x20, 0x2b, 0x22, 0x09, 0x61, 0x84, 0x65, 0x89,
0x6f, 0x94, 0x75, 0x81, 0x41, 0x8e, 0x45, 0xd3, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0xf7, 0x07,
0x63, 0x87, 0x73, 0xad, 0x74, 0xee, 0x43, 0x80, 0x53, 0xb8, 0x54, 0xdd, 0x20, 0xf7, 0x00, 0x02,
0x01, 0x03, 0x00, 0xcc, 0x03, 0x01, 0x03, 0x00, 0xce, 0x04, 0x01, 0x03, 0x00, 0xcd, 0x0a, 0x02,
0x07, 0x00, 0x00, 0xcc, 0x0b, 0x42, 0x07, 0x00, 0x00, 0xcd, 0x0c, 0x42, 0x07, 0x00, 0x00, 0xce,
0x0d, 0x42, 0x05, 0x00, 0x95, 0xcf, 0x13, 0x42, 0x03, 0x00, 0x00, 0x15, 0x14, 0x42, 0x07, 0x00,
0x00, 0xa0, 0x17, 0x42, 0x03, 0x00, 0x00, 0x8d, 0x1a, 0x41, 0x00, 0x93, 0xa7, 0x1b, 0x42, 0x05,
0x00, 0x97, 0xa0, 0x28, 0x41, 0x01, 0x00, 0x8f, 0x29, 0x41, 0x01, 0x00, 0x8d, 0x2b, 0x41, 0x00,
0x96, 0x98, 0x00, 0x7e, 0x03, 0x6e, 0xa4, 0x4e, 0xa5, 0x20, 0x7e, 0x5e, 0x04, 0x61, 0x83, 0x65,
0x88, 0x69, 0x8c, 0x20, 0x5e, 0xf8, 0x02, 0x61, 0x86, 0x20, 0xf8, 0x60, 0x03, 0x61, 0x85, 0x65,
0x8a, 0x20, 0x60, 0x27, 0x0b, 0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x41,
0x8f, 0x45, 0x90, 0x49, 0x8d, 0x4f, 0x95, 0x55, 0x97, 0x20, 0x27, 0x2b, 0x05, 0x6f, 0x93, 0x75,
0x96, 0x4f, 0xa7, 0x55, 0x98, 0x20, 0x2b, 0x22, 0x09, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f,
0x94, 0x75, 0x81, 0x41, 0x8e, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0x2c, 0x03, 0x63, 0x87, 0x43,
0x80, 0x20, 0x2c, 0x00  };

// Italy (Standard)
Bit8u layout_IT[236] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x49, 0x54, 0x2c, 0x8d, 0x00, 0x49, 0x54, 0x04,
0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x03, 0xd0, 0x00, 0x00,
0x00, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb5, 0x01, 0xca, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x01, 0x01, 0x00, 0x22,
0x04, 0x02, 0x01, 0x00, 0x9c, 0x23, 0x07, 0x01, 0x01, 0x00, 0x26, 0x08, 0x02, 0x01, 0x00, 0x2f,
0x7b, 0x09, 0x03, 0x01, 0x00, 0x28, 0x5b, 0x1b, 0x0a, 0x03, 0x01, 0x00, 0x29, 0x5d, 0x1d, 0x0b,
0x02, 0x01, 0x00, 0x3d, 0x7d, 0x0c, 0x01, 0x00, 0x27, 0x3f, 0x0d, 0x03, 0x00, 0x8d, 0x5e, 0x7e,
0x1e, 0x10, 0x42, 0x03, 0x00, 0x00, 0x40, 0x1a, 0x04, 0x08, 0x8a, 0x82, 0x5b, 0x00, 0x7b, 0x1b,
0x04, 0x08, 0x2b, 0x2a, 0x5d, 0x00, 0x7d, 0x27, 0x02, 0x00, 0x95, 0x87, 0x40, 0x28, 0x02, 0x00,
0x85, 0xf8, 0x23, 0x29, 0x03, 0x04, 0x5c, 0x7c, 0x00, 0x1c, 0x2b, 0x02, 0x00, 0x97, 0xf5, 0x60,
0x33, 0x02, 0x01, 0x00, 0x3b, 0x3c, 0x34, 0x02, 0x01, 0x00, 0x3a, 0x3e, 0x35, 0x03, 0x04, 0x2d,
0x5f, 0x00, 0x1f, 0x56, 0x01, 0x00, 0x3c, 0x3e, 0x00, 0x2b, 0x01, 0x01, 0x00, 0x15, 0x00, 0x06,
0x02, 0x03, 0x00, 0x00, 0xd5, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00  };

// Netherlands (102-key)
Bit8u layout_NL[552] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x4e, 0x4c, 0x2c, 0x8f, 0x00, 0x4e, 0x4c, 0x04,
0x02, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x03, 0x93, 0x01, 0x9a,
0x01, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x9a, 0x01, 0x00, 0x00, 0xb5, 0x01, 0x16, 0x01, 0x40,
0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0xfb, 0x03, 0x02, 0x01, 0x00, 0x22, 0xfd, 0x04,
0x02, 0x03, 0x00, 0x00, 0xfc, 0x05, 0x02, 0x03, 0x00, 0x00, 0xac, 0x06, 0x02, 0x03, 0x00, 0x00,
0xab, 0x07, 0x02, 0x01, 0x00, 0x26, 0xf3, 0x08, 0x03, 0x01, 0x00, 0x5f, 0x9c, 0x1f, 0x09, 0x02,
0x01, 0x00, 0x28, 0x7b, 0x0a, 0x02, 0x01, 0x00, 0x29, 0x7d, 0x0b, 0x01, 0x01, 0x00, 0x27, 0x0c,
0x03, 0x00, 0x2f, 0x3f, 0x5c, 0x1c, 0x0d, 0x02, 0x06, 0xf8, 0xc9, 0xcd, 0x12, 0x41, 0x00, 0x65,
0x45, 0x13, 0x42, 0x03, 0x00, 0x00, 0xf4, 0x15, 0x41, 0x00, 0x79, 0x59, 0x16, 0x41, 0x00, 0x75,
0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1a, 0x03, 0x07, 0xcc, 0xca,
0x00, 0x1e, 0x1b, 0x02, 0x00, 0x2a, 0x7c, 0xdd, 0x1e, 0x41, 0x00, 0x61, 0x41, 0x1f, 0x42, 0x03,
0x00, 0x00, 0xe1, 0x27, 0x01, 0x00, 0x2b, 0xf1, 0x28, 0x01, 0x03, 0xcb, 0xc8, 0x29, 0x02, 0x00,
0x40, 0xf5, 0xaa, 0x2b, 0x01, 0x00, 0x3c, 0x3e, 0x2c, 0x42, 0x03, 0x00, 0x00, 0xae, 0x2d, 0x42,
0x03, 0x00, 0x00, 0xaf, 0x2e, 0x42, 0x00, 0x63, 0x43, 0xbd, 0x31, 0x41, 0x00, 0x6e, 0x4e, 0x32,
0x42, 0x03, 0x00, 0x00, 0xe6, 0x33, 0x03, 0x01, 0x00, 0x3b, 0x5b, 0x1b, 0x34, 0x02, 0x01, 0x00,
0x3a, 0xfa, 0x35, 0x03, 0x00, 0x2d, 0x3d, 0x5d, 0x1d, 0x39, 0x00, 0x00, 0x20, 0x56, 0x03, 0x00,
0x5d, 0x5b, 0x7c, 0x1d, 0x00, 0x02, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x04, 0x02, 0x07, 0x00, 0x00,
0xa0, 0x07, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x13, 0x42, 0x03, 0x00, 0x00, 0x14, 0x1b, 0x02, 0x07,
0x00, 0x00, 0xa0, 0x29, 0x01, 0x01, 0x00, 0x15, 0x2e, 0x42, 0x03, 0x00, 0x00, 0x9b, 0x00, 0x60,
0x06, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x7e, 0x03, 0x6e,
0xa4, 0x4e, 0xa5, 0x20, 0x7e, 0x5e, 0x06, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75,
0x96, 0x20, 0x5e, 0x27, 0x07, 0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x45,
0x90, 0x20, 0x27, 0x22, 0x0a, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79,
0x98, 0x41, 0x8e, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0x2c, 0x03, 0x63, 0x87, 0x43, 0x80, 0x20,
0x2c, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69,
0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20,
0x60, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20,
0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45,
0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e, 0xef, 0x0d, 0x61, 0xa0, 0x65, 0x82, 0x69,
0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55,
0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75,
0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0xf7,
0x03, 0x63, 0x87, 0x43, 0x80, 0x20, 0xf7, 0x00  };

// Norway
Bit8u layout_NO[477] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x4e, 0x4f, 0x2c, 0x9b, 0x00, 0x4e, 0x4f, 0x04,
0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x03, 0xec, 0x00, 0xf9,
0x00, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0xf9, 0x00, 0x00, 0x00, 0x61, 0x03, 0x74, 0x01, 0x7f,
0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x03, 0x02, 0x01, 0x00, 0x22, 0x40, 0x04, 0x02, 0x03, 0x00, 0x00, 0x9c, 0x05,
0x02, 0x01, 0x00, 0xcf, 0x24, 0x07, 0x01, 0x01, 0x00, 0x26, 0x08, 0x02, 0x01, 0x00, 0x2f, 0x7b,
0x09, 0x03, 0x01, 0x00, 0x28, 0x5b, 0x1b, 0x0a, 0x03, 0x01, 0x00, 0x29, 0x5d, 0x1d, 0x0b, 0x02,
0x01, 0x00, 0x3d, 0x7d, 0x0c, 0x01, 0x00, 0x2b, 0x3f, 0x0d, 0x03, 0x06, 0x5c, 0xc8, 0xcb, 0x1c,
0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x41, 0x00, 0x79, 0x59, 0x16, 0x41, 0x00, 0x75, 0x55, 0x17,
0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1a, 0x41, 0x00, 0x86, 0x8f, 0x1b, 0x03,
0x07, 0xcc, 0xca, 0xc9, 0x1e, 0x1e, 0x41, 0x00, 0x61, 0x41, 0x27, 0x41, 0x00, 0x9b, 0x9d, 0x28,
0x41, 0x00, 0x91, 0x92, 0x29, 0x01, 0x00, 0x7c, 0xf5, 0x2b, 0x01, 0x00, 0x27, 0x2a, 0x2e, 0x41,
0x00, 0x63, 0x43, 0x31, 0x41, 0x00, 0x6e, 0x4e, 0x32, 0x42, 0x03, 0x00, 0x00, 0xe6, 0x33, 0x02,
0x01, 0x00, 0x3b, 0x3c, 0x34, 0x02, 0x01, 0x00, 0x3a, 0x3e, 0x35, 0x03, 0x04, 0x2d, 0x5f, 0x00,
0x1f, 0x39, 0x00, 0x00, 0x20, 0x56, 0x01, 0x00, 0x3c, 0x3e, 0x00, 0x06, 0x02, 0x03, 0x00, 0x00,
0xd5, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d,
0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60,
0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e,
0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2,
0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e, 0xef, 0x0f, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82,
0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5, 0x43, 0x80, 0x45, 0x90, 0x49, 0xd6,
0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b,
0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a,
0x20, 0xf9, 0x00, 0x05, 0x01, 0x01, 0x00, 0xaf, 0x29, 0x01, 0x01, 0x00, 0x15, 0x00, 0x60, 0x06,
0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x7e, 0x03, 0x6e, 0xa4,
0x4e, 0xa5, 0x20, 0x7e, 0x5e, 0x06, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96,
0x20, 0x5e, 0x27, 0x09, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3,
0x43, 0x80, 0x45, 0x90, 0x20, 0x27, 0x22, 0x0a, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94,
0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0x00  };

// Poland (101-key, prog.)
Bit8u layout_PL[261] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x50, 0x4c, 0x2c, 0xc9, 0x01, 0x50, 0x4c, 0x08,
0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x03, 0x70, 0x00, 0x00,
0x00, 0x00, 0x00, 0x9c, 0x02, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0x03, 0xaf, 0x00, 0x00,
0x00, 0x00, 0x00, 0x16, 0x03, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9b, 0x02, 0xaf, 0x00, 0x00,
0x00, 0x00, 0x00, 0x5a, 0x03, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x18, 0xc3, 0x03, 0x00, 0x00, 0x00, 0x00, 0xa2, 0x00, 0xe0, 0x00, 0x00, 0x12,
0x43, 0x03, 0x00, 0x00, 0xa9, 0xa8, 0x16, 0x42, 0x03, 0x00, 0x00, 0xaa, 0x1e, 0x43, 0x03, 0x00,
0x00, 0xa5, 0xa4, 0x1f, 0x43, 0x03, 0x00, 0x00, 0x98, 0x97, 0x26, 0x43, 0x03, 0x00, 0x00, 0x88,
0x9d, 0x2c, 0x43, 0x03, 0x00, 0x00, 0xbe, 0xbd, 0x2d, 0x43, 0x03, 0x00, 0x00, 0xab, 0x8d, 0x2e,
0x43, 0x03, 0x00, 0x00, 0x86, 0x8f, 0x31, 0x43, 0x03, 0x00, 0x00, 0xe4, 0xe3, 0x00, 0x12, 0x43,
0x03, 0x00, 0x00, 0x91, 0x90, 0x18, 0x43, 0x07, 0x00, 0x00, 0x00, 0xa3, 0x1e, 0x43, 0x03, 0x00,
0x00, 0x86, 0x8f, 0x1f, 0x43, 0x03, 0x00, 0x00, 0x9e, 0x98, 0x26, 0x43, 0x03, 0x00, 0x00, 0x92,
0x9c, 0x2c, 0x43, 0x03, 0x00, 0x00, 0xa7, 0xa1, 0x2d, 0x43, 0x03, 0x00, 0x00, 0xa6, 0xa0, 0x2e,
0x43, 0x03, 0x00, 0x00, 0x8d, 0x95, 0x31, 0x43, 0x03, 0x00, 0x00, 0xa4, 0xa5, 0x00, 0x16, 0x42,
0x03, 0x00, 0x00, 0xd5, 0x00  };

// Russian Federation (Standard)
Bit8u layout_RU[1130] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x52, 0x55, 0x2c, 0xb9, 0x01, 0x52, 0x55, 0x0b,
0x02, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x03, 0xa2, 0x01, 0x00,
0x00, 0x00, 0x00, 0x28, 0x03, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x03, 0x8b, 0x02, 0x00,
0x00, 0x00, 0x00, 0x62, 0x03, 0xb6, 0x01, 0x00, 0x00, 0x00, 0x00, 0x68, 0x03, 0x6d, 0x03, 0x00,
0x00, 0x00, 0x00, 0x68, 0x03, 0x99, 0x02, 0x00, 0x00, 0x00, 0x00, 0x57, 0x03, 0x53, 0x04, 0x00,
0x00, 0x00, 0x00, 0x57, 0x03, 0x81, 0x03, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x03, 0xc5, 0x00, 0x00,
0x00, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x02, 0x03, 0x00, 0x00,
0x40, 0x04, 0x02, 0x03, 0x00, 0x00, 0x23, 0x05, 0x02, 0x03, 0x00, 0x00, 0xcf, 0x07, 0x02, 0x03,
0x00, 0x00, 0x5e, 0x08, 0x02, 0x03, 0x00, 0x00, 0x26, 0x09, 0x02, 0x03, 0x00, 0x00, 0x24, 0x1a,
0x02, 0x03, 0x00, 0x00, 0x5b, 0x1b, 0x02, 0x03, 0x00, 0x00, 0x5d, 0x2b, 0x02, 0x03, 0x00, 0x00,
0x7c, 0x33, 0x02, 0x03, 0x00, 0x00, 0x3c, 0x34, 0x02, 0x03, 0x00, 0x00, 0x3e, 0x35, 0x02, 0x03,
0x00, 0x00, 0x2f, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x03, 0x01, 0x01, 0x00, 0x22,
0x04, 0x01, 0x01, 0x00, 0xfc, 0x05, 0x02, 0x05, 0x00, 0x3b, 0xa0, 0x07, 0x01, 0x01, 0x00, 0x3a,
0x08, 0x01, 0x01, 0x00, 0x3f, 0x10, 0x41, 0x00, 0xa9, 0x89, 0x11, 0x41, 0x00, 0xe6, 0x96, 0x12,
0x41, 0x00, 0xe3, 0x93, 0x13, 0x41, 0x00, 0xaa, 0x8a, 0x14, 0x42, 0x00, 0xa5, 0x85, 0xfd, 0x15,
0x41, 0x00, 0xad, 0x8d, 0x16, 0x41, 0x00, 0xa3, 0x83, 0x17, 0x41, 0x00, 0xe8, 0x98, 0x18, 0x41,
0x00, 0xe9, 0x99, 0x19, 0x41, 0x00, 0xa7, 0x87, 0x1a, 0x41, 0x00, 0xe5, 0x95, 0x1b, 0x41, 0x00,
0xea, 0x9a, 0x1e, 0x41, 0x00, 0xe4, 0x94, 0x1f, 0x41, 0x00, 0xeb, 0x9b, 0x20, 0x41, 0x00, 0xa2,
0x82, 0x21, 0x41, 0x00, 0xa0, 0x80, 0x22, 0x41, 0x00, 0xaf, 0x8f, 0x23, 0xc1, 0x00, 0xe0, 0x00,
0x90, 0x23, 0x24, 0x41, 0x00, 0xae, 0x8e, 0x25, 0x41, 0x00, 0xab, 0x8b, 0x26, 0x41, 0x00, 0xa4,
0x84, 0x27, 0x41, 0x00, 0xa6, 0x86, 0x28, 0x41, 0x00, 0xed, 0x9d, 0x29, 0xc1, 0x00, 0xf1, 0x29,
0xf0, 0x00, 0x2a, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x78, 0x2b, 0x01, 0x01, 0x00, 0x2f, 0x2c, 0x41,
0x00, 0xef, 0x9f, 0x2d, 0x41, 0x00, 0xe7, 0x97, 0x2e, 0x41, 0x00, 0xe1, 0x91, 0x2f, 0x41, 0x00,
0xac, 0x8c, 0x30, 0x41, 0x00, 0xa8, 0x88, 0x31, 0x41, 0x00, 0xe2, 0x92, 0x32, 0x41, 0x00, 0xec,
0x9c, 0x33, 0x41, 0x00, 0xa1, 0x81, 0x34, 0x41, 0x00, 0xee, 0x9e, 0x35, 0x01, 0x00, 0x2e, 0x2c,
0x00, 0x05, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x12, 0x42, 0x03, 0x00, 0x00, 0xfd, 0x36, 0x03, 0x0f,
0x00, 0x00, 0x00, 0x79, 0x00, 0x03, 0x01, 0x01, 0x00, 0x22, 0x04, 0x01, 0x01, 0x00, 0xfc, 0x05,
0x02, 0x01, 0x00, 0x3b, 0xfd, 0x07, 0x01, 0x01, 0x00, 0x3a, 0x08, 0x01, 0x01, 0x00, 0x3f, 0x10,
0x41, 0x00, 0xa9, 0x89, 0x11, 0x41, 0x00, 0xe6, 0x96, 0x12, 0x41, 0x00, 0xe3, 0x93, 0x13, 0x41,
0x00, 0xaa, 0x8a, 0x14, 0x41, 0x00, 0xa5, 0x85, 0x15, 0x41, 0x00, 0xad, 0x8d, 0x16, 0x41, 0x00,
0xa3, 0x83, 0x17, 0x41, 0x00, 0xe8, 0x98, 0x18, 0x41, 0x00, 0xe9, 0x99, 0x19, 0x41, 0x00, 0xa7,
0x87, 0x1a, 0x41, 0x00, 0xe5, 0x95, 0x1b, 0x41, 0x00, 0xea, 0x9a, 0x1e, 0x41, 0x00, 0xe4, 0x94,
0x1f, 0x41, 0x00, 0xeb, 0x9b, 0x20, 0x41, 0x00, 0xa2, 0x82, 0x21, 0x41, 0x00, 0xa0, 0x80, 0x22,
0x41, 0x00, 0xaf, 0x8f, 0x23, 0xc1, 0x00, 0xe0, 0x00, 0x90, 0x23, 0x24, 0x41, 0x00, 0xae, 0x8e,
0x25, 0x41, 0x00, 0xab, 0x8b, 0x26, 0x41, 0x00, 0xa4, 0x84, 0x27, 0x41, 0x00, 0xa6, 0x86, 0x28,
0x41, 0x00, 0xed, 0x9d, 0x29, 0xc1, 0x00, 0xf1, 0x29, 0xf0, 0x00, 0x2a, 0x03, 0x0f, 0x00, 0x00,
0x00, 0x7a, 0x2b, 0x01, 0x01, 0x00, 0x2f, 0x2c, 0x41, 0x00, 0xef, 0x9f, 0x2d, 0x41, 0x00, 0xe7,
0x97, 0x2e, 0x41, 0x00, 0xe1, 0x91, 0x2f, 0x41, 0x00, 0xac, 0x8c, 0x30, 0x41, 0x00, 0xa8, 0x88,
0x31, 0x41, 0x00, 0xe2, 0x92, 0x32, 0x41, 0x00, 0xec, 0x9c, 0x33, 0x41, 0x00, 0xa1, 0x81, 0x34,
0x41, 0x00, 0xee, 0x9e, 0x35, 0x01, 0x00, 0x2e, 0x2c, 0x00, 0x05, 0x02, 0x03, 0x00, 0x00, 0xfd,
0x36, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x7b, 0x00, 0x03, 0x01, 0x01, 0x00, 0x22, 0x04, 0x01, 0x01,
0x00, 0xef, 0x05, 0x02, 0x05, 0x00, 0x3b, 0xa0, 0x07, 0x01, 0x01, 0x00, 0x3a, 0x08, 0x01, 0x01,
0x00, 0x3f, 0x10, 0x41, 0x00, 0xbd, 0xbe, 0x11, 0x41, 0x00, 0xa4, 0xa5, 0x12, 0x41, 0x00, 0xe7,
0xe8, 0x13, 0x41, 0x00, 0xc6, 0xc7, 0x14, 0x42, 0x00, 0xa8, 0xa9, 0xcf, 0x15, 0x41, 0x00, 0xd4,
0xd5, 0x16, 0x41, 0x00, 0xac, 0xad, 0x17, 0x41, 0x00, 0xf5, 0xf6, 0x18, 0x41, 0x00, 0xf9, 0xfa,
0x19, 0x41, 0x00, 0xf3, 0xf4, 0x1a, 0x41, 0x00, 0xb5, 0xb6, 0x1b, 0x41, 0x00, 0x9e, 0x9f, 0x1e,
0x41, 0x00, 0xaa, 0xab, 0x1f, 0x41, 0x00, 0xf1, 0xf2, 0x20, 0x41, 0x00, 0xeb, 0xec, 0x21, 0x41,
0x00, 0xa0, 0xa1, 0x22, 0x41, 0x00, 0xd8, 0xdd, 0x23, 0x41, 0x00, 0xe1, 0xe2, 0x24, 0x41, 0x00,
0xd6, 0xd7, 0x25, 0x41, 0x00, 0xd0, 0xd1, 0x26, 0x41, 0x00, 0xa6, 0xa7, 0x27, 0x41, 0x00, 0xe9,
0xea, 0x28, 0x41, 0x00, 0xf7, 0xf8, 0x29, 0x41, 0x00, 0x84, 0x85, 0x2a, 0x03, 0x0f, 0x00, 0x00,
0x00, 0x7c, 0x2b, 0x01, 0x01, 0x00, 0x2f, 0x2c, 0xc1, 0x00, 0xde, 0x2c, 0xe0, 0x00, 0x2d, 0x41,
0x00, 0xfb, 0xfc, 0x2e, 0x41, 0x00, 0xe3, 0xe4, 0x2f, 0x41, 0x00, 0xd2, 0xd3, 0x30, 0x41, 0x00,
0xb7, 0xb8, 0x31, 0x41, 0x00, 0xe5, 0xe6, 0x32, 0x41, 0x00, 0xed, 0xee, 0x33, 0x41, 0x00, 0xa2,
0xa3, 0x34, 0x41, 0x00, 0x9c, 0x9d, 0x35, 0x01, 0x00, 0x2e, 0x2c, 0x00, 0x05, 0x02, 0x07, 0x00,
0x00, 0xa0, 0x12, 0x42, 0x03, 0x00, 0x00, 0xcf, 0x36, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x7d, 0x00,
0x03, 0x01, 0x01, 0x00, 0x22, 0x04, 0x01, 0x01, 0x00, 0xef, 0x05, 0x01, 0x01, 0x00, 0x3b, 0x07,
0x01, 0x01, 0x00, 0x3a, 0x08, 0x01, 0x01, 0x00, 0x3f, 0x10, 0x41, 0x00, 0xbd, 0xbe, 0x11, 0x41,
0x00, 0xa4, 0xa5, 0x12, 0x41, 0x00, 0xe7, 0xe8, 0x13, 0x41, 0x00, 0xc6, 0xc7, 0x14, 0x41, 0x00,
0xa8, 0xa9, 0x15, 0x41, 0x00, 0xd4, 0xd5, 0x16, 0x41, 0x00, 0xac, 0xad, 0x17, 0x41, 0x00, 0xf5,
0xf6, 0x18, 0x41, 0x00, 0xf9, 0xfa, 0x19, 0x41, 0x00, 0xf3, 0xf4, 0x1a, 0x41, 0x00, 0xb5, 0xb6,
0x1b, 0x41, 0x00, 0x9e, 0x9f, 0x1e, 0x41, 0x00, 0xaa, 0xab, 0x1f, 0x41, 0x00, 0xf1, 0xf2, 0x20,
0x41, 0x00, 0xeb, 0xec, 0x21, 0x41, 0x00, 0xa0, 0xa1, 0x22, 0x41, 0x00, 0xd8, 0xdd, 0x23, 0x41,
0x00, 0xe1, 0xe2, 0x24, 0x41, 0x00, 0xd6, 0xd7, 0x25, 0x41, 0x00, 0xd0, 0xd1, 0x26, 0x41, 0x00,
0xa6, 0xa7, 0x27, 0x41, 0x00, 0xe9, 0xea, 0x28, 0x41, 0x00, 0xf7, 0xf8, 0x29, 0x41, 0x00, 0x84,
0x85, 0x2a, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x7e, 0x2b, 0x01, 0x01, 0x00, 0x2f, 0x2c, 0xc1, 0x00,
0xde, 0x2c, 0xe0, 0x00, 0x2d, 0x41, 0x00, 0xfb, 0xfc, 0x2e, 0x41, 0x00, 0xe3, 0xe4, 0x2f, 0x41,
0x00, 0xd2, 0xd3, 0x30, 0x41, 0x00, 0xb7, 0xb8, 0x31, 0x41, 0x00, 0xe5, 0xe6, 0x32, 0x41, 0x00,
0xed, 0xee, 0x33, 0x41, 0x00, 0xa2, 0xa3, 0x34, 0x41, 0x00, 0x9c, 0x9d, 0x35, 0x01, 0x00, 0x2e,
0x2c, 0x00, 0x36, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x7f, 0x00  };

// Slovakia
Bit8u layout_SK[993] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x09, 0x00, 0x00, 0x53, 0x4b, 0x2c, 0xf5, 0x00, 0x53, 0x4b, 0x05,
0x02, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x03, 0x35, 0x01, 0xad,
0x01, 0x00, 0x00, 0x5a, 0x03, 0x44, 0x03, 0x4b, 0x03, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x4b,
0x03, 0x00, 0x00, 0x63, 0x03, 0x6e, 0x02, 0xd7, 0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x2b, 0x31,
0xc8, 0x03, 0x01, 0x01, 0xa0, 0x32, 0x04, 0x03, 0x05, 0xa0, 0x33, 0xc9, 0x1e, 0x05, 0x01, 0x01,
0xa0, 0x34, 0x06, 0x02, 0x05, 0xa0, 0x35, 0xca, 0x07, 0x01, 0x01, 0xa0, 0x36, 0x08, 0x02, 0x04,
0xec, 0x37, 0xcb, 0x09, 0x02, 0x00, 0xa0, 0x38, 0xfa, 0x0a, 0x02, 0x04, 0xa1, 0x39, 0xcc, 0x0b,
0x01, 0x00, 0x82, 0x30, 0x0c, 0x02, 0x04, 0x3d, 0x25, 0xcd, 0x0d, 0x02, 0x07, 0xcc, 0xa0, 0xce,
0x10, 0x42, 0x03, 0x00, 0x00, 0x5c, 0x11, 0x42, 0x03, 0x00, 0x00, 0x7c, 0x12, 0x41, 0x00, 0x65,
0x45, 0x15, 0x43, 0x04, 0x7a, 0x5a, 0x00, 0x1a, 0x16, 0x41, 0x00, 0x75, 0x55, 0x17, 0x41, 0x00,
0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x19, 0x42, 0x03, 0x00, 0x00, 0x27, 0x1a, 0x02, 0x00,
0xa3, 0x2f, 0xf6, 0x1b, 0x02, 0x00, 0x84, 0x28, 0x9e, 0x1e, 0x42, 0x00, 0x61, 0x41, 0x3c, 0x21,
0x42, 0x03, 0x00, 0x00, 0x5b, 0x22, 0x42, 0x03, 0x00, 0x00, 0x5d, 0x27, 0x02, 0x00, 0x93, 0x22,
0x24, 0x28, 0x02, 0x00, 0xf5, 0x21, 0xe1, 0x29, 0x01, 0x02, 0x3b, 0xca, 0x2b, 0x02, 0x01, 0xa0,
0x29, 0xcf, 0x2c, 0x43, 0x00, 0x79, 0x59, 0x3e, 0x19, 0x2d, 0x42, 0x03, 0x00, 0x00, 0x23, 0x2e,
0x42, 0x00, 0x63, 0x43, 0x26, 0x2f, 0x42, 0x03, 0x00, 0x00, 0x40, 0x30, 0x42, 0x03, 0x00, 0x00,
0x7b, 0x31, 0x42, 0x00, 0x6e, 0x4e, 0x7d, 0x33, 0x01, 0x01, 0x00, 0x3f, 0x34, 0x02, 0x01, 0x00,
0x3a, 0x2a, 0x35, 0x03, 0x04, 0x2d, 0x5f, 0x00, 0x1f, 0x39, 0x00, 0x00, 0x20, 0x56, 0x02, 0x00,
0x26, 0x2a, 0x3c, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x7e, 0x03, 0x02, 0x06, 0x96, 0x00, 0xc8,
0x04, 0x00, 0x00, 0xe7, 0x05, 0x02, 0x06, 0x9f, 0x00, 0xca, 0x06, 0x02, 0x06, 0x9c, 0x00, 0xcb,
0x07, 0x02, 0x06, 0xa7, 0x00, 0xcc, 0x08, 0x02, 0x03, 0x00, 0x00, 0x60, 0x09, 0x02, 0x07, 0x00,
0x00, 0xcd, 0x0a, 0x02, 0x07, 0x00, 0x00, 0xce, 0x0b, 0x02, 0x07, 0x00, 0x00, 0xcf, 0x0c, 0x02,
0x07, 0x00, 0x00, 0xd0, 0x0d, 0x02, 0x07, 0xce, 0xc8, 0xd1, 0x12, 0x42, 0x03, 0x00, 0x00, 0xaa,
0x13, 0x41, 0x00, 0x72, 0x52, 0x14, 0x41, 0x00, 0x74, 0x54, 0x1f, 0x42, 0x00, 0x73, 0x53, 0xd0,
0x20, 0x42, 0x00, 0x64, 0x44, 0xd1, 0x25, 0x42, 0x03, 0x00, 0x00, 0x88, 0x26, 0x42, 0x00, 0x6c,
0x4c, 0x9d, 0x29, 0x01, 0x03, 0x00, 0xcb, 0x2b, 0x00, 0x00, 0xe5, 0x00, 0xf3, 0x13, 0x63, 0x9f,
0x64, 0xd4, 0x65, 0xd8, 0x6c, 0x96, 0x6e, 0xe5, 0x72, 0xfd, 0x73, 0xe7, 0x74, 0x9c, 0x7a, 0xa7,
0x43, 0xac, 0x44, 0xd2, 0x45, 0xb7, 0x4c, 0x95, 0x4e, 0xd5, 0x52, 0xfc, 0x53, 0xe6, 0x54, 0x9b,
0x5a, 0xa6, 0x20, 0xf3, 0x5e, 0x07, 0x61, 0x83, 0x69, 0x8c, 0x6f, 0x93, 0x41, 0xb6, 0x49, 0xd7,
0x4f, 0xe2, 0x20, 0x5e, 0xf4, 0x03, 0x61, 0xc7, 0x41, 0xc6, 0x20, 0xf4, 0xf8, 0x03, 0x75, 0x85,
0x55, 0xde, 0x20, 0xf8, 0xf2, 0x05, 0x61, 0xa5, 0x65, 0xa9, 0x41, 0xa4, 0x45, 0xa8, 0x20, 0xf2,
0xfa, 0x03, 0x7a, 0xbe, 0x5a, 0xbd, 0x20, 0xfa, 0xef, 0x19, 0x61, 0xa0, 0x63, 0x86, 0x65, 0x82,
0x69, 0xa1, 0x6c, 0x92, 0x6e, 0xe4, 0x6f, 0xa2, 0x72, 0xea, 0x73, 0x98, 0x75, 0xa3, 0x79, 0xec,
0x7a, 0xab, 0x41, 0xb5, 0x43, 0x8f, 0x45, 0x90, 0x49, 0xd6, 0x4c, 0x91, 0x4e, 0xe3, 0x4f, 0xe0,
0x52, 0xe8, 0x53, 0x97, 0x55, 0xe9, 0x59, 0xed, 0x5a, 0x8d, 0x20, 0xef, 0xf1, 0x05, 0x6f, 0x8b,
0x75, 0xfb, 0x4f, 0x8a, 0x55, 0xeb, 0x20, 0xf1, 0xf9, 0x09, 0x61, 0x84, 0x65, 0x89, 0x6f, 0x94,
0x75, 0x81, 0x41, 0x8e, 0x45, 0xd3, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0xf7, 0x07, 0x63, 0x87,
0x73, 0xad, 0x74, 0xee, 0x43, 0x80, 0x53, 0xb8, 0x54, 0xdd, 0x20, 0xf7, 0x00, 0x02, 0x02, 0x03,
0x00, 0x00, 0x7e, 0x03, 0x02, 0x06, 0x8c, 0x00, 0xc8, 0x04, 0x00, 0x00, 0xa8, 0x05, 0x00, 0x00,
0x87, 0x06, 0x00, 0x00, 0x9f, 0x07, 0x00, 0x00, 0x91, 0x08, 0x02, 0x02, 0x98, 0x00, 0x60, 0x09,
0x02, 0x07, 0x00, 0x00, 0xa0, 0x0a, 0x02, 0x07, 0x00, 0x00, 0xcb, 0x0c, 0x02, 0x07, 0x00, 0x00,
0xcc, 0x0d, 0x02, 0x07, 0xcb, 0xc8, 0xa0, 0x13, 0x41, 0x00, 0x72, 0x52, 0x14, 0x41, 0x00, 0x74,
0x54, 0x1b, 0x02, 0x07, 0x00, 0x00, 0xa0, 0x1f, 0x41, 0x00, 0x73, 0x53, 0x20, 0x41, 0x00, 0x64,
0x44, 0x26, 0x41, 0x00, 0x6c, 0x4c, 0x28, 0x00, 0x00, 0xad, 0x29, 0x01, 0x03, 0x00, 0xca, 0x2b,
0x02, 0x06, 0xa4, 0x00, 0xa0, 0x00, 0x76, 0x13, 0x63, 0x87, 0x64, 0x83, 0x65, 0x88, 0x6c, 0x8c,
0x6e, 0xa4, 0x72, 0xa9, 0x73, 0xa8, 0x74, 0x9f, 0x7a, 0x91, 0x43, 0x80, 0x44, 0x85, 0x45, 0x89,
0x4c, 0x9c, 0x4e, 0xa5, 0x52, 0x9e, 0x53, 0x9b, 0x54, 0x86, 0x5a, 0x92, 0x20, 0x76, 0x5e, 0x03,
0x6f, 0x93, 0x4f, 0xa7, 0x20, 0x5e, 0xf8, 0x03, 0x75, 0x96, 0x55, 0xa6, 0x20, 0xf8, 0x27, 0x11,
0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6c, 0x8d, 0x6f, 0xa2, 0x72, 0xaa, 0x75, 0xa3, 0x79, 0x98,
0x41, 0x8f, 0x45, 0x90, 0x49, 0x8b, 0x4c, 0x8a, 0x4f, 0x95, 0x52, 0xab, 0x55, 0x97, 0x59, 0x9d,
0x20, 0x27, 0x22, 0x07, 0x61, 0x84, 0x6f, 0x94, 0x75, 0x81, 0x41, 0x8e, 0x4f, 0x99, 0x55, 0x9a,
0x20, 0x22, 0x00, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4,
0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88,
0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea,
0x20, 0x5e, 0xf8, 0x03, 0x61, 0x86, 0x41, 0x8f, 0x20, 0xf8, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a,
0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb,
0x20, 0x60, 0x27, 0x0d, 0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec,
0x41, 0xb5, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c,
0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3,
0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0xf7, 0x03, 0x63, 0x87, 0x43, 0x80, 0x20, 0xf7,
0x00  };

// Spain
Bit8u layout_SP[471] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x1d, 0x00, 0x00, 0x53, 0x50, 0x2c, 0x00, 0x00, 0x45, 0x53, 0x2c,
0xac, 0x00, 0x53, 0x50, 0x2c, 0xac, 0x00, 0x45, 0x53, 0x2c, 0xad, 0x00, 0x53, 0x50, 0x2c, 0xad,
0x00, 0x45, 0x53, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a,
0x03, 0x30, 0x01, 0x3d, 0x01, 0x00, 0x00, 0x52, 0x03, 0x00, 0x00, 0x3d, 0x01, 0x00, 0x00, 0xb5,
0x01, 0x00, 0x00, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x7c, 0x03, 0x02, 0x01,
0x00, 0x22, 0x40, 0x04, 0x02, 0x01, 0x00, 0xfa, 0x23, 0x05, 0x02, 0x07, 0x00, 0x00, 0xc9, 0x07,
0x02, 0x01, 0x00, 0x26, 0xaa, 0x08, 0x01, 0x01, 0x00, 0x2f, 0x09, 0x01, 0x01, 0x00, 0x28, 0x0a,
0x01, 0x01, 0x00, 0x29, 0x0b, 0x01, 0x01, 0x00, 0x3d, 0x0c, 0x01, 0x00, 0x27, 0x3f, 0x0d, 0x01,
0x00, 0xad, 0xa8, 0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x41, 0x00, 0x79, 0x59, 0x16, 0x41, 0x00,
0x75, 0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1a, 0x02, 0x03, 0xc8,
0xca, 0x5b, 0x1b, 0x02, 0x00, 0x2b, 0x2a, 0x5d, 0x1e, 0x41, 0x00, 0x61, 0x41, 0x27, 0x42, 0x00,
0xa4, 0xa5, 0x7e, 0x28, 0x02, 0x03, 0xcb, 0xcc, 0x7b, 0x29, 0x03, 0x00, 0xa7, 0xa6, 0x5c, 0x1c,
0x2b, 0x42, 0x00, 0x87, 0x80, 0x7d, 0x31, 0x41, 0x00, 0x6e, 0x4e, 0x33, 0x02, 0x01, 0x00, 0x3b,
0x3c, 0x34, 0x02, 0x01, 0x00, 0x3a, 0x3e, 0x35, 0x03, 0x00, 0x2d, 0x5f, 0x5c, 0x1f, 0x39, 0x00,
0x00, 0x20, 0x56, 0x01, 0x00, 0x3c, 0x3e, 0x00, 0x60, 0x06, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d,
0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x7e, 0x03, 0x6e, 0xa4, 0x4e, 0xa5, 0x20, 0x7e, 0x5e, 0x06,
0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x20, 0x5e, 0x27, 0x07, 0x61, 0xa0,
0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x45, 0x90, 0x20, 0x27, 0x22, 0x0a, 0x61, 0x84,
0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x4f, 0x99, 0x55, 0x9a,
0x20, 0x22, 0x00, 0x06, 0x02, 0x03, 0x00, 0x00, 0xd5, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x00,
0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7, 0x45, 0xd4,
0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4, 0x6f, 0xe4,
0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c,
0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea, 0x20, 0x5e,
0xef, 0x0d, 0x61, 0xa0, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5,
0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c, 0x61, 0x84,
0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8,
0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0x00  };

// Finland
Bit8u layout_SU[683] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x1d, 0x00, 0x00, 0x53, 0x55, 0x2c, 0x00, 0x00, 0x53, 0x56, 0x2c,
0x00, 0x00, 0x46, 0x49, 0x2c, 0x99, 0x00, 0x53, 0x55, 0x2c, 0x99, 0x00, 0x53, 0x56, 0x2c, 0x99,
0x00, 0x46, 0x49, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a,
0x03, 0x55, 0x01, 0x62, 0x01, 0x00, 0x00, 0x5b, 0x03, 0xdd, 0x01, 0xff, 0x01, 0x00, 0x00, 0x52,
0x03, 0x00, 0x00, 0x62, 0x01, 0x00, 0x00, 0xb5, 0x01, 0xfc, 0x00, 0x06, 0x01, 0x00, 0x00, 0x00,
0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
0x02, 0x01, 0x00, 0x22, 0x40, 0x04, 0x02, 0x03, 0x00, 0x00, 0x9c, 0x05, 0x02, 0x01, 0x00, 0xcf,
0x24, 0x07, 0x01, 0x01, 0x00, 0x26, 0x08, 0x02, 0x01, 0x00, 0x2f, 0x7b, 0x09, 0x03, 0x01, 0x00,
0x28, 0x5b, 0x1b, 0x0a, 0x03, 0x01, 0x00, 0x29, 0x5d, 0x1d, 0x0b, 0x02, 0x01, 0x00, 0x3d, 0x7d,
0x0c, 0x03, 0x00, 0x2b, 0x3f, 0x5c, 0x1c, 0x0d, 0x02, 0x03, 0xcb, 0xc8, 0x7c, 0x10, 0x42, 0x03,
0x00, 0x00, 0x40, 0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x41, 0x00, 0x79, 0x59, 0x16, 0x41, 0x00,
0x75, 0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1a, 0x41, 0x00, 0x86,
0x8f, 0x1b, 0x03, 0x07, 0xcc, 0xca, 0xc9, 0x1e, 0x1e, 0x41, 0x00, 0x61, 0x41, 0x27, 0x41, 0x00,
0x94, 0x99, 0x28, 0x41, 0x00, 0x84, 0x8e, 0x29, 0x01, 0x00, 0xf5, 0xab, 0x2b, 0x01, 0x00, 0x27,
0x2a, 0x2e, 0x41, 0x00, 0x63, 0x43, 0x31, 0x41, 0x00, 0x6e, 0x4e, 0x32, 0x42, 0x03, 0x00, 0x00,
0xe6, 0x33, 0x02, 0x01, 0x00, 0x3b, 0x3c, 0x34, 0x02, 0x01, 0x00, 0x3a, 0x3e, 0x35, 0x03, 0x04,
0x2d, 0x5f, 0x00, 0x1f, 0x39, 0x00, 0x00, 0x20, 0x56, 0x02, 0x00, 0x3c, 0x3e, 0x7c, 0x00, 0x05,
0x01, 0x03, 0x00, 0xa0, 0x29, 0x00, 0x00, 0x15, 0x00, 0x60, 0x06, 0x61, 0x85, 0x65, 0x8a, 0x69,
0x8d, 0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x7e, 0x03, 0x6e, 0xa4, 0x4e, 0xa5, 0x20, 0x7e, 0x5e,
0x06, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x20, 0x5e, 0x27, 0x09, 0x61,
0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x43, 0x80, 0x45, 0x90, 0x20,
0x27, 0x22, 0x0a, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41,
0x8e, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0x00, 0x06, 0x02, 0x03, 0x00, 0x00, 0xd5, 0x12, 0x42,
0x03, 0x00, 0x00, 0xd5, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75,
0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x7e, 0x07, 0x61,
0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61,
0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f,
0xe2, 0x55, 0xea, 0x20, 0x5e, 0xef, 0x0f, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1, 0x6f,
0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5, 0x43, 0x80, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55,
0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75,
0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0x00,
0x06, 0x02, 0x03, 0x00, 0x00, 0xd5, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x1f, 0x41, 0x00, 0x73,
0x53, 0x28, 0x42, 0x07, 0x00, 0x00, 0xcd, 0x29, 0x01, 0x03, 0x00, 0xa0, 0x2c, 0x41, 0x00, 0x7a,
0x5a, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7,
0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4,
0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88,
0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea,
0x20, 0x5e, 0x27, 0x0f, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3,
0x79, 0xec, 0x41, 0xb5, 0x43, 0x80, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed,
0x20, 0x27, 0x22, 0x0d, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98,
0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x59, 0xf3, 0x20, 0x22, 0x76, 0x05,
0x73, 0xf9, 0x7a, 0xf7, 0x53, 0xdd, 0x5a, 0xef, 0x20, 0x76, 0x00  };

// Sweden
Bit8u layout_SV[683] = {
0x4b, 0x4c, 0x46, 0x00, 0x01, 0x1d, 0x00, 0x00, 0x53, 0x55, 0x2c, 0x00, 0x00, 0x53, 0x56, 0x2c,
0x00, 0x00, 0x46, 0x49, 0x2c, 0x99, 0x00, 0x53, 0x55, 0x2c, 0x99, 0x00, 0x53, 0x56, 0x2c, 0x99,
0x00, 0x46, 0x49, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a,
0x03, 0x55, 0x01, 0x62, 0x01, 0x00, 0x00, 0x5b, 0x03, 0xdd, 0x01, 0xff, 0x01, 0x00, 0x00, 0x52,
0x03, 0x00, 0x00, 0x62, 0x01, 0x00, 0x00, 0xb5, 0x01, 0xfc, 0x00, 0x06, 0x01, 0x00, 0x00, 0x00,
0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
0x02, 0x01, 0x00, 0x22, 0x40, 0x04, 0x02, 0x03, 0x00, 0x00, 0x9c, 0x05, 0x02, 0x01, 0x00, 0xcf,
0x24, 0x07, 0x01, 0x01, 0x00, 0x26, 0x08, 0x02, 0x01, 0x00, 0x2f, 0x7b, 0x09, 0x03, 0x01, 0x00,
0x28, 0x5b, 0x1b, 0x0a, 0x03, 0x01, 0x00, 0x29, 0x5d, 0x1d, 0x0b, 0x02, 0x01, 0x00, 0x3d, 0x7d,
0x0c, 0x03, 0x00, 0x2b, 0x3f, 0x5c, 0x1c, 0x0d, 0x02, 0x03, 0xcb, 0xc8, 0x7c, 0x10, 0x42, 0x03,
0x00, 0x00, 0x40, 0x12, 0x41, 0x00, 0x65, 0x45, 0x15, 0x41, 0x00, 0x79, 0x59, 0x16, 0x41, 0x00,
0x75, 0x55, 0x17, 0x41, 0x00, 0x69, 0x49, 0x18, 0x41, 0x00, 0x6f, 0x4f, 0x1a, 0x41, 0x00, 0x86,
0x8f, 0x1b, 0x03, 0x07, 0xcc, 0xca, 0xc9, 0x1e, 0x1e, 0x41, 0x00, 0x61, 0x41, 0x27, 0x41, 0x00,
0x94, 0x99, 0x28, 0x41, 0x00, 0x84, 0x8e, 0x29, 0x01, 0x00, 0xf5, 0xab, 0x2b, 0x01, 0x00, 0x27,
0x2a, 0x2e, 0x41, 0x00, 0x63, 0x43, 0x31, 0x41, 0x00, 0x6e, 0x4e, 0x32, 0x42, 0x03, 0x00, 0x00,
0xe6, 0x33, 0x02, 0x01, 0x00, 0x3b, 0x3c, 0x34, 0x02, 0x01, 0x00, 0x3a, 0x3e, 0x35, 0x03, 0x04,
0x2d, 0x5f, 0x00, 0x1f, 0x39, 0x00, 0x00, 0x20, 0x56, 0x02, 0x00, 0x3c, 0x3e, 0x7c, 0x00, 0x05,
0x01, 0x03, 0x00, 0xa0, 0x29, 0x00, 0x00, 0x15, 0x00, 0x60, 0x06, 0x61, 0x85, 0x65, 0x8a, 0x69,
0x8d, 0x6f, 0x95, 0x75, 0x97, 0x20, 0x60, 0x7e, 0x03, 0x6e, 0xa4, 0x4e, 0xa5, 0x20, 0x7e, 0x5e,
0x06, 0x61, 0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x20, 0x5e, 0x27, 0x09, 0x61,
0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3, 0x43, 0x80, 0x45, 0x90, 0x20,
0x27, 0x22, 0x0a, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98, 0x41,
0x8e, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0x22, 0x00, 0x06, 0x02, 0x03, 0x00, 0x00, 0xd5, 0x12, 0x42,
0x03, 0x00, 0x00, 0xd5, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75,
0x97, 0x41, 0xb7, 0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x7e, 0x07, 0x61,
0xc6, 0x6e, 0xa4, 0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61,
0x83, 0x65, 0x88, 0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f,
0xe2, 0x55, 0xea, 0x20, 0x5e, 0xef, 0x0f, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1, 0x6f,
0xa2, 0x75, 0xa3, 0x79, 0xec, 0x41, 0xb5, 0x43, 0x80, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55,
0xe9, 0x59, 0xed, 0x20, 0xef, 0xf9, 0x0c, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75,
0x81, 0x79, 0x98, 0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x20, 0xf9, 0x00,
0x06, 0x02, 0x03, 0x00, 0x00, 0xd5, 0x12, 0x42, 0x03, 0x00, 0x00, 0xd5, 0x1f, 0x41, 0x00, 0x73,
0x53, 0x28, 0x42, 0x07, 0x00, 0x00, 0xcd, 0x29, 0x01, 0x03, 0x00, 0xa0, 0x2c, 0x41, 0x00, 0x7a,
0x5a, 0x00, 0x60, 0x0b, 0x61, 0x85, 0x65, 0x8a, 0x69, 0x8d, 0x6f, 0x95, 0x75, 0x97, 0x41, 0xb7,
0x45, 0xd4, 0x49, 0xde, 0x4f, 0xe3, 0x55, 0xeb, 0x20, 0x60, 0x7e, 0x07, 0x61, 0xc6, 0x6e, 0xa4,
0x6f, 0xe4, 0x41, 0xc7, 0x4e, 0xa5, 0x4f, 0xe5, 0x20, 0x7e, 0x5e, 0x0b, 0x61, 0x83, 0x65, 0x88,
0x69, 0x8c, 0x6f, 0x93, 0x75, 0x96, 0x41, 0xb6, 0x45, 0xd2, 0x49, 0xd7, 0x4f, 0xe2, 0x55, 0xea,
0x20, 0x5e, 0x27, 0x0f, 0x61, 0xa0, 0x63, 0x87, 0x65, 0x82, 0x69, 0xa1, 0x6f, 0xa2, 0x75, 0xa3,
0x79, 0xec, 0x41, 0xb5, 0x43, 0x80, 0x45, 0x90, 0x49, 0xd6, 0x4f, 0xe0, 0x55, 0xe9, 0x59, 0xed,
0x20, 0x27, 0x22, 0x0d, 0x61, 0x84, 0x65, 0x89, 0x69, 0x8b, 0x6f, 0x94, 0x75, 0x81, 0x79, 0x98,
0x41, 0x8e, 0x45, 0xd3, 0x49, 0xd8, 0x4f, 0x99, 0x55, 0x9a, 0x59, 0xf3, 0x20, 0x22, 0x76, 0x05,
0x73, 0xf9, 0x7a, 0xf7, 0x53, 0xdd, 0x5a, 0xef, 0x20, 0x76, 0x00 };
