// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/advisorynotifications/v1/service.proto

#include "google/cloud/advisorynotifications/v1/internal/advisory_notifications_auth_decorator.h"
#include <google/cloud/advisorynotifications/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace advisorynotifications_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AdvisoryNotificationsServiceAuth::AdvisoryNotificationsServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<AdvisoryNotificationsServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::advisorynotifications::v1::ListNotificationsResponse>
AdvisoryNotificationsServiceAuth::ListNotifications(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::ListNotificationsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListNotifications(context, request);
}

StatusOr<google::cloud::advisorynotifications::v1::Notification>
AdvisoryNotificationsServiceAuth::GetNotification(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::GetNotificationRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetNotification(context, request);
}

StatusOr<google::cloud::advisorynotifications::v1::Settings>
AdvisoryNotificationsServiceAuth::GetSettings(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::GetSettingsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetSettings(context, request);
}

StatusOr<google::cloud::advisorynotifications::v1::Settings>
AdvisoryNotificationsServiceAuth::UpdateSettings(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::UpdateSettingsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateSettings(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace advisorynotifications_v1_internal
}  // namespace cloud
}  // namespace google
