// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#include "google/cloud/asset/v1/internal/asset_auth_decorator.h"
#include <google/cloud/asset/v1/asset_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace asset_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AssetServiceAuth::AssetServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<AssetServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

future<StatusOr<google::longrunning::Operation>>
AssetServiceAuth::AsyncExportAssets(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::asset::v1::ExportAssetsRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncExportAssets(cq, *std::move(context), options,
                                        request);
      });
}

StatusOr<google::cloud::asset::v1::ListAssetsResponse>
AssetServiceAuth::ListAssets(
    grpc::ClientContext& context,
    google::cloud::asset::v1::ListAssetsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListAssets(context, request);
}

StatusOr<google::cloud::asset::v1::BatchGetAssetsHistoryResponse>
AssetServiceAuth::BatchGetAssetsHistory(
    grpc::ClientContext& context,
    google::cloud::asset::v1::BatchGetAssetsHistoryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BatchGetAssetsHistory(context, request);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceAuth::CreateFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::CreateFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateFeed(context, request);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceAuth::GetFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::GetFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetFeed(context, request);
}

StatusOr<google::cloud::asset::v1::ListFeedsResponse>
AssetServiceAuth::ListFeeds(
    grpc::ClientContext& context,
    google::cloud::asset::v1::ListFeedsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListFeeds(context, request);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceAuth::UpdateFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::UpdateFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateFeed(context, request);
}

Status AssetServiceAuth::DeleteFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::DeleteFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteFeed(context, request);
}

StatusOr<google::cloud::asset::v1::SearchAllResourcesResponse>
AssetServiceAuth::SearchAllResources(
    grpc::ClientContext& context,
    google::cloud::asset::v1::SearchAllResourcesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchAllResources(context, request);
}

StatusOr<google::cloud::asset::v1::SearchAllIamPoliciesResponse>
AssetServiceAuth::SearchAllIamPolicies(
    grpc::ClientContext& context,
    google::cloud::asset::v1::SearchAllIamPoliciesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchAllIamPolicies(context, request);
}

StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyResponse>
AssetServiceAuth::AnalyzeIamPolicy(
    grpc::ClientContext& context,
    google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeIamPolicy(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AssetServiceAuth::AsyncAnalyzeIamPolicyLongrunning(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncAnalyzeIamPolicyLongrunning(cq, *std::move(context),
                                                       options, request);
      });
}

StatusOr<google::cloud::asset::v1::AnalyzeMoveResponse>
AssetServiceAuth::AnalyzeMove(
    grpc::ClientContext& context,
    google::cloud::asset::v1::AnalyzeMoveRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeMove(context, request);
}

StatusOr<google::cloud::asset::v1::QueryAssetsResponse>
AssetServiceAuth::QueryAssets(
    grpc::ClientContext& context,
    google::cloud::asset::v1::QueryAssetsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->QueryAssets(context, request);
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceAuth::CreateSavedQuery(
    grpc::ClientContext& context,
    google::cloud::asset::v1::CreateSavedQueryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateSavedQuery(context, request);
}

StatusOr<google::cloud::asset::v1::SavedQuery> AssetServiceAuth::GetSavedQuery(
    grpc::ClientContext& context,
    google::cloud::asset::v1::GetSavedQueryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetSavedQuery(context, request);
}

StatusOr<google::cloud::asset::v1::ListSavedQueriesResponse>
AssetServiceAuth::ListSavedQueries(
    grpc::ClientContext& context,
    google::cloud::asset::v1::ListSavedQueriesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListSavedQueries(context, request);
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceAuth::UpdateSavedQuery(
    grpc::ClientContext& context,
    google::cloud::asset::v1::UpdateSavedQueryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateSavedQuery(context, request);
}

Status AssetServiceAuth::DeleteSavedQuery(
    grpc::ClientContext& context,
    google::cloud::asset::v1::DeleteSavedQueryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteSavedQuery(context, request);
}

StatusOr<google::cloud::asset::v1::BatchGetEffectiveIamPoliciesResponse>
AssetServiceAuth::BatchGetEffectiveIamPolicies(
    grpc::ClientContext& context,
    google::cloud::asset::v1::BatchGetEffectiveIamPoliciesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BatchGetEffectiveIamPolicies(context, request);
}

StatusOr<google::cloud::asset::v1::AnalyzeOrgPoliciesResponse>
AssetServiceAuth::AnalyzeOrgPolicies(
    grpc::ClientContext& context,
    google::cloud::asset::v1::AnalyzeOrgPoliciesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeOrgPolicies(context, request);
}

StatusOr<google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersResponse>
AssetServiceAuth::AnalyzeOrgPolicyGovernedContainers(
    grpc::ClientContext& context,
    google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeOrgPolicyGovernedContainers(context, request);
}

StatusOr<google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsResponse>
AssetServiceAuth::AnalyzeOrgPolicyGovernedAssets(
    grpc::ClientContext& context,
    google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeOrgPolicyGovernedAssets(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AssetServiceAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context), options,
                                        request);
      });
}

future<Status> AssetServiceAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options,
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context), options,
                                           request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset_v1_internal
}  // namespace cloud
}  // namespace google
