// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/storage/v1/storage.proto

#include "google/cloud/bigquery/storage/v1/bigquery_read_connection.h"
#include "google/cloud/bigquery/storage/v1/bigquery_read_options.h"
#include "google/cloud/bigquery/storage/v1/internal/bigquery_read_connection_impl.h"
#include "google/cloud/bigquery/storage/v1/internal/bigquery_read_option_defaults.h"
#include "google/cloud/bigquery/storage/v1/internal/bigquery_read_stub_factory.h"
#include "google/cloud/bigquery/storage/v1/internal/bigquery_read_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_storage_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BigQueryReadConnection::~BigQueryReadConnection() = default;

StatusOr<google::cloud::bigquery::storage::v1::ReadSession>
BigQueryReadConnection::CreateReadSession(
    google::cloud::bigquery::storage::v1::CreateReadSessionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::storage::v1::ReadRowsResponse>
BigQueryReadConnection::ReadRows(
    google::cloud::bigquery::storage::v1::ReadRowsRequest const&) {
  return google::cloud::internal::MakeStreamRange<
      google::cloud::bigquery::storage::v1::ReadRowsResponse>(
      []() -> absl::variant<
               Status, google::cloud::bigquery::storage::v1::ReadRowsResponse> {
        return Status(StatusCode::kUnimplemented, "not implemented");
      });
}

StatusOr<google::cloud::bigquery::storage::v1::SplitReadStreamResponse>
BigQueryReadConnection::SplitReadStream(
    google::cloud::bigquery::storage::v1::SplitReadStreamRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<BigQueryReadConnection> MakeBigQueryReadConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 BigQueryReadPolicyOptionList>(options,
                                                               __func__);
  options = bigquery_storage_v1_internal::BigQueryReadDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = bigquery_storage_v1_internal::CreateDefaultBigQueryReadStub(
      background->cq(), options);
  return bigquery_storage_v1_internal::MakeBigQueryReadTracingConnection(
      std::make_shared<
          bigquery_storage_v1_internal::BigQueryReadConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_storage_v1
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace bigquery {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

void BigQueryReadReadRowsStreamingUpdater(
    google::cloud::bigquery::storage::v1::ReadRowsResponse const& response,
    google::cloud::bigquery::storage::v1::ReadRowsRequest& request) {
  return bigquery_storage_v1_internal::BigQueryReadReadRowsStreamingUpdater(
      response, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery
}  // namespace cloud
}  // namespace google
