// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#include "google/cloud/binaryauthorization/v1/binauthz_management_service_v1_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BinauthzManagementServiceV1ConnectionIdempotencyPolicy::
    ~BinauthzManagementServiceV1ConnectionIdempotencyPolicy() = default;

std::unique_ptr<BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
BinauthzManagementServiceV1ConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<
      BinauthzManagementServiceV1ConnectionIdempotencyPolicy>(*this);
}

Idempotency BinauthzManagementServiceV1ConnectionIdempotencyPolicy::GetPolicy(
    google::cloud::binaryauthorization::v1::GetPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
BinauthzManagementServiceV1ConnectionIdempotencyPolicy::UpdatePolicy(
    google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
BinauthzManagementServiceV1ConnectionIdempotencyPolicy::CreateAttestor(
    google::cloud::binaryauthorization::v1::CreateAttestorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BinauthzManagementServiceV1ConnectionIdempotencyPolicy::GetAttestor(
    google::cloud::binaryauthorization::v1::GetAttestorRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
BinauthzManagementServiceV1ConnectionIdempotencyPolicy::UpdateAttestor(
    google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
BinauthzManagementServiceV1ConnectionIdempotencyPolicy::ListAttestors(
    google::cloud::binaryauthorization::v1::ListAttestorsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
BinauthzManagementServiceV1ConnectionIdempotencyPolicy::DeleteAttestor(
    google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
MakeDefaultBinauthzManagementServiceV1ConnectionIdempotencyPolicy() {
  return std::make_unique<
      BinauthzManagementServiceV1ConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization_v1
}  // namespace cloud
}  // namespace google
