// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#include "google/cloud/binaryauthorization/v1/internal/binauthz_management_service_v1_connection_impl.h"
#include "google/cloud/binaryauthorization/v1/internal/binauthz_management_service_v1_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<binaryauthorization_v1::BinauthzManagementServiceV1RetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<binaryauthorization_v1::
               BinauthzManagementServiceV1RetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<binaryauthorization_v1::
               BinauthzManagementServiceV1BackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<binaryauthorization_v1::
                    BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<binaryauthorization_v1::
               BinauthzManagementServiceV1ConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

BinauthzManagementServiceV1ConnectionImpl::
    BinauthzManagementServiceV1ConnectionImpl(
        std::unique_ptr<google::cloud::BackgroundThreads> background,
        std::shared_ptr<
            binaryauthorization_v1_internal::BinauthzManagementServiceV1Stub>
            stub,
        Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          BinauthzManagementServiceV1Connection::options())) {}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1ConnectionImpl::GetPolicy(
    google::cloud::binaryauthorization::v1::GetPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPolicy(request),
      [this](grpc::ClientContext& context,
             google::cloud::binaryauthorization::v1::GetPolicyRequest const&
                 request) { return stub_->GetPolicy(context, request); },
      request, __func__);
}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1ConnectionImpl::UpdatePolicy(
    google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePolicy(request),
      [this](grpc::ClientContext& context,
             google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&
                 request) { return stub_->UpdatePolicy(context, request); },
      request, __func__);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1ConnectionImpl::CreateAttestor(
    google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAttestor(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
              request) { return stub_->CreateAttestor(context, request); },
      request, __func__);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1ConnectionImpl::GetAttestor(
    google::cloud::binaryauthorization::v1::GetAttestorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAttestor(request),
      [this](grpc::ClientContext& context,
             google::cloud::binaryauthorization::v1::GetAttestorRequest const&
                 request) { return stub_->GetAttestor(context, request); },
      request, __func__);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1ConnectionImpl::UpdateAttestor(
    google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAttestor(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
              request) { return stub_->UpdateAttestor(context, request); },
      request, __func__);
}

StreamRange<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1ConnectionImpl::ListAttestors(
    google::cloud::binaryauthorization::v1::ListAttestorsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAttestors(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::binaryauthorization::v1::Attestor>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           binaryauthorization_v1::BinauthzManagementServiceV1RetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::binaryauthorization::v1::ListAttestorsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::binaryauthorization::v1::
                       ListAttestorsRequest const& request) {
              return stub->ListAttestors(context, request);
            },
            r, function_name);
      },
      [](google::cloud::binaryauthorization::v1::ListAttestorsResponse r) {
        std::vector<google::cloud::binaryauthorization::v1::Attestor> result(
            r.attestors().size());
        auto& messages = *r.mutable_attestors();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status BinauthzManagementServiceV1ConnectionImpl::DeleteAttestor(
    google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAttestor(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
              request) { return stub_->DeleteAttestor(context, request); },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization_v1_internal
}  // namespace cloud
}  // namespace google
