// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#include "google/cloud/binaryauthorization/v1/internal/binauthz_management_service_v1_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BinauthzManagementServiceV1TracingConnection::
    BinauthzManagementServiceV1TracingConnection(
        std::shared_ptr<
            binaryauthorization_v1::BinauthzManagementServiceV1Connection>
            child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1TracingConnection::GetPolicy(
    google::cloud::binaryauthorization::v1::GetPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "binaryauthorization_v1::BinauthzManagementServiceV1Connection::"
      "GetPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPolicy(request));
}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1TracingConnection::UpdatePolicy(
    google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "binaryauthorization_v1::BinauthzManagementServiceV1Connection::"
      "UpdatePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdatePolicy(request));
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1TracingConnection::CreateAttestor(
    google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "binaryauthorization_v1::BinauthzManagementServiceV1Connection::"
      "CreateAttestor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateAttestor(request));
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1TracingConnection::GetAttestor(
    google::cloud::binaryauthorization::v1::GetAttestorRequest const& request) {
  auto span = internal::MakeSpan(
      "binaryauthorization_v1::BinauthzManagementServiceV1Connection::"
      "GetAttestor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAttestor(request));
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1TracingConnection::UpdateAttestor(
    google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "binaryauthorization_v1::BinauthzManagementServiceV1Connection::"
      "UpdateAttestor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateAttestor(request));
}

StreamRange<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1TracingConnection::ListAttestors(
    google::cloud::binaryauthorization::v1::ListAttestorsRequest request) {
  auto span = internal::MakeSpan(
      "binaryauthorization_v1::BinauthzManagementServiceV1Connection::"
      "ListAttestors");
  internal::OTelScope scope(span);
  auto sr = child_->ListAttestors(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::binaryauthorization::v1::Attestor>(std::move(span),
                                                        std::move(sr));
}

Status BinauthzManagementServiceV1TracingConnection::DeleteAttestor(
    google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "binaryauthorization_v1::BinauthzManagementServiceV1Connection::"
      "DeleteAttestor");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteAttestor(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<binaryauthorization_v1::BinauthzManagementServiceV1Connection>
MakeBinauthzManagementServiceV1TracingConnection(
    std::shared_ptr<
        binaryauthorization_v1::BinauthzManagementServiceV1Connection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<BinauthzManagementServiceV1TracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization_v1_internal
}  // namespace cloud
}  // namespace google
