// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/channel/v1/service.proto

#include "google/cloud/channel/v1/internal/cloud_channel_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace channel_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudChannelServiceTracingConnection::CloudChannelServiceTracingConnection(
    std::shared_ptr<channel_v1::CloudChannelServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::channel::v1::Customer>
CloudChannelServiceTracingConnection::ListCustomers(
    google::cloud::channel::v1::ListCustomersRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListCustomers");
  internal::OTelScope scope(span);
  auto sr = child_->ListCustomers(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::channel::v1::Customer>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceTracingConnection::GetCustomer(
    google::cloud::channel::v1::GetCustomerRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::GetCustomer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCustomer(request));
}

StatusOr<google::cloud::channel::v1::CheckCloudIdentityAccountsExistResponse>
CloudChannelServiceTracingConnection::CheckCloudIdentityAccountsExist(
    google::cloud::channel::v1::CheckCloudIdentityAccountsExistRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "CheckCloudIdentityAccountsExist");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->CheckCloudIdentityAccountsExist(request));
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceTracingConnection::CreateCustomer(
    google::cloud::channel::v1::CreateCustomerRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::CreateCustomer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateCustomer(request));
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceTracingConnection::UpdateCustomer(
    google::cloud::channel::v1::UpdateCustomerRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::UpdateCustomer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateCustomer(request));
}

Status CloudChannelServiceTracingConnection::DeleteCustomer(
    google::cloud::channel::v1::DeleteCustomerRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::DeleteCustomer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteCustomer(request));
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceTracingConnection::ImportCustomer(
    google::cloud::channel::v1::ImportCustomerRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ImportCustomer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ImportCustomer(request));
}

future<StatusOr<google::cloud::channel::v1::Customer>>
CloudChannelServiceTracingConnection::ProvisionCloudIdentity(
    google::cloud::channel::v1::ProvisionCloudIdentityRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ProvisionCloudIdentity");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ProvisionCloudIdentity(request));
}

StreamRange<google::cloud::channel::v1::Entitlement>
CloudChannelServiceTracingConnection::ListEntitlements(
    google::cloud::channel::v1::ListEntitlementsRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListEntitlements");
  internal::OTelScope scope(span);
  auto sr = child_->ListEntitlements(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::Entitlement>(std::move(span), std::move(sr));
}

StreamRange<google::cloud::channel::v1::TransferableSku>
CloudChannelServiceTracingConnection::ListTransferableSkus(
    google::cloud::channel::v1::ListTransferableSkusRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListTransferableSkus");
  internal::OTelScope scope(span);
  auto sr = child_->ListTransferableSkus(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::TransferableSku>(std::move(span),
                                                   std::move(sr));
}

StreamRange<google::cloud::channel::v1::TransferableOffer>
CloudChannelServiceTracingConnection::ListTransferableOffers(
    google::cloud::channel::v1::ListTransferableOffersRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListTransferableOffers");
  internal::OTelScope scope(span);
  auto sr = child_->ListTransferableOffers(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::TransferableOffer>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::channel::v1::Entitlement>
CloudChannelServiceTracingConnection::GetEntitlement(
    google::cloud::channel::v1::GetEntitlementRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::GetEntitlement");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEntitlement(request));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceTracingConnection::CreateEntitlement(
    google::cloud::channel::v1::CreateEntitlementRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::CreateEntitlement");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEntitlement(request));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceTracingConnection::ChangeParameters(
    google::cloud::channel::v1::ChangeParametersRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ChangeParameters");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ChangeParameters(request));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceTracingConnection::ChangeRenewalSettings(
    google::cloud::channel::v1::ChangeRenewalSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ChangeRenewalSettings");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ChangeRenewalSettings(request));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceTracingConnection::ChangeOffer(
    google::cloud::channel::v1::ChangeOfferRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ChangeOffer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ChangeOffer(request));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceTracingConnection::StartPaidService(
    google::cloud::channel::v1::StartPaidServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::StartPaidService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StartPaidService(request));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceTracingConnection::SuspendEntitlement(
    google::cloud::channel::v1::SuspendEntitlementRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::SuspendEntitlement");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SuspendEntitlement(request));
}

future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
CloudChannelServiceTracingConnection::CancelEntitlement(
    google::cloud::channel::v1::CancelEntitlementRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::CancelEntitlement");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CancelEntitlement(request));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceTracingConnection::ActivateEntitlement(
    google::cloud::channel::v1::ActivateEntitlementRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ActivateEntitlement");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ActivateEntitlement(request));
}

future<StatusOr<google::cloud::channel::v1::TransferEntitlementsResponse>>
CloudChannelServiceTracingConnection::TransferEntitlements(
    google::cloud::channel::v1::TransferEntitlementsRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::TransferEntitlements");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->TransferEntitlements(request));
}

future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
CloudChannelServiceTracingConnection::TransferEntitlementsToGoogle(
    google::cloud::channel::v1::TransferEntitlementsToGoogleRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "TransferEntitlementsToGoogle");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->TransferEntitlementsToGoogle(request));
}

StreamRange<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceTracingConnection::ListChannelPartnerLinks(
    google::cloud::channel::v1::ListChannelPartnerLinksRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListChannelPartnerLinks");
  internal::OTelScope scope(span);
  auto sr = child_->ListChannelPartnerLinks(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::ChannelPartnerLink>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceTracingConnection::GetChannelPartnerLink(
    google::cloud::channel::v1::GetChannelPartnerLinkRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::GetChannelPartnerLink");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetChannelPartnerLink(request));
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceTracingConnection::CreateChannelPartnerLink(
    google::cloud::channel::v1::CreateChannelPartnerLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::CreateChannelPartnerLink");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateChannelPartnerLink(request));
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceTracingConnection::UpdateChannelPartnerLink(
    google::cloud::channel::v1::UpdateChannelPartnerLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::UpdateChannelPartnerLink");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateChannelPartnerLink(request));
}

StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
CloudChannelServiceTracingConnection::GetCustomerRepricingConfig(
    google::cloud::channel::v1::GetCustomerRepricingConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::GetCustomerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCustomerRepricingConfig(request));
}

StreamRange<google::cloud::channel::v1::CustomerRepricingConfig>
CloudChannelServiceTracingConnection::ListCustomerRepricingConfigs(
    google::cloud::channel::v1::ListCustomerRepricingConfigsRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "ListCustomerRepricingConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListCustomerRepricingConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::CustomerRepricingConfig>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
CloudChannelServiceTracingConnection::CreateCustomerRepricingConfig(
    google::cloud::channel::v1::CreateCustomerRepricingConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "CreateCustomerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->CreateCustomerRepricingConfig(request));
}

StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
CloudChannelServiceTracingConnection::UpdateCustomerRepricingConfig(
    google::cloud::channel::v1::UpdateCustomerRepricingConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "UpdateCustomerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateCustomerRepricingConfig(request));
}

Status CloudChannelServiceTracingConnection::DeleteCustomerRepricingConfig(
    google::cloud::channel::v1::DeleteCustomerRepricingConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "DeleteCustomerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteCustomerRepricingConfig(request));
}

StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
CloudChannelServiceTracingConnection::GetChannelPartnerRepricingConfig(
    google::cloud::channel::v1::GetChannelPartnerRepricingConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "GetChannelPartnerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->GetChannelPartnerRepricingConfig(request));
}

StreamRange<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
CloudChannelServiceTracingConnection::ListChannelPartnerRepricingConfigs(
    google::cloud::channel::v1::ListChannelPartnerRepricingConfigsRequest
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "ListChannelPartnerRepricingConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListChannelPartnerRepricingConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::ChannelPartnerRepricingConfig>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
CloudChannelServiceTracingConnection::CreateChannelPartnerRepricingConfig(
    google::cloud::channel::v1::
        CreateChannelPartnerRepricingConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "CreateChannelPartnerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->CreateChannelPartnerRepricingConfig(request));
}

StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
CloudChannelServiceTracingConnection::UpdateChannelPartnerRepricingConfig(
    google::cloud::channel::v1::
        UpdateChannelPartnerRepricingConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "UpdateChannelPartnerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->UpdateChannelPartnerRepricingConfig(request));
}

Status
CloudChannelServiceTracingConnection::DeleteChannelPartnerRepricingConfig(
    google::cloud::channel::v1::
        DeleteChannelPartnerRepricingConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "DeleteChannelPartnerRepricingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->DeleteChannelPartnerRepricingConfig(request));
}

StreamRange<google::cloud::channel::v1::SkuGroup>
CloudChannelServiceTracingConnection::ListSkuGroups(
    google::cloud::channel::v1::ListSkuGroupsRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListSkuGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListSkuGroups(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::channel::v1::SkuGroup>(
      std::move(span), std::move(sr));
}

StreamRange<google::cloud::channel::v1::BillableSku>
CloudChannelServiceTracingConnection::ListSkuGroupBillableSkus(
    google::cloud::channel::v1::ListSkuGroupBillableSkusRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListSkuGroupBillableSkus");
  internal::OTelScope scope(span);
  auto sr = child_->ListSkuGroupBillableSkus(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::BillableSku>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::channel::v1::Offer>
CloudChannelServiceTracingConnection::LookupOffer(
    google::cloud::channel::v1::LookupOfferRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::LookupOffer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->LookupOffer(request));
}

StreamRange<google::cloud::channel::v1::Product>
CloudChannelServiceTracingConnection::ListProducts(
    google::cloud::channel::v1::ListProductsRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListProducts");
  internal::OTelScope scope(span);
  auto sr = child_->ListProducts(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::channel::v1::Product>(
      std::move(span), std::move(sr));
}

StreamRange<google::cloud::channel::v1::Sku>
CloudChannelServiceTracingConnection::ListSkus(
    google::cloud::channel::v1::ListSkusRequest request) {
  auto span =
      internal::MakeSpan("channel_v1::CloudChannelServiceConnection::ListSkus");
  internal::OTelScope scope(span);
  auto sr = child_->ListSkus(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::channel::v1::Sku>(
      std::move(span), std::move(sr));
}

StreamRange<google::cloud::channel::v1::Offer>
CloudChannelServiceTracingConnection::ListOffers(
    google::cloud::channel::v1::ListOffersRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListOffers");
  internal::OTelScope scope(span);
  auto sr = child_->ListOffers(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::channel::v1::Offer>(
      std::move(span), std::move(sr));
}

StreamRange<google::cloud::channel::v1::PurchasableSku>
CloudChannelServiceTracingConnection::ListPurchasableSkus(
    google::cloud::channel::v1::ListPurchasableSkusRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListPurchasableSkus");
  internal::OTelScope scope(span);
  auto sr = child_->ListPurchasableSkus(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::PurchasableSku>(std::move(span),
                                                  std::move(sr));
}

StreamRange<google::cloud::channel::v1::PurchasableOffer>
CloudChannelServiceTracingConnection::ListPurchasableOffers(
    google::cloud::channel::v1::ListPurchasableOffersRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListPurchasableOffers");
  internal::OTelScope scope(span);
  auto sr = child_->ListPurchasableOffers(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::PurchasableOffer>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::channel::v1::QueryEligibleBillingAccountsResponse>
CloudChannelServiceTracingConnection::QueryEligibleBillingAccounts(
    google::cloud::channel::v1::QueryEligibleBillingAccountsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::"
      "QueryEligibleBillingAccounts");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->QueryEligibleBillingAccounts(request));
}

StatusOr<google::cloud::channel::v1::RegisterSubscriberResponse>
CloudChannelServiceTracingConnection::RegisterSubscriber(
    google::cloud::channel::v1::RegisterSubscriberRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::RegisterSubscriber");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RegisterSubscriber(request));
}

StatusOr<google::cloud::channel::v1::UnregisterSubscriberResponse>
CloudChannelServiceTracingConnection::UnregisterSubscriber(
    google::cloud::channel::v1::UnregisterSubscriberRequest const& request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::UnregisterSubscriber");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UnregisterSubscriber(request));
}

StreamRange<std::string> CloudChannelServiceTracingConnection::ListSubscribers(
    google::cloud::channel::v1::ListSubscribersRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListSubscribers");
  internal::OTelScope scope(span);
  auto sr = child_->ListSubscribers(std::move(request));
  return internal::MakeTracedStreamRange<std::string>(std::move(span),
                                                      std::move(sr));
}

StreamRange<google::cloud::channel::v1::EntitlementChange>
CloudChannelServiceTracingConnection::ListEntitlementChanges(
    google::cloud::channel::v1::ListEntitlementChangesRequest request) {
  auto span = internal::MakeSpan(
      "channel_v1::CloudChannelServiceConnection::ListEntitlementChanges");
  internal::OTelScope scope(span);
  auto sr = child_->ListEntitlementChanges(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::channel::v1::EntitlementChange>(std::move(span),
                                                     std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<channel_v1::CloudChannelServiceConnection>
MakeCloudChannelServiceTracingConnection(
    std::shared_ptr<channel_v1::CloudChannelServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<CloudChannelServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace channel_v1_internal
}  // namespace cloud
}  // namespace google
