// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

#include "google/cloud/cloudbuild/v1/cloud_build_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace cloudbuild_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudBuildConnectionIdempotencyPolicy::
    ~CloudBuildConnectionIdempotencyPolicy() = default;

std::unique_ptr<CloudBuildConnectionIdempotencyPolicy>
CloudBuildConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CloudBuildConnectionIdempotencyPolicy>(*this);
}

Idempotency CloudBuildConnectionIdempotencyPolicy::CreateBuild(
    google::devtools::cloudbuild::v1::CreateBuildRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::GetBuild(
    google::devtools::cloudbuild::v1::GetBuildRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::ListBuilds(
    google::devtools::cloudbuild::v1::ListBuildsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::CancelBuild(
    google::devtools::cloudbuild::v1::CancelBuildRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::RetryBuild(
    google::devtools::cloudbuild::v1::RetryBuildRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::ApproveBuild(
    google::devtools::cloudbuild::v1::ApproveBuildRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::CreateBuildTrigger(
    google::devtools::cloudbuild::v1::CreateBuildTriggerRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::GetBuildTrigger(
    google::devtools::cloudbuild::v1::GetBuildTriggerRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::ListBuildTriggers(
    google::devtools::cloudbuild::v1::ListBuildTriggersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::DeleteBuildTrigger(
    google::devtools::cloudbuild::v1::DeleteBuildTriggerRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::UpdateBuildTrigger(
    google::devtools::cloudbuild::v1::UpdateBuildTriggerRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::RunBuildTrigger(
    google::devtools::cloudbuild::v1::RunBuildTriggerRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::ReceiveTriggerWebhook(
    google::devtools::cloudbuild::v1::ReceiveTriggerWebhookRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::CreateWorkerPool(
    google::devtools::cloudbuild::v1::CreateWorkerPoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::GetWorkerPool(
    google::devtools::cloudbuild::v1::GetWorkerPoolRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::DeleteWorkerPool(
    google::devtools::cloudbuild::v1::DeleteWorkerPoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::UpdateWorkerPool(
    google::devtools::cloudbuild::v1::UpdateWorkerPoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudBuildConnectionIdempotencyPolicy::ListWorkerPools(
    google::devtools::cloudbuild::v1::ListWorkerPoolsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<CloudBuildConnectionIdempotencyPolicy>
MakeDefaultCloudBuildConnectionIdempotencyPolicy() {
  return std::make_unique<CloudBuildConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild_v1
}  // namespace cloud
}  // namespace google
