// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/external_vpn_gateways/v1/external_vpn_gateways.proto

#include "google/cloud/compute/external_vpn_gateways/v1/external_vpn_gateways_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_external_vpn_gateways_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ExternalVpnGatewaysConnectionIdempotencyPolicy::
    ~ExternalVpnGatewaysConnectionIdempotencyPolicy() = default;

std::unique_ptr<ExternalVpnGatewaysConnectionIdempotencyPolicy>
ExternalVpnGatewaysConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ExternalVpnGatewaysConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
ExternalVpnGatewaysConnectionIdempotencyPolicy::DeleteExternalVpnGateway(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        DeleteExternalVpnGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ExternalVpnGatewaysConnectionIdempotencyPolicy::GetExternalVpnGateway(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        GetExternalVpnGatewayRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
ExternalVpnGatewaysConnectionIdempotencyPolicy::InsertExternalVpnGateway(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        InsertExternalVpnGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ExternalVpnGatewaysConnectionIdempotencyPolicy::ListExternalVpnGateways(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        ListExternalVpnGatewaysRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ExternalVpnGatewaysConnectionIdempotencyPolicy::SetLabels(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        SetLabelsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ExternalVpnGatewaysConnectionIdempotencyPolicy::TestIamPermissions(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        TestIamPermissionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ExternalVpnGatewaysConnectionIdempotencyPolicy>
MakeDefaultExternalVpnGatewaysConnectionIdempotencyPolicy() {
  return std::make_unique<ExternalVpnGatewaysConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_external_vpn_gateways_v1
}  // namespace cloud
}  // namespace google
