// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/machine_images/v1/machine_images.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_INTERNAL_MACHINE_IMAGES_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_INTERNAL_MACHINE_IMAGES_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/machine_images/v1/internal/machine_images_rest_stub.h"
#include "google/cloud/compute/machine_images/v1/internal/machine_images_retry_traits.h"
#include "google/cloud/compute/machine_images/v1/machine_images_connection.h"
#include "google/cloud/compute/machine_images/v1/machine_images_connection_idempotency_policy.h"
#include "google/cloud/compute/machine_images/v1/machine_images_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/global_operations/v1/global_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_machine_images_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MachineImagesRestConnectionImpl
    : public compute_machine_images_v1::MachineImagesConnection {
 public:
  ~MachineImagesRestConnectionImpl() override = default;

  MachineImagesRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<compute_machine_images_v1_internal::MachineImagesRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteMachineImage(google::cloud::cpp::compute::machine_images::v1::
                         DeleteMachineImageRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::MachineImage> GetMachineImage(
      google::cloud::cpp::compute::machine_images::v1::
          GetMachineImageRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> GetIamPolicy(
      google::cloud::cpp::compute::machine_images::v1::
          GetIamPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertMachineImage(google::cloud::cpp::compute::machine_images::v1::
                         InsertMachineImageRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::MachineImage> ListMachineImages(
      google::cloud::cpp::compute::machine_images::v1::ListMachineImagesRequest
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> SetIamPolicy(
      google::cloud::cpp::compute::machine_images::v1::
          SetIamPolicyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
  TestIamPermissions(google::cloud::cpp::compute::machine_images::v1::
                         TestIamPermissionsRequest const& request) override;

 private:
  static std::unique_ptr<compute_machine_images_v1::MachineImagesRetryPolicy>
  retry_policy(Options const& options) {
    return options
        .get<compute_machine_images_v1::MachineImagesRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<compute_machine_images_v1::MachineImagesBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<
      compute_machine_images_v1::MachineImagesConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_machine_images_v1::
                 MachineImagesConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<compute_machine_images_v1::MachineImagesPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<compute_machine_images_v1_internal::MachineImagesRestStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_machine_images_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_INTERNAL_MACHINE_IMAGES_REST_CONNECTION_IMPL_H
