// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/networks/v1/networks.proto

#include "google/cloud/compute/networks/v1/networks_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_networks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworksClient::NetworksClient(std::shared_ptr<NetworksConnection> connection,
                               Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NetworksClient::~NetworksClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::AddPeering(
    std::string const& project, std::string const& network,
    google::cloud::cpp::compute::v1::NetworksAddPeeringRequest const&
        networks_add_peering_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::AddPeeringRequest request;
  request.set_project(project);
  request.set_network(network);
  *request.mutable_networks_add_peering_request_resource() =
      networks_add_peering_request_resource;
  return connection_->AddPeering(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::AddPeering(
    google::cloud::cpp::compute::networks::v1::AddPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddPeering(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::DeleteNetwork(std::string const& project,
                              std::string const& network, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::DeleteNetworkRequest request;
  request.set_project(project);
  request.set_network(network);
  return connection_->DeleteNetwork(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::DeleteNetwork(
    google::cloud::cpp::compute::networks::v1::DeleteNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetwork(request);
}

StatusOr<google::cloud::cpp::compute::v1::Network> NetworksClient::GetNetwork(
    std::string const& project, std::string const& network, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::GetNetworkRequest request;
  request.set_project(project);
  request.set_network(network);
  return connection_->GetNetwork(request);
}

StatusOr<google::cloud::cpp::compute::v1::Network> NetworksClient::GetNetwork(
    google::cloud::cpp::compute::networks::v1::GetNetworkRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetwork(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworksGetEffectiveFirewallsResponse>
NetworksClient::GetEffectiveFirewalls(std::string const& project,
                                      std::string const& network,
                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::GetEffectiveFirewallsRequest
      request;
  request.set_project(project);
  request.set_network(network);
  return connection_->GetEffectiveFirewalls(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworksGetEffectiveFirewallsResponse>
NetworksClient::GetEffectiveFirewalls(
    google::cloud::cpp::compute::networks::v1::
        GetEffectiveFirewallsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEffectiveFirewalls(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::InsertNetwork(
    std::string const& project,
    google::cloud::cpp::compute::v1::Network const& network_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::InsertNetworkRequest request;
  request.set_project(project);
  *request.mutable_network_resource() = network_resource;
  return connection_->InsertNetwork(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::InsertNetwork(
    google::cloud::cpp::compute::networks::v1::InsertNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetwork(request);
}

StreamRange<google::cloud::cpp::compute::v1::Network>
NetworksClient::ListNetworks(std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::ListNetworksRequest request;
  request.set_project(project);
  return connection_->ListNetworks(request);
}

StreamRange<google::cloud::cpp::compute::v1::Network>
NetworksClient::ListNetworks(
    google::cloud::cpp::compute::networks::v1::ListNetworksRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworks(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::ExchangedPeeringRoute>
NetworksClient::ListPeeringRoutes(std::string const& project,
                                  std::string const& network, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::ListPeeringRoutesRequest request;
  request.set_project(project);
  request.set_network(network);
  return connection_->ListPeeringRoutes(request);
}

StreamRange<google::cloud::cpp::compute::v1::ExchangedPeeringRoute>
NetworksClient::ListPeeringRoutes(
    google::cloud::cpp::compute::networks::v1::ListPeeringRoutesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPeeringRoutes(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::PatchNetwork(
    std::string const& project, std::string const& network,
    google::cloud::cpp::compute::v1::Network const& network_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::PatchNetworkRequest request;
  request.set_project(project);
  request.set_network(network);
  *request.mutable_network_resource() = network_resource;
  return connection_->PatchNetwork(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::PatchNetwork(
    google::cloud::cpp::compute::networks::v1::PatchNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchNetwork(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::RemovePeering(
    std::string const& project, std::string const& network,
    google::cloud::cpp::compute::v1::NetworksRemovePeeringRequest const&
        networks_remove_peering_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::RemovePeeringRequest request;
  request.set_project(project);
  request.set_network(network);
  *request.mutable_networks_remove_peering_request_resource() =
      networks_remove_peering_request_resource;
  return connection_->RemovePeering(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::RemovePeering(
    google::cloud::cpp::compute::networks::v1::RemovePeeringRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemovePeering(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::SwitchToCustomMode(std::string const& project,
                                   std::string const& network, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::SwitchToCustomModeRequest request;
  request.set_project(project);
  request.set_network(network);
  return connection_->SwitchToCustomMode(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::SwitchToCustomMode(
    google::cloud::cpp::compute::networks::v1::SwitchToCustomModeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SwitchToCustomMode(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::UpdatePeering(
    std::string const& project, std::string const& network,
    google::cloud::cpp::compute::v1::NetworksUpdatePeeringRequest const&
        networks_update_peering_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::networks::v1::UpdatePeeringRequest request;
  request.set_project(project);
  request.set_network(network);
  *request.mutable_networks_update_peering_request_resource() =
      networks_update_peering_request_resource;
  return connection_->UpdatePeering(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksClient::UpdatePeering(
    google::cloud::cpp::compute::networks::v1::UpdatePeeringRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePeering(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_networks_v1
}  // namespace cloud
}  // namespace google
