// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_instance_group_managers/v1/region_instance_group_managers.proto

#include "google/cloud/compute/region_instance_group_managers/v1/internal/region_instance_group_managers_rest_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/absl_str_join_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_instance_group_managers_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionInstanceGroupManagersRestMetadata::
    RegionInstanceGroupManagersRestMetadata(
        std::shared_ptr<RegionInstanceGroupManagersRestStub> child,
        std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncAbandonInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        AbandonInstancesRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncAbandonInstances(cq, std::move(rest_context), options,
                                       request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncApplyUpdatesToInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        ApplyUpdatesToInstancesRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncApplyUpdatesToInstances(cq, std::move(rest_context),
                                              options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncCreateInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        CreateInstancesRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncCreateInstances(cq, std::move(rest_context), options,
                                      request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncDeleteInstanceGroupManager(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        DeleteInstanceGroupManagerRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncDeleteInstanceGroupManager(cq, std::move(rest_context),
                                                 options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncDeleteInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        DeleteInstancesRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncDeleteInstances(cq, std::move(rest_context), options,
                                      request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncDeletePerInstanceConfigs(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        DeletePerInstanceConfigsRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncDeletePerInstanceConfigs(cq, std::move(rest_context),
                                               options, request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManager>
RegionInstanceGroupManagersRestMetadata::GetInstanceGroupManager(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        GetInstanceGroupManagerRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetInstanceGroupManager(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncInsertInstanceGroupManager(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        InsertInstanceGroupManagerRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncInsertInstanceGroupManager(cq, std::move(rest_context),
                                                 options, request);
}

StatusOr<google::cloud::cpp::compute::v1::RegionInstanceGroupManagerList>
RegionInstanceGroupManagersRestMetadata::ListRegionInstanceGroupManagers(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        ListRegionInstanceGroupManagersRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListRegionInstanceGroupManagers(rest_context, options,
                                                 request);
}

StatusOr<google::cloud::cpp::compute::v1::
             RegionInstanceGroupManagersListErrorsResponse>
RegionInstanceGroupManagersRestMetadata::ListErrors(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        ListErrorsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListErrors(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::
             RegionInstanceGroupManagersListInstancesResponse>
RegionInstanceGroupManagersRestMetadata::ListManagedInstances(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        ListManagedInstancesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListManagedInstances(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::
             RegionInstanceGroupManagersListInstanceConfigsResp>
RegionInstanceGroupManagersRestMetadata::ListPerInstanceConfigs(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        ListPerInstanceConfigsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListPerInstanceConfigs(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncPatchInstanceGroupManager(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        PatchInstanceGroupManagerRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncPatchInstanceGroupManager(cq, std::move(rest_context),
                                                options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncPatchPerInstanceConfigs(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        PatchPerInstanceConfigsRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncPatchPerInstanceConfigs(cq, std::move(rest_context),
                                              options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncRecreateInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        RecreateInstancesRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncRecreateInstances(cq, std::move(rest_context), options,
                                        request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncResize(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        ResizeRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncResize(cq, std::move(rest_context), options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncSetInstanceTemplate(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        SetInstanceTemplateRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncSetInstanceTemplate(cq, std::move(rest_context), options,
                                          request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncSetTargetPools(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        SetTargetPoolsRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncSetTargetPools(cq, std::move(rest_context), options,
                                     request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncUpdatePerInstanceConfigs(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_instance_group_managers::v1::
        UpdatePerInstanceConfigsRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncUpdatePerInstanceConfigs(cq, std::move(rest_context),
                                               options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupManagersRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncGetOperation(cq, std::move(rest_context), options,
                                   request);
}

future<Status> RegionInstanceGroupManagersRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::region_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context), options,
                                      request);
}

void RegionInstanceGroupManagersRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  rest_context.AddHeader("x-goog-api-client", api_client_header_);
  if (!params.empty()) {
    rest_context.AddHeader("x-goog-request-params", absl::StrJoin(params, "&"));
  }
  if (options.has<UserProjectOption>()) {
    rest_context.AddHeader("x-goog-user-project",
                           options.get<UserProjectOption>());
  }
  if (options.has<google::cloud::QuotaUserOption>()) {
    rest_context.AddHeader("x-goog-quota-user",
                           options.get<google::cloud::QuotaUserOption>());
  }
  if (options.has<google::cloud::ServerTimeoutOption>()) {
    auto ms_rep = absl::StrCat(
        absl::Dec(options.get<google::cloud::ServerTimeoutOption>().count(),
                  absl::kZeroPad4));
    rest_context.AddHeader("x-server-timeout",
                           ms_rep.insert(ms_rep.size() - 3, "."));
  }
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instance_group_managers_v1_internal
}  // namespace cloud
}  // namespace google
