// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/content.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_CONTENT_LOGGING_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_CONTENT_LOGGING_DECORATOR_H

#include "google/cloud/dataplex/v1/internal/content_stub.h"
#include "google/cloud/tracing_options.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ContentServiceLogging : public ContentServiceStub {
 public:
  ~ContentServiceLogging() override = default;
  ContentServiceLogging(std::shared_ptr<ContentServiceStub> child,
                        TracingOptions tracing_options,
                        std::set<std::string> const& components);

  StatusOr<google::cloud::dataplex::v1::Content> CreateContent(
      grpc::ClientContext& context,
      google::cloud::dataplex::v1::CreateContentRequest const& request)
      override;

  StatusOr<google::cloud::dataplex::v1::Content> UpdateContent(
      grpc::ClientContext& context,
      google::cloud::dataplex::v1::UpdateContentRequest const& request)
      override;

  Status DeleteContent(grpc::ClientContext& context,
                       google::cloud::dataplex::v1::DeleteContentRequest const&
                           request) override;

  StatusOr<google::cloud::dataplex::v1::Content> GetContent(
      grpc::ClientContext& context,
      google::cloud::dataplex::v1::GetContentRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::cloud::dataplex::v1::ListContentResponse> ListContent(
      grpc::ClientContext& context,
      google::cloud::dataplex::v1::ListContentRequest const& request) override;

 private:
  std::shared_ptr<ContentServiceStub> child_;
  TracingOptions tracing_options_;
  bool stream_logging_;
};  // ContentServiceLogging

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_CONTENT_LOGGING_DECORATOR_H
