// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/experiment.proto

#include "google/cloud/dialogflow_cx/experiments_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ExperimentsClient::ExperimentsClient(
    std::shared_ptr<ExperimentsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ExperimentsClient::~ExperimentsClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::ListExperiments(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListExperimentsRequest request;
  request.set_parent(parent);
  return connection_->ListExperiments(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::ListExperiments(
    google::cloud::dialogflow::cx::v3::ListExperimentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExperiments(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::GetExperiment(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetExperimentRequest request;
  request.set_name(name);
  return connection_->GetExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::GetExperiment(
    google::cloud::dialogflow::cx::v3::GetExperimentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::CreateExperiment(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::Experiment const& experiment,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateExperimentRequest request;
  request.set_parent(parent);
  *request.mutable_experiment() = experiment;
  return connection_->CreateExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::CreateExperiment(
    google::cloud::dialogflow::cx::v3::CreateExperimentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::UpdateExperiment(
    google::cloud::dialogflow::cx::v3::Experiment const& experiment,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateExperimentRequest request;
  *request.mutable_experiment() = experiment;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::UpdateExperiment(
    google::cloud::dialogflow::cx::v3::UpdateExperimentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExperiment(request);
}

Status ExperimentsClient::DeleteExperiment(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteExperimentRequest request;
  request.set_name(name);
  return connection_->DeleteExperiment(request);
}

Status ExperimentsClient::DeleteExperiment(
    google::cloud::dialogflow::cx::v3::DeleteExperimentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::StartExperiment(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::StartExperimentRequest request;
  request.set_name(name);
  return connection_->StartExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::StartExperiment(
    google::cloud::dialogflow::cx::v3::StartExperimentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::StopExperiment(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::StopExperimentRequest request;
  request.set_name(name);
  return connection_->StopExperiment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsClient::StopExperiment(
    google::cloud::dialogflow::cx::v3::StopExperimentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopExperiment(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
