// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/conversational_search_service.proto

#include "google/cloud/discoveryengine/v1/internal/conversational_search_auth_decorator.h"
#include <google/cloud/discoveryengine/v1/conversational_search_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationalSearchServiceAuth::ConversationalSearchServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<ConversationalSearchServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::discoveryengine::v1::ConverseConversationResponse>
ConversationalSearchServiceAuth::ConverseConversation(
    grpc::ClientContext& context,
    google::cloud::discoveryengine::v1::ConverseConversationRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ConverseConversation(context, request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceAuth::CreateConversation(
    grpc::ClientContext& context,
    google::cloud::discoveryengine::v1::CreateConversationRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateConversation(context, request);
}

Status ConversationalSearchServiceAuth::DeleteConversation(
    grpc::ClientContext& context,
    google::cloud::discoveryengine::v1::DeleteConversationRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteConversation(context, request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceAuth::UpdateConversation(
    grpc::ClientContext& context,
    google::cloud::discoveryengine::v1::UpdateConversationRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateConversation(context, request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceAuth::GetConversation(
    grpc::ClientContext& context,
    google::cloud::discoveryengine::v1::GetConversationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetConversation(context, request);
}

StatusOr<google::cloud::discoveryengine::v1::ListConversationsResponse>
ConversationalSearchServiceAuth::ListConversations(
    grpc::ClientContext& context,
    google::cloud::discoveryengine::v1::ListConversationsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListConversations(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
