// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/schema_service.proto

#include "google/cloud/discoveryengine/v1/schema_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SchemaServiceClient::SchemaServiceClient(
    std::shared_ptr<SchemaServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SchemaServiceClient::~SchemaServiceClient() = default;

StatusOr<google::cloud::discoveryengine::v1::Schema>
SchemaServiceClient::GetSchema(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::GetSchemaRequest request;
  request.set_name(name);
  return connection_->GetSchema(request);
}

StatusOr<google::cloud::discoveryengine::v1::Schema>
SchemaServiceClient::GetSchema(
    google::cloud::discoveryengine::v1::GetSchemaRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSchema(request);
}

StreamRange<google::cloud::discoveryengine::v1::Schema>
SchemaServiceClient::ListSchemas(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::ListSchemasRequest request;
  request.set_parent(parent);
  return connection_->ListSchemas(request);
}

StreamRange<google::cloud::discoveryengine::v1::Schema>
SchemaServiceClient::ListSchemas(
    google::cloud::discoveryengine::v1::ListSchemasRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSchemas(std::move(request));
}

future<StatusOr<google::cloud::discoveryengine::v1::Schema>>
SchemaServiceClient::CreateSchema(
    std::string const& parent,
    google::cloud::discoveryengine::v1::Schema const& schema,
    std::string const& schema_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::CreateSchemaRequest request;
  request.set_parent(parent);
  *request.mutable_schema() = schema;
  request.set_schema_id(schema_id);
  return connection_->CreateSchema(request);
}

future<StatusOr<google::cloud::discoveryengine::v1::Schema>>
SchemaServiceClient::CreateSchema(
    google::cloud::discoveryengine::v1::CreateSchemaRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSchema(request);
}

future<StatusOr<google::cloud::discoveryengine::v1::Schema>>
SchemaServiceClient::UpdateSchema(
    google::cloud::discoveryengine::v1::UpdateSchemaRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSchema(request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>
SchemaServiceClient::DeleteSchema(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::DeleteSchemaRequest request;
  request.set_name(name);
  return connection_->DeleteSchema(request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>
SchemaServiceClient::DeleteSchema(
    google::cloud::discoveryengine::v1::DeleteSchemaRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSchema(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
