// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/metricsscope/v1/metrics_scopes.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_METRICSSCOPE_V1_INTERNAL_METRICS_SCOPES_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_METRICSSCOPE_V1_INTERNAL_METRICS_SCOPES_CONNECTION_IMPL_H

#include "google/cloud/monitoring/metricsscope/v1/internal/metrics_scopes_retry_traits.h"
#include "google/cloud/monitoring/metricsscope/v1/internal/metrics_scopes_stub.h"
#include "google/cloud/monitoring/metricsscope/v1/metrics_scopes_connection.h"
#include "google/cloud/monitoring/metricsscope/v1/metrics_scopes_connection_idempotency_policy.h"
#include "google/cloud/monitoring/metricsscope/v1/metrics_scopes_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_metricsscope_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MetricsScopesConnectionImpl
    : public monitoring_metricsscope_v1::MetricsScopesConnection {
 public:
  ~MetricsScopesConnectionImpl() override = default;

  MetricsScopesConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<monitoring_metricsscope_v1_internal::MetricsScopesStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::monitoring::metricsscope::v1::MetricsScope> GetMetricsScope(
      google::monitoring::metricsscope::v1::GetMetricsScopeRequest const&
          request) override;

  StatusOr<google::monitoring::metricsscope::v1::
               ListMetricsScopesByMonitoredProjectResponse>
  ListMetricsScopesByMonitoredProject(
      google::monitoring::metricsscope::v1::
          ListMetricsScopesByMonitoredProjectRequest const& request) override;

  future<StatusOr<google::monitoring::metricsscope::v1::MonitoredProject>>
  CreateMonitoredProject(
      google::monitoring::metricsscope::v1::CreateMonitoredProjectRequest const&
          request) override;

  future<StatusOr<google::monitoring::metricsscope::v1::OperationMetadata>>
  DeleteMonitoredProject(
      google::monitoring::metricsscope::v1::DeleteMonitoredProjectRequest const&
          request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<monitoring_metricsscope_v1_internal::MetricsScopesStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_metricsscope_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_METRICSSCOPE_V1_INTERNAL_METRICS_SCOPES_CONNECTION_IMPL_H
