// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/group_service.proto

#include "google/cloud/monitoring/v3/group_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GroupServiceClient::GroupServiceClient(
    std::shared_ptr<GroupServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
GroupServiceClient::~GroupServiceClient() = default;

StreamRange<google::monitoring::v3::Group> GroupServiceClient::ListGroups(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::ListGroupsRequest request;
  request.set_name(name);
  return connection_->ListGroups(request);
}

StreamRange<google::monitoring::v3::Group> GroupServiceClient::ListGroups(
    google::monitoring::v3::ListGroupsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGroups(std::move(request));
}

StatusOr<google::monitoring::v3::Group> GroupServiceClient::GetGroup(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::GetGroupRequest request;
  request.set_name(name);
  return connection_->GetGroup(request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceClient::GetGroup(
    google::monitoring::v3::GetGroupRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGroup(request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceClient::CreateGroup(
    std::string const& name, google::monitoring::v3::Group const& group,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::CreateGroupRequest request;
  request.set_name(name);
  *request.mutable_group() = group;
  return connection_->CreateGroup(request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceClient::CreateGroup(
    google::monitoring::v3::CreateGroupRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGroup(request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceClient::UpdateGroup(
    google::monitoring::v3::Group const& group, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::UpdateGroupRequest request;
  *request.mutable_group() = group;
  return connection_->UpdateGroup(request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceClient::UpdateGroup(
    google::monitoring::v3::UpdateGroupRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGroup(request);
}

Status GroupServiceClient::DeleteGroup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::DeleteGroupRequest request;
  request.set_name(name);
  return connection_->DeleteGroup(request);
}

Status GroupServiceClient::DeleteGroup(
    google::monitoring::v3::DeleteGroupRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGroup(request);
}

StreamRange<google::api::MonitoredResource>
GroupServiceClient::ListGroupMembers(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::ListGroupMembersRequest request;
  request.set_name(name);
  return connection_->ListGroupMembers(request);
}

StreamRange<google::api::MonitoredResource>
GroupServiceClient::ListGroupMembers(
    google::monitoring::v3::ListGroupMembersRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGroupMembers(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
