// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/alert_service.proto

#include "google/cloud/monitoring/v3/internal/alert_policy_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AlertPolicyServiceTracingStub::AlertPolicyServiceTracingStub(
    std::shared_ptr<AlertPolicyServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::monitoring::v3::ListAlertPoliciesResponse>
AlertPolicyServiceTracingStub::ListAlertPolicies(
    grpc::ClientContext& context,
    google::monitoring::v3::ListAlertPoliciesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.AlertPolicyService",
                                     "ListAlertPolicies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAlertPolicies(context, request));
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceTracingStub::GetAlertPolicy(
    grpc::ClientContext& context,
    google::monitoring::v3::GetAlertPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.AlertPolicyService",
                                     "GetAlertPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAlertPolicy(context, request));
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceTracingStub::CreateAlertPolicy(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateAlertPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.AlertPolicyService",
                                     "CreateAlertPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateAlertPolicy(context, request));
}

Status AlertPolicyServiceTracingStub::DeleteAlertPolicy(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteAlertPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.AlertPolicyService",
                                     "DeleteAlertPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteAlertPolicy(context, request));
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceTracingStub::UpdateAlertPolicy(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateAlertPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.AlertPolicyService",
                                     "UpdateAlertPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateAlertPolicy(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AlertPolicyServiceStub> MakeAlertPolicyServiceTracingStub(
    std::shared_ptr<AlertPolicyServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AlertPolicyServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
