// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#include "google/cloud/monitoring/v3/service_monitoring_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ServiceMonitoringServiceConnectionIdempotencyPolicy::
    ~ServiceMonitoringServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<ServiceMonitoringServiceConnectionIdempotencyPolicy>
ServiceMonitoringServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ServiceMonitoringServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::CreateService(
    google::monitoring::v3::CreateServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::GetService(
    google::monitoring::v3::GetServiceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::ListServices(
    google::monitoring::v3::ListServicesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::UpdateService(
    google::monitoring::v3::UpdateServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::DeleteService(
    google::monitoring::v3::DeleteServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::
    CreateServiceLevelObjective(
        google::monitoring::v3::CreateServiceLevelObjectiveRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ServiceMonitoringServiceConnectionIdempotencyPolicy::GetServiceLevelObjective(
    google::monitoring::v3::GetServiceLevelObjectiveRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
ServiceMonitoringServiceConnectionIdempotencyPolicy::ListServiceLevelObjectives(
    google::monitoring::v3::ListServiceLevelObjectivesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::
    UpdateServiceLevelObjective(
        google::monitoring::v3::UpdateServiceLevelObjectiveRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceMonitoringServiceConnectionIdempotencyPolicy::
    DeleteServiceLevelObjective(
        google::monitoring::v3::DeleteServiceLevelObjectiveRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ServiceMonitoringServiceConnectionIdempotencyPolicy>
MakeDefaultServiceMonitoringServiceConnectionIdempotencyPolicy() {
  return std::make_unique<
      ServiceMonitoringServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
