// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/folders.proto

#include "google/cloud/resourcemanager/v3/internal/folders_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

FoldersTracingConnection::FoldersTracingConnection(
    std::shared_ptr<resourcemanager_v3::FoldersConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::resourcemanager::v3::Folder>
FoldersTracingConnection::GetFolder(
    google::cloud::resourcemanager::v3::GetFolderRequest const& request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::GetFolder");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFolder(request));
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersTracingConnection::ListFolders(
    google::cloud::resourcemanager::v3::ListFoldersRequest request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::ListFolders");
  internal::OTelScope scope(span);
  auto sr = child_->ListFolders(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::resourcemanager::v3::Folder>(std::move(span),
                                                  std::move(sr));
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersTracingConnection::SearchFolders(
    google::cloud::resourcemanager::v3::SearchFoldersRequest request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::FoldersConnection::SearchFolders");
  internal::OTelScope scope(span);
  auto sr = child_->SearchFolders(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::resourcemanager::v3::Folder>(std::move(span),
                                                  std::move(sr));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersTracingConnection::CreateFolder(
    google::cloud::resourcemanager::v3::CreateFolderRequest const& request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::CreateFolder");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateFolder(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersTracingConnection::UpdateFolder(
    google::cloud::resourcemanager::v3::UpdateFolderRequest const& request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::UpdateFolder");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateFolder(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersTracingConnection::MoveFolder(
    google::cloud::resourcemanager::v3::MoveFolderRequest const& request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::MoveFolder");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->MoveFolder(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersTracingConnection::DeleteFolder(
    google::cloud::resourcemanager::v3::DeleteFolderRequest const& request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::DeleteFolder");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteFolder(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersTracingConnection::UndeleteFolder(
    google::cloud::resourcemanager::v3::UndeleteFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::FoldersConnection::UndeleteFolder");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UndeleteFolder(request));
}

StatusOr<google::iam::v1::Policy> FoldersTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy> FoldersTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("resourcemanager_v3::FoldersConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FoldersTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::FoldersConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<resourcemanager_v3::FoldersConnection>
MakeFoldersTracingConnection(
    std::shared_ptr<resourcemanager_v3::FoldersConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<FoldersTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3_internal
}  // namespace cloud
}  // namespace google
