// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_keys.proto

#include "google/cloud/resourcemanager/v3/tag_keys_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TagKeysConnectionIdempotencyPolicy::~TagKeysConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<TagKeysConnectionIdempotencyPolicy>
TagKeysConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TagKeysConnectionIdempotencyPolicy>(*this);
}

Idempotency TagKeysConnectionIdempotencyPolicy::ListTagKeys(
    google::cloud::resourcemanager::v3::ListTagKeysRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::GetTagKey(
    google::cloud::resourcemanager::v3::GetTagKeyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::GetNamespacedTagKey(
    google::cloud::resourcemanager::v3::GetNamespacedTagKeyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::CreateTagKey(
    google::cloud::resourcemanager::v3::CreateTagKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::UpdateTagKey(
    google::cloud::resourcemanager::v3::UpdateTagKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::DeleteTagKey(
    google::cloud::resourcemanager::v3::DeleteTagKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency TagKeysConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<TagKeysConnectionIdempotencyPolicy>
MakeDefaultTagKeysConnectionIdempotencyPolicy() {
  return std::make_unique<TagKeysConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
