// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/scheduler/v1/cloudscheduler.proto

#include "google/cloud/scheduler/v1/cloud_scheduler_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace scheduler_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudSchedulerConnectionIdempotencyPolicy::
    ~CloudSchedulerConnectionIdempotencyPolicy() = default;

std::unique_ptr<CloudSchedulerConnectionIdempotencyPolicy>
CloudSchedulerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CloudSchedulerConnectionIdempotencyPolicy>(*this);
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::ListJobs(
    google::cloud::scheduler::v1::ListJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::GetJob(
    google::cloud::scheduler::v1::GetJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::CreateJob(
    google::cloud::scheduler::v1::CreateJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::UpdateJob(
    google::cloud::scheduler::v1::UpdateJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::DeleteJob(
    google::cloud::scheduler::v1::DeleteJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::PauseJob(
    google::cloud::scheduler::v1::PauseJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::ResumeJob(
    google::cloud::scheduler::v1::ResumeJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudSchedulerConnectionIdempotencyPolicy::RunJob(
    google::cloud::scheduler::v1::RunJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CloudSchedulerConnectionIdempotencyPolicy>
MakeDefaultCloudSchedulerConnectionIdempotencyPolicy() {
  return std::make_unique<CloudSchedulerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace scheduler_v1
}  // namespace cloud
}  // namespace google
