// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_INTERNAL_SERVICE_MANAGER_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_INTERNAL_SERVICE_MANAGER_CONNECTION_IMPL_H

#include "google/cloud/servicemanagement/v1/internal/service_manager_retry_traits.h"
#include "google/cloud/servicemanagement/v1/internal/service_manager_stub.h"
#include "google/cloud/servicemanagement/v1/service_manager_connection.h"
#include "google/cloud/servicemanagement/v1/service_manager_connection_idempotency_policy.h"
#include "google/cloud/servicemanagement/v1/service_manager_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicemanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ServiceManagerConnectionImpl
    : public servicemanagement_v1::ServiceManagerConnection {
 public:
  ~ServiceManagerConnectionImpl() override = default;

  ServiceManagerConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<servicemanagement_v1_internal::ServiceManagerStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::api::servicemanagement::v1::ManagedService> ListServices(
      google::api::servicemanagement::v1::ListServicesRequest request) override;

  StatusOr<google::api::servicemanagement::v1::ManagedService> GetService(
      google::api::servicemanagement::v1::GetServiceRequest const& request)
      override;

  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(google::api::servicemanagement::v1::CreateServiceRequest const&
                    request) override;

  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(google::api::servicemanagement::v1::DeleteServiceRequest const&
                    request) override;

  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(
      google::api::servicemanagement::v1::UndeleteServiceRequest const& request)
      override;

  StreamRange<google::api::Service> ListServiceConfigs(
      google::api::servicemanagement::v1::ListServiceConfigsRequest request)
      override;

  StatusOr<google::api::Service> GetServiceConfig(
      google::api::servicemanagement::v1::GetServiceConfigRequest const&
          request) override;

  StatusOr<google::api::Service> CreateServiceConfig(
      google::api::servicemanagement::v1::CreateServiceConfigRequest const&
          request) override;

  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
          request) override;

  StreamRange<google::api::servicemanagement::v1::Rollout> ListServiceRollouts(
      google::api::servicemanagement::v1::ListServiceRolloutsRequest request)
      override;

  StatusOr<google::api::servicemanagement::v1::Rollout> GetServiceRollout(
      google::api::servicemanagement::v1::GetServiceRolloutRequest const&
          request) override;

  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
          request) override;

  StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
  GenerateConfigReport(
      google::api::servicemanagement::v1::GenerateConfigReportRequest const&
          request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<servicemanagement_v1_internal::ServiceManagerStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_INTERNAL_SERVICE_MANAGER_CONNECTION_IMPL_H
