// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#include "google/cloud/serviceusage/v1/internal/service_usage_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace serviceusage_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ServiceUsageTracingConnection::ServiceUsageTracingConnection(
    std::shared_ptr<serviceusage_v1::ServiceUsageConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>
ServiceUsageTracingConnection::EnableService(
    google::api::serviceusage::v1::EnableServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "serviceusage_v1::ServiceUsageConnection::EnableService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->EnableService(request));
}

future<StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>
ServiceUsageTracingConnection::DisableService(
    google::api::serviceusage::v1::DisableServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "serviceusage_v1::ServiceUsageConnection::DisableService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DisableService(request));
}

StatusOr<google::api::serviceusage::v1::Service>
ServiceUsageTracingConnection::GetService(
    google::api::serviceusage::v1::GetServiceRequest const& request) {
  auto span =
      internal::MakeSpan("serviceusage_v1::ServiceUsageConnection::GetService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetService(request));
}

StreamRange<google::api::serviceusage::v1::Service>
ServiceUsageTracingConnection::ListServices(
    google::api::serviceusage::v1::ListServicesRequest request) {
  auto span = internal::MakeSpan(
      "serviceusage_v1::ServiceUsageConnection::ListServices");
  internal::OTelScope scope(span);
  auto sr = child_->ListServices(std::move(request));
  return internal::MakeTracedStreamRange<
      google::api::serviceusage::v1::Service>(std::move(span), std::move(sr));
}

future<StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>
ServiceUsageTracingConnection::BatchEnableServices(
    google::api::serviceusage::v1::BatchEnableServicesRequest const& request) {
  auto span = internal::MakeSpan(
      "serviceusage_v1::ServiceUsageConnection::BatchEnableServices");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchEnableServices(request));
}

StatusOr<google::api::serviceusage::v1::BatchGetServicesResponse>
ServiceUsageTracingConnection::BatchGetServices(
    google::api::serviceusage::v1::BatchGetServicesRequest const& request) {
  auto span = internal::MakeSpan(
      "serviceusage_v1::ServiceUsageConnection::BatchGetServices");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->BatchGetServices(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<serviceusage_v1::ServiceUsageConnection>
MakeServiceUsageTracingConnection(
    std::shared_ptr<serviceusage_v1::ServiceUsageConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ServiceUsageTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage_v1_internal
}  // namespace cloud
}  // namespace google
