// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/company_service.proto

#include "google/cloud/talent/v4/company_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace talent_v4 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CompanyServiceClient::CompanyServiceClient(
    std::shared_ptr<CompanyServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CompanyServiceClient::~CompanyServiceClient() = default;

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceClient::CreateCompany(
    std::string const& parent,
    google::cloud::talent::v4::Company const& company, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::talent::v4::CreateCompanyRequest request;
  request.set_parent(parent);
  *request.mutable_company() = company;
  return connection_->CreateCompany(request);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceClient::CreateCompany(
    google::cloud::talent::v4::CreateCompanyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCompany(request);
}

StatusOr<google::cloud::talent::v4::Company> CompanyServiceClient::GetCompany(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::talent::v4::GetCompanyRequest request;
  request.set_name(name);
  return connection_->GetCompany(request);
}

StatusOr<google::cloud::talent::v4::Company> CompanyServiceClient::GetCompany(
    google::cloud::talent::v4::GetCompanyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCompany(request);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceClient::UpdateCompany(
    google::cloud::talent::v4::Company const& company,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::talent::v4::UpdateCompanyRequest request;
  *request.mutable_company() = company;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCompany(request);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceClient::UpdateCompany(
    google::cloud::talent::v4::UpdateCompanyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCompany(request);
}

Status CompanyServiceClient::DeleteCompany(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::talent::v4::DeleteCompanyRequest request;
  request.set_name(name);
  return connection_->DeleteCompany(request);
}

Status CompanyServiceClient::DeleteCompany(
    google::cloud::talent::v4::DeleteCompanyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCompany(request);
}

StreamRange<google::cloud::talent::v4::Company>
CompanyServiceClient::ListCompanies(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::talent::v4::ListCompaniesRequest request;
  request.set_parent(parent);
  return connection_->ListCompanies(request);
}

StreamRange<google::cloud::talent::v4::Company>
CompanyServiceClient::ListCompanies(
    google::cloud::talent::v4::ListCompaniesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCompanies(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4
}  // namespace cloud
}  // namespace google
