// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v2/tracing.proto

#include "google/cloud/trace/v2/trace_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace trace_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TraceServiceClient::TraceServiceClient(
    std::shared_ptr<TraceServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TraceServiceClient::~TraceServiceClient() = default;

Status TraceServiceClient::BatchWriteSpans(
    std::string const& name,
    std::vector<google::devtools::cloudtrace::v2::Span> const& spans,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::cloudtrace::v2::BatchWriteSpansRequest request;
  request.set_name(name);
  *request.mutable_spans() = {spans.begin(), spans.end()};
  return connection_->BatchWriteSpans(request);
}

Status TraceServiceClient::BatchWriteSpans(
    google::devtools::cloudtrace::v2::BatchWriteSpansRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchWriteSpans(request);
}

StatusOr<google::devtools::cloudtrace::v2::Span> TraceServiceClient::CreateSpan(
    google::devtools::cloudtrace::v2::Span const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSpan(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_v2
}  // namespace cloud
}  // namespace google
