// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/stitcher/v1/video_stitcher_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_STITCHER_V1_VIDEO_STITCHER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_STITCHER_V1_VIDEO_STITCHER_CONNECTION_H

#include "google/cloud/video/stitcher/v1/internal/video_stitcher_retry_traits.h"
#include "google/cloud/video/stitcher/v1/video_stitcher_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/video/stitcher/v1/video_stitcher_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace video_stitcher_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `VideoStitcherServiceConnection`.
class VideoStitcherServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<VideoStitcherServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `VideoStitcherServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class VideoStitcherServiceLimitedErrorCountRetryPolicy
    : public VideoStitcherServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit VideoStitcherServiceLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  VideoStitcherServiceLimitedErrorCountRetryPolicy(
      VideoStitcherServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : VideoStitcherServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  VideoStitcherServiceLimitedErrorCountRetryPolicy(
      VideoStitcherServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : VideoStitcherServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<VideoStitcherServiceRetryPolicy> clone() const override {
    return std::make_unique<VideoStitcherServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = VideoStitcherServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      video_stitcher_v1_internal::VideoStitcherServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `VideoStitcherServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class VideoStitcherServiceLimitedTimeRetryPolicy
    : public VideoStitcherServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit VideoStitcherServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  VideoStitcherServiceLimitedTimeRetryPolicy(
      VideoStitcherServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : VideoStitcherServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  VideoStitcherServiceLimitedTimeRetryPolicy(
      VideoStitcherServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : VideoStitcherServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<VideoStitcherServiceRetryPolicy> clone() const override {
    return std::make_unique<VideoStitcherServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = VideoStitcherServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      video_stitcher_v1_internal::VideoStitcherServiceRetryTraits>
      impl_;
};

/**
 * The `VideoStitcherServiceConnection` object for `VideoStitcherServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `VideoStitcherServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `VideoStitcherServiceClient`.
 *
 * To create a concrete instance, see `MakeVideoStitcherServiceConnection()`.
 *
 * For mocking, see
 * `video_stitcher_v1_mocks::MockVideoStitcherServiceConnection`.
 */
class VideoStitcherServiceConnection {
 public:
  virtual ~VideoStitcherServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>>
  CreateCdnKey(
      google::cloud::video::stitcher::v1::CreateCdnKeyRequest const& request);

  virtual StreamRange<google::cloud::video::stitcher::v1::CdnKey> ListCdnKeys(
      google::cloud::video::stitcher::v1::ListCdnKeysRequest request);

  virtual StatusOr<google::cloud::video::stitcher::v1::CdnKey> GetCdnKey(
      google::cloud::video::stitcher::v1::GetCdnKeyRequest const& request);

  virtual future<
      StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteCdnKey(
      google::cloud::video::stitcher::v1::DeleteCdnKeyRequest const& request);

  virtual future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>>
  UpdateCdnKey(
      google::cloud::video::stitcher::v1::UpdateCdnKeyRequest const& request);

  virtual StatusOr<google::cloud::video::stitcher::v1::VodSession>
  CreateVodSession(
      google::cloud::video::stitcher::v1::CreateVodSessionRequest const&
          request);

  virtual StatusOr<google::cloud::video::stitcher::v1::VodSession>
  GetVodSession(
      google::cloud::video::stitcher::v1::GetVodSessionRequest const& request);

  virtual StreamRange<google::cloud::video::stitcher::v1::VodStitchDetail>
  ListVodStitchDetails(
      google::cloud::video::stitcher::v1::ListVodStitchDetailsRequest request);

  virtual StatusOr<google::cloud::video::stitcher::v1::VodStitchDetail>
  GetVodStitchDetail(
      google::cloud::video::stitcher::v1::GetVodStitchDetailRequest const&
          request);

  virtual StreamRange<google::cloud::video::stitcher::v1::VodAdTagDetail>
  ListVodAdTagDetails(
      google::cloud::video::stitcher::v1::ListVodAdTagDetailsRequest request);

  virtual StatusOr<google::cloud::video::stitcher::v1::VodAdTagDetail>
  GetVodAdTagDetail(
      google::cloud::video::stitcher::v1::GetVodAdTagDetailRequest const&
          request);

  virtual StreamRange<google::cloud::video::stitcher::v1::LiveAdTagDetail>
  ListLiveAdTagDetails(
      google::cloud::video::stitcher::v1::ListLiveAdTagDetailsRequest request);

  virtual StatusOr<google::cloud::video::stitcher::v1::LiveAdTagDetail>
  GetLiveAdTagDetail(
      google::cloud::video::stitcher::v1::GetLiveAdTagDetailRequest const&
          request);

  virtual future<StatusOr<google::cloud::video::stitcher::v1::Slate>>
  CreateSlate(
      google::cloud::video::stitcher::v1::CreateSlateRequest const& request);

  virtual StreamRange<google::cloud::video::stitcher::v1::Slate> ListSlates(
      google::cloud::video::stitcher::v1::ListSlatesRequest request);

  virtual StatusOr<google::cloud::video::stitcher::v1::Slate> GetSlate(
      google::cloud::video::stitcher::v1::GetSlateRequest const& request);

  virtual future<StatusOr<google::cloud::video::stitcher::v1::Slate>>
  UpdateSlate(
      google::cloud::video::stitcher::v1::UpdateSlateRequest const& request);

  virtual future<
      StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteSlate(
      google::cloud::video::stitcher::v1::DeleteSlateRequest const& request);

  virtual StatusOr<google::cloud::video::stitcher::v1::LiveSession>
  CreateLiveSession(
      google::cloud::video::stitcher::v1::CreateLiveSessionRequest const&
          request);

  virtual StatusOr<google::cloud::video::stitcher::v1::LiveSession>
  GetLiveSession(
      google::cloud::video::stitcher::v1::GetLiveSessionRequest const& request);

  virtual future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
  CreateLiveConfig(
      google::cloud::video::stitcher::v1::CreateLiveConfigRequest const&
          request);

  virtual StreamRange<google::cloud::video::stitcher::v1::LiveConfig>
  ListLiveConfigs(
      google::cloud::video::stitcher::v1::ListLiveConfigsRequest request);

  virtual StatusOr<google::cloud::video::stitcher::v1::LiveConfig>
  GetLiveConfig(
      google::cloud::video::stitcher::v1::GetLiveConfigRequest const& request);

  virtual future<
      StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteLiveConfig(
      google::cloud::video::stitcher::v1::DeleteLiveConfigRequest const&
          request);
};

/**
 * A factory function to construct an object of type
 * `VideoStitcherServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * VideoStitcherServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `VideoStitcherServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::video_stitcher_v1::VideoStitcherServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `VideoStitcherServiceConnection`
 * created by this function.
 */
std::shared_ptr<VideoStitcherServiceConnection>
MakeVideoStitcherServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_stitcher_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_STITCHER_V1_VIDEO_STITCHER_CONNECTION_H
