/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.Parser;

public class FillParser
implements Parser {
    private final Parser elemParser;
    private final Field targetField;

    public FillParser(Parser p, Field field) {
        this.targetField = field;
        this.elemParser = p;
    }

    @Override
    public int getSize(Message src) {
        int size = 0;
        Object arr = ReflectUtil.justGet(src, this.targetField);
        if (arr == null) {
            throw new RuntimeException("array not initialized");
        }
        for (int i = 0; i < Array.getLength(arr); ++i) {
            size += this.elemParser.getSize((Message)Array.get(arr, i));
        }
        return size;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        int s;
        if (frameSizePath == null) {
            throw new AssertionError((Object)"FillParser expects a non-null frameSizePath. Does the message have a @FrameSizePath annotation?");
        }
        int frameSize = ReflectUtil.justGetInt(dstObj, frameSizePath);
        int size = 0;
        Class<?> elemType = this.targetField.getType().getComponentType();
        ArrayList<Message> list = new ArrayList<Message>(10);
        for (int remaining = frameOffset + frameSize - srcBuf.position(); remaining > 0; remaining -= s) {
            Message next = (Message)ReflectUtil.justInstantiate(this.targetField.getType().getComponentType());
            s = this.elemParser.parse(srcBuf, frameOffset, frameObj, next, null);
            size += s;
            list.add(next);
        }
        Object arr = Array.newInstance(elemType, list.size());
        try {
            this.targetField.set(dstObj, list.toArray((Object[])arr));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"cannot access field");
        }
        return size;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message src) {
        int size = 0;
        Object arr = ReflectUtil.justGet(src, this.targetField);
        for (int i = 0; i < Array.getLength(arr); ++i) {
            size += this.elemParser.write(dstBuf, (Message)Array.get(arr, i));
        }
        return size;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        if (frameSizePath == null) {
            throw new AssertionError();
        }
        ReflectUtil.justSetInt(frameObj, frameSizePath, frameSize);
    }

    @Override
    public int getStaticSize() {
        return 0;
    }
}

