/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.Parser;

public class VariableSizeArrayParser
implements Parser {
    private final Field targetField;
    private final Parser elemParser;
    private ReflectUtil.NumField sizeField;

    public VariableSizeArrayParser(Parser elemParser, Field sizeField, Field arrayField) {
        this.targetField = arrayField;
        this.elemParser = elemParser;
        this.sizeField = new ReflectUtil.NumField(sizeField);
    }

    @Override
    public int getSize(Message src) {
        int size = 0;
        Object arr = ReflectUtil.justGet(src, this.targetField);
        if (arr == null) {
            throw new RuntimeException("array not initialized");
        }
        for (int i = 0; i < Array.getLength(arr); ++i) {
            size += this.elemParser.getSize((Message)Array.get(arr, i));
        }
        return size;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        int elemNumber = (int)this.sizeField.get(dstObj);
        Class<?> arrayElementType = this.targetField.getType().getComponentType();
        int size = 0;
        Object arr = Array.newInstance(arrayElementType, elemNumber);
        ReflectUtil.justSet(dstObj, this.targetField, arr);
        for (int i = 0; i < elemNumber; ++i) {
            Message elemObj = (Message)ReflectUtil.justInstantiate(arrayElementType);
            Array.set(arr, i, elemObj);
            size += this.elemParser.parse(srcBuf, frameOffset - size, null, elemObj, null);
        }
        return size;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message src) {
        int size = 0;
        Object arr = ReflectUtil.justGet(src, this.targetField);
        for (int i = 0; i < Array.getLength(arr); ++i) {
            size += this.elemParser.write(dstBuf, (Message)Array.get(arr, i));
        }
        return size;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        int size = Array.getLength(ReflectUtil.justGet(m, this.targetField));
        this.sizeField.set((Object)m, size);
    }

    @Override
    public int getStaticSize() {
        return 0;
    }
}

