/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Ed25519 {
    public static final int b = 256;
    public static final BigInteger q = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564819949");
    private static final BigInteger qm2 = q.subtract(BigInteger.valueOf(2L));
    private static final BigInteger qp3 = q.add(BigInteger.valueOf(3L));
    public static final BigInteger l = new BigInteger("7237005577332262213973186563042994240857116359379907606001950938285454250989");
    private static final BigInteger d = new BigInteger("-4513249062541557337682894930092624173785641285191125241628941591882900924598840740");
    private static final BigInteger I = new BigInteger("19681161376707505956807079304988542015446066515923890162744021073123829784752");
    private static final BigInteger Bx = new BigInteger("15112221349535400772501151409588531511454012693041857206046113283949847762202");
    private static final BigInteger By = new BigInteger("46316835694926478169428394003475163141307993866256225615783033603165251855960");
    public static final Ed25519 B = new Ed25519(Bx.mod(q), By.mod(q));
    private static final BigInteger mask255 = BigInteger.ONE.shiftLeft(255).subtract(BigInteger.ONE);
    BigInteger P0;
    BigInteger P1;

    public Ed25519(BigInteger P0, BigInteger P1) {
        this.P0 = P0;
        this.P1 = P1;
    }

    public static Ed25519 decode(byte[] s) {
        BigInteger y = Ed25519.decodeScalar(s);
        BigInteger x = Ed25519.recoverX(y);
        if ((x.testBit(0) ? 1 : 0) != Ed25519.bit(s, 255)) {
            x = q.subtract(x);
        }
        Ed25519 v = new Ed25519(x, y);
        return v;
    }

    private static int bit(byte[] h, int i) {
        return h[i / 8] >> i % 8 & 1;
    }

    public static BigInteger recoverX(BigInteger y) {
        BigInteger y2 = y.multiply(y);
        BigInteger xx = y2.subtract(BigInteger.ONE).multiply(Ed25519.inv(d.multiply(y2).add(BigInteger.ONE)));
        BigInteger x = xx.modPow(qp3.divide(BigInteger.valueOf(8L)), q);
        if (!x.multiply(x).subtract(xx).mod(q).equals(BigInteger.ZERO)) {
            x = x.multiply(I).mod(q);
        }
        if (!x.mod(BigInteger.valueOf(2L)).equals(BigInteger.ZERO)) {
            x = q.subtract(x);
        }
        return x;
    }

    private static BigInteger inv(BigInteger x) {
        return x.modPow(qm2, q);
    }

    public Ed25519 add(Ed25519 other) {
        BigInteger x1 = this.P0;
        BigInteger y1 = this.P1;
        BigInteger x2 = other.P0;
        BigInteger y2 = other.P1;
        BigInteger dtemp = d.multiply(x1).multiply(x2).multiply(y1).multiply(y2);
        BigInteger x3 = x1.multiply(y2).add(x2.multiply(y1)).multiply(Ed25519.inv(BigInteger.ONE.add(dtemp)));
        BigInteger y3 = y1.multiply(y2).add(x1.multiply(x2)).multiply(Ed25519.inv(BigInteger.ONE.subtract(dtemp)));
        return new Ed25519(x3.mod(q), y3.mod(q));
    }

    public boolean isIdentity() {
        return this.P0.mod(q).equals(BigInteger.ZERO) && this.P1.mod(q).equals(BigInteger.ONE);
    }

    public Ed25519 scalarmult(BigInteger e) {
        if (e.equals(BigInteger.ZERO)) {
            return new Ed25519(BigInteger.ZERO, BigInteger.ONE);
        }
        Ed25519 Q = this.scalarmult(e.shiftRight(1));
        Q = Q.add(Q);
        if (e.testBit(0)) {
            Q = Q.add(this);
        }
        return Q;
    }

    public static BigInteger decodeScalar(byte[] s) {
        if (s.length != 32) {
            throw new AssertionError();
        }
        byte[] out = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            out[i] = s[s.length - 1 - i];
        }
        return new BigInteger(1, out).and(mask255);
    }

    public static byte[] encodeScalar(BigInteger n) {
        byte[] in = n.and(mask255).toByteArray();
        if (in.length > 32) {
            throw new AssertionError((Object)("size too big: " + in.length));
        }
        byte[] full = new byte[32];
        for (int i = 0; i < in.length; ++i) {
            full[in.length - i - 1] = in[i];
        }
        return full;
    }

    public byte[] encode() {
        byte[] out = Ed25519.encodeScalar(this.P1);
        int n = out.length - 1;
        out[n] = (byte)(out[n] | (this.P0.testBit(0) ? -128 : 0));
        return out;
    }

    static BigInteger Hint(byte[] m) {
        MessageDigest sha512;
        try {
            sha512 = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm required but not provided");
        }
        byte[] h = sha512.digest(m);
        for (int i = 0; i < 32; ++i) {
            byte tmp = h[i];
            h[i] = h[63 - i];
            h[63 - i] = tmp;
        }
        return new BigInteger(1, h);
    }

    public boolean isOnCurve() {
        BigInteger x = this.P0;
        BigInteger y = this.P1;
        BigInteger xx = x.multiply(x);
        BigInteger yy = y.multiply(y);
        BigInteger dxxyy = d.multiply(yy).multiply(xx);
        return xx.negate().add(yy).subtract(BigInteger.ONE).subtract(dxxyy).mod(q).equals(BigInteger.ZERO);
    }

    public String toString() {
        return "(" + this.P0.toString() + ", " + this.P1.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ed25519 ed25519 = (Ed25519)o;
        if (!this.P0.equals(ed25519.P0)) {
            return false;
        }
        return this.P1.equals(ed25519.P1);
    }

    public int hashCode() {
        int result = this.P0.hashCode();
        result = 31 * result + this.P1.hashCode();
        return result;
    }
}

