/* Machine-dependent ELF indirect relocation inline functions.
   SPARC 32-bit version.
   Copyright (C) 2010 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#ifndef _DL_IREL_H
#define _DL_IREL_H

#include <stdio.h>
#include <unistd.h>
#include <dl-plt.h>
#include <ldsodefs.h>

#define ELF_MACHINE_IRELA	1

static inline Elf32_Addr
__attribute ((always_inline))
elf_ifunc_invoke (Elf32_Addr addr)
{
  return ((Elf32_Addr (*) (int)) (addr)) (GLRO(dl_hwcap));
}

static inline void
__attribute ((always_inline))
elf_irela (const Elf32_Rela *reloc)
{
  unsigned int r_type = ELF32_R_TYPE (reloc->r_info);

  if (__builtin_expect (r_type == R_SPARC_IRELATIVE, 1))
    {
      Elf32_Addr *const reloc_addr = (void *) reloc->r_offset;
      Elf32_Addr value = elf_ifunc_invoke(reloc->r_addend);
      *reloc_addr = value;
    }
  else if (__builtin_expect (r_type == R_SPARC_JMP_IREL, 1))
    {
      Elf32_Addr *const reloc_addr = (void *) reloc->r_offset;
      Elf32_Addr value = elf_ifunc_invoke(reloc->r_addend);

      sparc_fixup_plt (reloc, reloc_addr, value, 0, 1);
    }
  else if (r_type == R_SPARC_NONE)
    ;
  else
    __libc_fatal ("unexpected reloc type in static binary");
}

#endif /* dl-irel.h */
