/*
    window.arguments[0]  - Datasource: Permanent datasource
    window.arguments[1]  - Resource: Root node for above datasource
    window.arguments[2]  - Function: To call when the input has been validated and accepted
    window.arguments[3]  - int: integer to be used as first argument to the function above
    window.arguments[4]  - String: title of the menu to be customized - used in title
    window.arguments[5]  - [optional group 1] String: text to put in the name box
    window.arguments[6]  - [optional group 1] String: text to put in the url box
    window.arguments[7]  - [optional group 1] String: text which should be selected in the "insert before" menulist.
    window.arguments[8]  - [optional group 2] Bool: If true, disables the name textbox
    window.arguments[9]  - [optional group 3] Bool: If true, disables the url-id textbox
    window.arguments[10] - [optional group 4] Bool: If true, disables the insert before menulist
*/

var g_dsource;
var g_rootNode;
var g_callbackFunction;
var g_callbackInt;
var g_requestedURL;
var g_requestedTitle;

function initDialog()
{
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var RDFCUtils = Components.classes['@mozilla.org/rdf/container-utils;1'].getService(Components.interfaces.nsIRDFContainerUtils);
    var stringRes = document.getElementById("stringRes");

    if(window.arguments.length < 5)
    {
        alert("Error in additem.js: Not enough arguments supplied!");
        window.close();
        return;
    }
    
    g_dsource = window.arguments[0];
    g_rootNode = window.arguments[1];
    g_callbackFunction = window.arguments[2];
    g_callbackInt = parseInt(window.arguments[3]);
    document.getElementById("additem-dialog").setAttribute("title", 
                            stringRes.getString("aiDialogTitlePre") + " " + window.arguments[4] + " " 
                                + stringRes.getString("aiDialogTitlePost"));
    
    
    var insertBeforeText = "*";
    var disable = false;
    var nameTextbox = document.getElementById("name-textbox");
    var idurlTextbox = document.getElementById("idurl-textbox");
    var insertBeforeList = document.getElementById("insertbefore-list");
    
    if(window.arguments.length > 5)
    {
        nameTextbox.setAttribute("value", window.arguments[5]);
        idurlTextbox.setAttribute("value", window.arguments[6]);
        insertBeforeText = window.arguments[7];
    }
    
    if(window.arguments.length > 8)
    {
        nameTextbox.disabled = window.arguments[8];
    }
    
    if(window.arguments.length > 9)
    {
        // Perhaps a broadcaster-observer type would be more elegant, but as the state needs to be synchronized only in this one 
        // place, it hardly seems necessary
        idurlTextbox.disabled = window.arguments[9];
        document.getElementById("geturl-button").disabled = window.arguments[9];
    }
    
    if(window.arguments.length > 10)
    {
        insertBeforeList.disabled = window.arguments[10];
    }
    
    
    var entries = RDFCUtils.MakeSeq(g_dsource, g_rootNode).GetElements();
    var popup = document.getElementById("insertbefore-popup");
    var insertBeforeIndex = -1;
    var i = 0;
    var numSeparators = 0;
    
    while(entries.hasMoreElements())
    {
        var entry = entries.getNext();
        var txt;
        
        entry = entry.QueryInterface(Components.interfaces.nsIRDFResource);
        
        if(entry.Value.indexOf("separator") != -1)
        {
            numSeparators++;
            txt = "separator"+numSeparators;
        }
        else
        {
            txt = g_dsource.GetTarget(entry, RDF.GetResource("http://www.3dbuzz.com/rdf#name"), true);
            txt = txt.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        }

        var menuitem = document.createElement("menuitem");
        menuitem.setAttribute("label", txt);
        popup.appendChild(menuitem);
        
        if(txt == insertBeforeText)
            insertBeforeIndex = i;
        i++;
    }
    
    if(i == 0)
    {
        var menuitem = document.createElement("menuitem");
        menuitem.setAttribute("label", "No items");
        menuitem.setAttribute("disabled", "true");
        popup.appendChild(menuitem);
    }
    
    insertBeforeList.selectedIndex = insertBeforeIndex+1; //since index 0 is the "Nothing" item
}

function isValid()
{
    var nameBox = document.getElementById("name-textbox");
    var idurlBox = document.getElementById("idurl-textbox");
    
    if(nameBox.value.length < 1)
    {
        /*
            opener - menu customization dlg
            opener.opener - options dlg
            opener.opener.opener - toolbar
        */
        opener.opener.opener.MsgBox(document.getElementById("stringRes").getString("aiAlertMustEnterName"));
        return nameBox;
    }
    
    return null;
}

function save()
{
    var nameBox = document.getElementById("name-textbox");
    var idurlBox = document.getElementById("idurl-textbox");
    var insertBefore = document.getElementById("insertbefore-list");
    var insertBeforeText;
    
    if(insertBefore.selectedIndex < 1)
        insertBeforeText = "";
    else
        insertBeforeText = insertBefore.selectedItem.getAttribute("label");
    
    g_callbackFunction(g_callbackInt, nameBox.value, idurlBox.value, insertBeforeText);
}

function onOK()
{
    var invalidComp = isValid();
    
    if(invalidComp != null)
    {
        invalidComp.focus();
        return false;
    }
    
    save();
    return true;
}

function requestedURLCallback(url, urlTitle)
{
    g_requestedURL = url;
    g_requestedTitle = urlTitle;
}

function fillTextboxWithURL(textbox, titleTextbox, evnt)
{
    var browser = opener.opener.opener.document.getElementById("content");    
    g_requestedURL = null;
    g_requestedTitle = null;

    window.openDialog("chrome://3dbuzz/content/geturl.xul","getURL", 
                        "chrome,centerscreen,modal=yes,dialog=yes",
                        browser.mTabContainer.childNodes,
                        browser.selectedTab,
                        browser.mPanelContainer.childNodes,
                        requestedURLCallback,
                        evnt
                        );
          
    if(g_requestedURL)
        textbox.value = g_requestedURL;
        
    if(titleTextbox && g_requestedTitle)
        titleTextbox.value = g_requestedTitle;
        
    textbox.focus();
}