/*
    File: options.js
    
    Written to work with the 3DBuzz Toolbar for Mozilla.
    
    Author: Keith Athaide
*/

var g_cfAllOff = 0;
var g_requestedURL; // Used by fillTextboxWithURL() and requestedURLCallback()
var g_requestedTitle; // Used by fillTextboxWithURL() and requestedURLCallback()
var g_stringRes;


function onInit()
{
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var dsource = RDF.GetDataSource("rdf:local-store");
    var nameRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#name");
    var urlRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#url");
    var displayRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#display");
    var tempVar;

    // Initialize reference to the string resource
    g_stringRes = document.getElementById("stringRes");
    
    //Set title
    var dlg = document.getElementById("options-dialog");
    //dlg.setAttribute("title", "3DBuzz Toolbar (v"+opener.VERSION+") Options");
    dlg.setAttribute("title", g_stringRes.getString("dialogTitlePre") + " (v"+opener.VERSION+") " 
                                    + g_stringRes.getString("dialogTitlePost"));
        
    for(var i = 1; i <= 4; i++)
    {
        var resource = RDF.GetResource("http://www.3dbuzz.com/customforum"+i);
        
        var txt = dsource.GetTarget(resource, nameRDF, true);
        if(txt)
            txt = txt.QueryInterface(Components.interfaces.nsIRDFLiteral).Value                                    
        else
            txt = g_stringRes.getString("cfNamePrefix") +" "+i;
            
        document.getElementById("cf"+i+"name").value = txt;
        
        txt = dsource.GetTarget(resource, urlRDF, true);
        if(txt)
            txt = txt.QueryInterface(Components.interfaces.nsIRDFLiteral).Value                                    
        else
            txt = "http://www.3dbuzz.com";
            
        document.getElementById("cf"+i+"url").value = txt;
        
        // Initialize the checkboxes and disable the name and url fields if necessary
        var res = dsource.GetTarget(resource, displayRDF, true);
        var check = 1;
        if(res)
            check = parseInt(res.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
        
        document.getElementById("cf"+i+"-checkbox").checked = check;
        
        if(check == 0)
        {
            document.getElementById("cf"+i+"name").disabled = true;
            document.getElementById("cf"+i+"url").disabled = true;
        }
    }
        
    // Now initialize the maximum number of searches box
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/maxSearches"), nameRDF, true);
    if(tempVar)
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    else
        tempVar = opener.g_maxSearches;
    document.getElementById("maxsearch-textbox").value = tempVar;
    
    // Initialize the state of autocomplete
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/autocomplete"), nameRDF, true);
    if(tempVar)
        tempVar = parseInt(tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    else
        tempVar = parseInt(opener.g_autocompleteState);
        
    if(tempVar == 1)
        document.getElementById("ac-checkbox").checked = true;
    else
        document.getElementById("ac-checkbox").checked = false;

    // Show all warnings
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/showWarnings"), nameRDF, true);
    if(tempVar)
        tempVar = parseInt(tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    else
        tempVar = 1;
    setCheckbox("showWarnings-checkbox", tempVar);
 
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/shouldAddSpaces"), nameRDF, true);
    if(tempVar)
        tempVar = parseInt(tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    else
        tempVar = parseInt(opener.g_shouldAddSpaces);
        
    if(tempVar == 1)
    {
        setCheckbox("spaces-checkbox", true);
    }
    else
    {
        setCheckbox("spaces-checkbox", false);
        document.getElementById("spaces-textbox").disabled = true;
    }
    
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/spaces"), nameRDF, true);
    if(tempVar)
        tempVar = parseInt(tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    else
        tempVar = opener.g_spacesToAdd.length;
    
    document.getElementById("spaces-textbox").value = tempVar;


    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/defaultServer"), nameRDF, true);
    if(tempVar)
        tempVar = parseInt(tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    else
        tempVar = opener.DEFAULT_SERVER;
    document.getElementById("defaultserver-textbox").value = "sv" + tempVar;
    
    // Load IRC options
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/ircOption"), nameRDF, true);
    if(tempVar)
        tempVar = parseInt(tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    else
        tempVar = 0;
    var rg = document.getElementById("irc-radiogroup");
    //rg.selectedIndex = irc;
    setIRCCurSel(tempVar);
    onIRCOptionSelect(rg);
    
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/ircaddress"), nameRDF, true);
    if(tempVar)
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    else
        tempVar = "irc://irc.3dbuzz.com/3dbuzz";
    document.getElementById("ircprotocol-textbox").value = tempVar;
    
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/ircclient"), nameRDF, true);
    if(tempVar)
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    else
        tempVar = "";
    document.getElementById("ircclient-textbox").value = tempVar;
        
    // Initialize check boxes for button visibility
    setCheckbox("3dbuzz-checkbox", isButtonVisible("3dbuzz-button"));
    setCheckbox("openirc-checkbox", isButtonVisible("openirc-button"));
    setCheckbox("forumjump-checkbox", isButtonVisible("forumjump-button"));
    setCheckbox("onlineclass-checkbox", isButtonVisible("onlineclass-button"));
    setCheckbox("viewnewposts-checkbox", isButtonVisible("viewnewposts-button"));
    setCheckbox("searchbox-checkbox", isButtonVisible("search-box"));
    setCheckbox("reload-checkbox", isButtonVisible("reload-3dbuzzbutton"));
    setCheckbox("frameoperations-checkbox", isButtonVisible("frameoperations-button"));
    setCheckbox("options-checkbox", isButtonVisible("options-button"));
    setCheckbox("fullscreen-checkbox", opener.document.getElementById("3dbuzz-toolbar").getAttribute("fullscreentoolbar"));
    
    doCFChecks(true);
}

function setCheckbox(sName, state) {
    document.getElementById(sName).checked = state;
}

function isButtonVisible(sName)
{
    return (opener.document.getElementById(sName).getAttribute("class") == "tbbutton") ||
                (opener.document.getElementById(sName).getAttribute("class") == "searchbox");
}

function onSpacesCheckbox()
{
    var check = document.getElementById("spaces-checkbox").checked;
    document.getElementById("spaces-textbox").disabled = !check;
}

function onCFCheckBox(checkboxNum, checkbox)
{
    document.getElementById("cf"+checkboxNum+"name").disabled = !checkbox.checked;
    document.getElementById("cf"+checkboxNum+"url").disabled = !checkbox.checked;
    doCFChecks(false);
}
    
function doCFChecks(bSetAllOff)
{
    // check all the checkboxes. If all are unchecked, uncheck the "show custom forum checkbox" and disable it.
    var displayedItems = 0;
    for(var i = 1; i <= 4; i++)
    {
        if(document.getElementById("cf"+i+"-checkbox").checked)
            displayedItems++;
    }
    
    if(displayedItems == 0)
    {
        setCheckbox("customforum-checkbox", false);
        document.getElementById("customforum-checkbox").disabled = true;
        
        if(bSetAllOff)
            g_cfAllOff = 1;
    }
    else
    {
        document.getElementById("customforum-checkbox").disabled = false;
        
        if(g_cfAllOff)
            setCheckbox("customforum-checkbox", true);
        else
            setCheckbox("customforum-checkbox", isButtonVisible("customforum-button"));
    }
}

function adjustCFButton()
{
    var check = document.getElementById("cf"+opener.g_curCustomForum+"-checkbox").checked;
    if(!check)
    {
        //find first displayed custom forum and set g_curCustomForum to that number
        for(var i = 1; i <= 4; i++)
        {
            if(document.getElementById("cf"+i+"-checkbox").checked)
            {
                opener.saveSetting("http://www.3dbuzz.com/settings/curCustomForum", i, opener.g_curCustomForum);
                opener.g_curCustomForum = i;
                break;
            }
        }
        
        // Don't worry about nothing being found, as the button will be hidden anyway
    }
}

function isValid()
{
    var comp;
    var i;
    
    //check custom forums
    for(i = 1; i <= 4; i++)
    {
        comp = document.getElementById("cf"+i+"name");
        if(comp.value.length < 1)
        {
            opener.MsgBox(g_stringRes.getString("alertMustEnterCFNamePre") + " "+i+ g_stringRes.getString("alertMustEnterCFNamePost"));
            return comp;
        }
        
        comp = document.getElementById("cf"+i+"url");
        if(comp.value.length < 1)
        {
            opener.MsgBox(g_stringRes.getString("alertMustEnterCFURLPre") + " "+i+ g_stringRes.getString("alertMustEnterCFURLPost"));
            return comp;
        }
    }
    
    comp = document.getElementById("maxsearch-textbox");
    if(comp.value.length < 1)
    {
        opener.MsgBox(g_stringRes.getString("alertMustEnterNumberOfSearches"));
        return comp;
    }
    
    if(isNaN(comp.value))
    {
        opener.MsgBox(g_stringRes.getString("alertNumberOfSearchesNumerical"));
        return comp;
    }
    
    comp = document.getElementById("defaultserver-textbox");
    if(comp.value.length < 1)
    {
        opener.MsgBox(g_stringRes.getString("alertMustEnterDefaultServer"));
        return comp;
    }
    
    if( (comp.value.length == 1 && (isNaN(comp.value) || parseInt(comp.value) < 1 || parseInt(comp.value) > 3)) || 
           (comp.value.length == 3 && (comp.value[0] != "s" || comp.value[1] != "v" || 
                                    isNaN(comp.value[2]) || parseInt(comp.value[2]) < 1 || parseInt(comp.value[2]) > 3)) ||
           comp.value.length == 2 || comp.value.length > 3)
    {
        opener.MsgBox(g_stringRes.getString("alertInvalidServer"));
        return comp;
    }
    
    if(document.getElementById("spaces-checkbox").checked)
    {
        comp = document.getElementById("spaces-textbox");
        if(comp.value.length < 1)
        {
            opener.MsgBox(g_stringRes.getString("alertMustEnterNumberOfSpaces"));
            return comp;
        }
        
        if(isNaN(comp.value))
        {
            opener.MsgBox(g_stringRes.getString("alertNumberOfSpacesNumerical"));
            return comp;
        }
    }
    
    // Check IRC options
    var curSel = getIRCCurSel();
    switch(curSel)
    {
        case 1:
            comp = document.getElementById("ircprotocol-textbox");
            if(comp.value.length < 1)
            {
                opener.MsgBox(g_stringRes.getString("alertMustEnterIRCAddress"));
                return comp;
            }
            
            if(comp.value.indexOf("irc://") != 0)
            {
                opener.MsgBox(g_stringRes.getString("alertIRCAddressStart"));
                return comp;
            }
        break;
        
        case 2:
            comp = document.getElementById("ircclient-textbox");
            if(comp.value.length < 1)
            {
                opener.MsgBox(g_stringRes.getString("alertMustEnterClientPath"));
                return comp;
            }
            
            var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            
            if(aFile)
            {
                var initialised = false;
                
                try
                {
                    aFile.initWithPath(comp.value);
                    initialised = true;
                }
                catch(e){}
                
                if(!initialised || !aFile.exists())
                {
                    opener.MsgBox(g_stringRes.getString("alertInvalidClientPath"));
                    return comp;
                }
                
                if(!aFile.isFile())
                {
                    opener.MsgBox(g_stringRes.getString("alertPathIsDirectory"));
                    return comp;
                }
            }
        break;
    }
    
    return null;
}

function save()
{
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var dsource = RDF.GetDataSource("rdf:local-store");
    var nameRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#name");
    var urlRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#url");
    var displayRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#display");
    var node;
    var tempVar;

    for(var i = 1; i <= 4; i++)
    {
        var comp = document.getElementById("cf"+i+"name");
        node = RDF.GetResource("http://www.3dbuzz.com/customforum"+i);
        var cfName = dsource.GetTarget(node, nameRDF, true);
        if(cfName)
        {
            cfName = cfName.QueryInterface(Components.interfaces.nsIRDFLiteral);
            dsource.Unassert(node, nameRDF, cfName, true);
        }
        
        cfName = RDF.GetLiteral(comp.value);
        dsource.Assert(node, nameRDF, cfName, true);
        
        
        
        comp = document.getElementById("cf"+i+"url");
        var cfURL = dsource.GetTarget(node, urlRDF, true);
        if(cfURL)
        {
            cfURL = cfURL.QueryInterface(Components.interfaces.nsIRDFLiteral);
            dsource.Unassert(node, urlRDF, cfURL, true);
        }
        
        cfURL = RDF.GetLiteral(comp.value);
        dsource.Assert(node, urlRDF, cfURL, true);
        
        
        
        comp = document.getElementById("cf"+i+"-checkbox");
        var cfDisp = dsource.GetTarget(node, displayRDF, true);
        if(cfDisp)
        {
            cfDisp = cfDisp.QueryInterface(Components.interfaces.nsIRDFLiteral);
            dsource.Unassert(node, displayRDF, cfDisp, true);
        }
        cfDisp = RDF.GetLiteral(comp.checked?1:0);
        dsource.Assert(node, displayRDF, cfDisp, true);
    }
    
    // Save the maximum number of searches
    node = RDF.GetResource("http://www.3dbuzz.com/settings/maxSearches");
    tempVar = dsource.GetTarget(node, nameRDF, true);
    if(tempVar)
    {
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF, tempVar, true);
    }
    tempVar = RDF.GetLiteral(document.getElementById("maxsearch-textbox").value);
    dsource.Assert(node, nameRDF, tempVar, true);
    
    // Save the default server
    node = RDF.GetResource("http://www.3dbuzz.com/settings/defaultServer");
    tempVar = dsource.GetTarget(node, nameRDF, true);
    if(tempVar)
    {
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF, tempVar, true);
    }
    var val = document.getElementById("defaultserver-textbox").value;
    if(val.length == 1)
        tempVar = parseInt(val);
    else if(val.length == 3)
        tempVar = parseInt(val[2]);
    tempVar = RDF.GetLiteral(tempVar);
    dsource.Assert(node, nameRDF, tempVar, true);
    
    // Save the state of autocomplete
    node = RDF.GetResource("http://www.3dbuzz.com/settings/autocomplete");
    tempVar = dsource.GetTarget(node, nameRDF, true);
    if(tempVar)
    {
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF, tempVar, true);
    }
    tempVar = RDF.GetLiteral(document.getElementById("ac-checkbox").checked?1:0);
    dsource.Assert(node, nameRDF, tempVar, true);

    // Save state of showWarnings
    node = RDF.GetResource("http://www.3dbuzz.com/settings/showWarnings");
    tempVar = dsource.GetTarget(node, nameRDF, true);
    if(tempVar)
    {
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF,tempVar, true);
    }
    tempVar = RDF.GetLiteral(document.getElementById("showWarnings-checkbox").checked?1:0);
    dsource.Assert(node, nameRDF, tempVar, true);
     
    // Save state of shouldAddSpaces
    node = RDF.GetResource("http://www.3dbuzz.com/settings/shouldAddSpaces");
    tempVar = dsource.GetTarget(node, nameRDF, true);
    if(tempVar)
    {
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF, tempVar, true);
    }
    tempVar = RDF.GetLiteral(document.getElementById("spaces-checkbox").checked?1:0);
    dsource.Assert(node, nameRDF, tempVar, true);
    
    if(document.getElementById("spaces-checkbox").checked == true)
    {
        node = RDF.GetResource("http://www.3dbuzz.com/settings/spaces");
        tempVar = dsource.GetTarget(node, nameRDF, true);
        if(tempVar)
        {
            tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
            dsource.Unassert(node, nameRDF, tempVar, true);
        }
        tempVar = RDF.GetLiteral(document.getElementById("spaces-textbox").value);
        dsource.Assert(node, nameRDF, tempVar, true);
    }
    
    if(document.getElementById("fullscreen-checkbox").checked == true)
        opener.document.getElementById("3dbuzz-toolbar").setAttribute("fullscreentoolbar", "true");
    else
        opener.document.getElementById("3dbuzz-toolbar").setAttribute("fullscreentoolbar", "false");
    
    // Save IRC Options
    node = RDF.GetResource("http://www.3dbuzz.com/settings/ircOption");
    tempVar = dsource.GetTarget(node, nameRDF, true);
    if(tempVar)
    {
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF, tempVar, true);
    }
    tempVar = getIRCCurSel();
    dsource.Assert(node, nameRDF, RDF.GetLiteral(tempVar), true);
    
    switch(tempVar)
    {
        case 1:
            node = RDF.GetResource("http://www.3dbuzz.com/settings/ircaddress");
            tempVar = dsource.GetTarget(node, nameRDF, true);
            if(tempVar)
            {
                tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
                dsource.Unassert(node, nameRDF, tempVar, true);
            }
            tempVar = RDF.GetLiteral(document.getElementById("ircprotocol-textbox").value);
            dsource.Assert(node, nameRDF, tempVar, true);
        break;
        
        case 2:
            node = RDF.GetResource("http://www.3dbuzz.com/settings/ircclient");
            tempVar = dsource.GetTarget(node, nameRDF, true);
            if(tempVar)
            {
                tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
                dsource.Unassert(node, nameRDF, tempVar, true);
            }
            tempVar = RDF.GetLiteral(document.getElementById("ircclient-textbox").value);
            dsource.Assert(node, nameRDF, tempVar, true);
        break;
    }
        
    // Write button visibility
    setButtonVisibility(dsource, "3dbuzz-button", "3dbuzz-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "openirc-button", "openirc-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "customforum-button", "customforum-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "forumjump-button", "forumjump-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "onlineclass-button", "onlineclass-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "viewnewposts-button", "viewnewposts-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "search-box", "searchbox-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "reload-3dbuzzbutton", "reload-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "frameoperations-button", "frameoperations-checkbox", RDF, nameRDF);
    setButtonVisibility(dsource, "options-button", "options-checkbox", RDF, nameRDF);
    
    dsource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
}

function setButtonVisibility(dsource, buttonName, checkboxName, RDF, nameRDF)
{
    var node = RDF.GetResource("http://www.3dbuzz.com/buttonvisibility/"+buttonName);
    var val;
    
    if(document.getElementById(checkboxName).checked == true)
        val = RDF.GetLiteral('1');
    else
        val = RDF.GetLiteral('0');
        
    var prevVal = dsource.GetTarget(node, nameRDF, true);
    if(prevVal)
    {
        prevVal = prevVal.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF, prevVal, true);
    }
    dsource.Assert(node, nameRDF, val, true);
}

function onOK()
{
    var invalidComp = isValid();
    if(invalidComp != null)
    {
        invalidComp.focus();
        return false;
    }
 
    save();
    opener.LoadSettings();
    adjustCFButton();
    opener.adjustRecentSearchList();
    opener.changeCustomForumText();
    opener.changeForumJumpText();
    opener.changeOnlineClassText();
    opener.changeSearchText();
    window.close();
    return true;
}

function onCustomizeFrameLayout()
{
    window.openDialog("chrome://3dbuzz/content/frameLayout.xul", "frameLayoutCust",
                        "chrome,centerscreen,modal=yes,dialog=yes,resizable=no");
}

function onMouseConfig()
{
    window.openDialog("chrome://3dbuzz/content/mouseConfig.xul", "mouseConfig",
                        "chrome,centerscreen,modal=yes,dialog=yes,resizable=no");
}

function onCustomizeOC()
{
    window.openDialog("chrome://3dbuzz/content/menuCustomization.xul","ocCust", 
                        "chrome,centerscreen,modal=yes,dialog=yes,resizable=yes",
                        "chrome://3dbuzz/content/3dbuzz.rdf",
                        "http://www.3dbuzz.com/onlineclasses",
                        "http://www.3dbuzz.com/additional/onlineclasses",
                        "http://www.3dbuzz.com/additional/onlineclass",
                        "http://www.3dbuzz.com/rdf#url",
                        "Online Class"
                        );
}

function onCustomizeFJ()
{
    window.openDialog("chrome://3dbuzz/content/menuCustomization.xul","ocCust", 
                        "chrome,centerscreen,modal=yes,dialog=yes,resizable=yes",
                        "chrome://3dbuzz/content/3dbuzz.rdf",
                        "http://www.3dbuzz.com/forumjump",
                        "http://www.3dbuzz.com/additional/forumjump",
                        "http://www.3dbuzz.com/additional/forum",
                        "http://www.3dbuzz.com/rdf#url",
                        "Forum Jump"
                        );
}

function requestedURLCallback(url, urlTitle)
{
    g_requestedURL = url;
    g_requestedTitle = urlTitle;
}

function fillTextboxWithURL(textbox, titleTextbox, evnt)
{
    var browser = opener.document.getElementById("content");    
    g_requestedURL = null;
    g_requestedTitle = null;

    window.openDialog("chrome://3dbuzz/content/geturl.xul","getURL", 
                        "chrome,centerscreen,modal=yes,dialog=yes",
                        browser.mTabContainer.childNodes,
                        browser.selectedTab,
                        browser.mPanelContainer.childNodes,
                        requestedURLCallback,
                        evnt
                        );
          
    if(g_requestedURL)
        textbox.value = g_requestedURL;
        
    if(titleTextbox && g_requestedTitle)
        titleTextbox.value = g_requestedTitle;
        
    textbox.focus();
}

/*
    This function is necessary as a bug or feature in Firefox reverses the indices of the radio buttons
*/
function getIRCCurSel()
{
    var jR = document.getElementById("java-radio");
    var pR = document.getElementById("protocol-radio");
    var cR = document.getElementById("client-radio");
    
    if(jR.selected)
        return 0;
    else if(pR.selected)
        return 1;
    else if(cR.selected)
        return 2;
        
    return null;
}

function setIRCCurSel(cur)
{
    var jR = document.getElementById("java-radio");
    var pR = document.getElementById("protocol-radio");
    var cR = document.getElementById("client-radio");
    var rg = document.getElementById("irc-radiogroup");
    
    // An array would be elegant
    switch(cur)
    {
        case 0:
            rg.selectedItem = jR;
            break;
        
        case 1:
            rg.selectedItem = pR;
            break;
        
        case 2:
            rg.selectedItem = cR;
            break;
    }
}

function onIRCOptionSelect(radiogroup)
{
    var cur = getIRCCurSel();//radiogroup.selectedIndex;
    var pBox = document.getElementById("ircprotocol-textbox");
    var cBox = document.getElementById("ircclient-textbox");
    var cButton = document.getElementById("ircclient-browse-button");
    
    switch(cur)
    {
        case 0:
            pBox.disabled = true;
            cBox.disabled = true;
            cButton.disabled = true;
        break;
        
        case 1:
            pBox.disabled = false;
            cBox.disabled = true;
            cButton.disabled = true;
        break;
        
        case 2:
            pBox.disabled = true;
            cBox.disabled = false;
            cButton.disabled = false;
        break;
    }
}

function onBrowseForIRCClient()
{
    var picker = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    picker.init(window, "Locate IRC Client", picker.modeOpen);
    
    if(navigator.platform == "Win32")
        picker.appendFilter("Programs", "*.exe");
    else
        picker.appendFilters(Components.interfaces.nsIFilePicker.filterAll);
    
    if(picker.show() == picker.returnOK && picker.file)
    {
        document.getElementById("ircclient-textbox").value = picker.file.path;
    }
}