/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;

namespace LocaleInpector
{

internal abstract class Config2
{


public static     Config2                    Current;
protected         Dictionary<string, string> m_contentIni;
private readonly  DateTime                   m_startDate = DateTime.UtcNow;


public Config2()
{
    Current = this;
    System.Threading.Thread t = System.Threading.Thread.CurrentThread;
    t.CurrentCulture = System.Globalization.CultureInfo.InvariantCulture;

    m_contentIni = new Dictionary<string, string>();
    this.SetIniDefault("hidden", "out", "");
    this.SetIniDefault("hidden", "escapes.unicode", "false");
    this.SetIniDefault("hidden", "escapes.mt", "true");
}


public abstract bool InitIni();


protected void SetIniDefault(string section, string key, string value)
{
    if (key == "out") {
        value = value.Replace(System.IO.Path.DirectorySeparatorChar, '.');
    }
    string sk = section + "->" + key;
    m_contentIni[sk] = value;
}


public string GetPref(string name)
{
    string key = "cmd-line->" + name;
    if (m_contentIni.ContainsKey(key)) {
        return m_contentIni[key];
    }

    key = "hidden->" + name;
    if (m_contentIni.ContainsKey(key)) {
        return m_contentIni[key];
    }

    return string.Empty;
}


public static string FixDirPath(string path)
{
    return System.IO.Path.GetFullPath(FixDirPathCore(path));
}


private static string FixDirPathCore(string path)
{
    if (path.Length == 0) {
        return System.IO.Path.DirectorySeparatorChar.ToString();
    }
    if (path[path.Length - 1] == System.IO.Path.DirectorySeparatorChar) {
        return path;
    }
    return path + System.IO.Path.DirectorySeparatorChar.ToString();
}


public string ValidateDir(string type)
{
    string module = "dir3";

    string name = module + "->" + type;
    if (m_contentIni.ContainsKey(name) == false) {
        Output.Write(@"[ERROR] """ + type + @""" entry not declared in ini file.");
        return null;
    }
    string path = m_contentIni[name];
    if (path.Length == 0) {
        Output.Write(@"[ERROR] """ + type + @""" not declared in ini file.");
        return null;
    }
    path = FixDirPath(path);

    if (BPIO.IsDir(path) == false) {
        Output.Write("[NOT FOUND] " + path);
        return null;
    }

    Output.Write(path);
    return path;
}

/*
public void Start()
{
    Output.WriteLine(m_startDate.ToString("u") + " (UTC)");
}
*/


public string Elapsed
{
    get {
        return (DateTime.UtcNow - m_startDate).TotalSeconds.ToString("n1") + "s";
    }
}


public List<string> GetOptions()
{
    List<string> d = new List<string>();

    Dictionary<string, string>.Enumerator translatedKeyNames = m_contentIni.GetEnumerator();
    while (translatedKeyNames.MoveNext()) {
        string[] x = translatedKeyNames.Current.Key.Split('>');
        if (x[0] != "cmd-line-") {
            continue;
        }
        switch (translatedKeyNames.Current.Value) {
            case "true":
                d.Add("/" + x[1] + "+");
                break;
            case "false":
                d.Add("/" + x[1] + "-");
                break;
            default:
                string c = translatedKeyNames.Current.Value;
                if (c.IndexOf(" ") > -1) {
                    d.Add("/" + x[1] + ":\"" + c + "\"");
                } else {
                    d.Add("/" + x[1] + ":" + c);
                }
                break;
        }
    }

    d.Sort();
    return d;
}


public static string GetVersion()
{
    System.Reflection.Assembly assembly = System.Reflection.Assembly.GetExecutingAssembly();
    System.Reflection.AssemblyName name = assembly.GetName();
    System.Version ver = name.Version;
    return ver.ToString(3);
}


public static int WriteHeader()
{
    System.Console.Write(BPIO.GetStringFromResource("about.txt").Replace("<?v?>", GetVersion()));
    return 1;
}

}//class
}//ns
