/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;

namespace LocaleInpector
{

internal sealed class Typos
{

private readonly List<string> m_typos;

private Typos(List<string> lines)
{
    m_typos = lines;
}

public static Status Check(string translatedDir)
{
    string file = Config2.Current.GetPref("typos");
    if (file.Length == 0) {
        return new Status();
    }

    Status stat;
    Output.OpenH1("Typos");
    if (BPIO.IsFile(file) == false) {
        Output.WriteLine("[FILE NOT FOUND] " + file);
        stat = new Status();
        stat.Errors++;
    } else {
        string txt = BPIO.LoadText(file, BPIO.UTF8);
        Typos ty = new Typos(Strings.SplitLines(txt));
        stat = ty.CheckDir(translatedDir);
    }

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}

private Status CheckDir(string translatedDir)
{
    Status stat = new Status();
    List<string> fileList = BPIO.GetFileList(translatedDir, "*");
    for (int idx = 0; idx < fileList.Count; idx++) {
        stat.Add(CompareKeyFile(translatedDir, fileList[idx]));
    }

    return stat;
}

private Status CompareKeyFile(string translatedDir, string file)
{
    Status stat = new Status();
    NameValueFile translatedFile = NameValueFile.LoadTranslated(translatedDir + file);
    if (translatedFile == null) {
        // unknown format (binary, html, ...)
        return stat;
    }

    Dictionary<string, string> translatedKeys = translatedFile.LoadHashtable();
    stat.Comparisons += translatedKeys.Count;
    stat.Files++;


    // loop em translatedFile: alguma no existe em originalFile?
    Dictionary<string, string>.Enumerator translatedKeyNames = translatedKeys.GetEnumerator();
    while (translatedKeyNames.MoveNext()) {
        foreach(string typo in m_typos) {
            if (translatedKeyNames.Current.Value.IndexOf(typo) > 0) {
                if (Output.WriteWarning("found typo '" + typo + "' at " + file + " => " + translatedKeyNames.Current.Key)) {
                    Output.WriteLine("Phrase: " + translatedKeyNames.Current.Value);
                    Output.WriteLine(new string('-', 79));
                }
                stat.Warnings++;
            }
        }
    }

    return stat;
}

}//class
}//ns


