/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsEnvironment;
import java.awt.peer.FontPeer;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.FontProperties;
import sun.awt.NativeLibLoader;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.java2d.SunGraphicsEnvironment;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected Properties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry;
    protected String aliasName;
    protected String styleString;
    private Object[] fontCache;
    protected static int FONTCACHESIZE;
    protected static int FONTCACHEMASK;
    protected static String osVersion;
    protected static FontProperties fprops;

    public PlatformFont(String string, int n) {
        int n2;
        if (fprops == null) {
            this.props = null;
            return;
        }
        this.props = fprops;
        this.aliasName = this.props.getProperty("alias." + string.toLowerCase());
        if (this.aliasName == null) {
            this.aliasName = string.toLowerCase();
        }
        if (this.props.getProperty(this.aliasName + ".0") == null && this.props.getProperty(this.aliasName + ".plain.0") == null) {
            this.aliasName = "sansserif";
        }
        this.styleString = PlatformFont.styleStr(n);
        Vector vector = new Vector(5);
        int n3 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n3);
            String string3 = this.props.getProperty(this.aliasName + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(this.aliasName + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.aliasName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.aliasName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n4 = 1;
                int n5 = 0;
                while ((n5 = string5.indexOf(44, n5)) != -1) {
                    ++n5;
                    ++n4;
                }
                nArray = new int[n4];
                int n6 = 0;
                while (n6 < n4) {
                    String string6;
                    String string7;
                    int n7 = 0;
                    int n8 = 0;
                    try {
                        string7 = string5.substring(n6 * 10, n6 * 10 + 4);
                        string6 = string5.substring(n6 * 10 + 5, n6 * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n7 = Integer.parseInt(string7, 16);
                        n8 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[n6] = n7 << 16 | n8;
                    ++n6;
                }
            }
            vector.addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n3;
        }
        this.componentFonts = new FontDescriptor[n3];
        int n9 = 0;
        while (n9 < n3) {
            this.componentFonts[n9] = (FontDescriptor)vector.elementAt(n9);
            ++n9;
        }
        try {
            n2 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        int n10 = 0;
        while (n10 < this.componentFonts.length) {
            if (!this.componentFonts[n10].isExcluded((char)n2) && this.componentFonts[n10].fontCharset.canConvert((char)n2)) {
                this.defaultFont = this.componentFonts[n10];
                this.defaultChar = (char)n2;
                break;
            }
            ++n10;
        }
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length());
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2) {
        CharsetString[] charsetStringArray;
        int n3;
        Object object;
        if (n2 < 1) {
            return new CharsetString[0];
        }
        Vector vector = null;
        char[] cArray2 = new char[n2];
        char c = this.defaultChar;
        Object object2 = this.defaultFont;
        int n4 = 0;
        while (n4 < this.componentFonts.length) {
            if (!this.componentFonts[n4].isExcluded(cArray[n]) && this.componentFonts[n4].fontCharset.canConvert(cArray[n])) {
                object2 = this.componentFonts[n4];
                c = cArray[n];
                break;
            }
            ++n4;
        }
        cArray2[0] = c;
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            char c2 = cArray[n + n6];
            object = this.defaultFont;
            c = this.defaultChar;
            n3 = 0;
            while (n3 < this.componentFonts.length) {
                if (!this.componentFonts[n3].isExcluded(c2) && this.componentFonts[n3].fontCharset.canConvert(c2)) {
                    object = this.componentFonts[n3];
                    c = c2;
                    break;
                }
                ++n3;
            }
            cArray2[n6] = c;
            if (object2 != object) {
                if (vector == null) {
                    vector = new Vector(3);
                }
                vector.addElement(new CharsetString(cArray2, n5, n6 - n5, (FontDescriptor)object2));
                object2 = object;
                object = this.defaultFont;
                n5 = n6;
            }
            ++n6;
        }
        object = new CharsetString(cArray2, n5, n2 - n5, (FontDescriptor)object2);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{object};
        } else {
            vector.addElement(object);
            charsetStringArray = new CharsetString[vector.size()];
            n3 = 0;
            while (n3 < vector.size()) {
                charsetStringArray[n3] = (CharsetString)vector.elementAt(n3);
                ++n3;
            }
        }
        return charsetStringArray;
    }

    public boolean mightHaveMultiFontMetrics() {
        return this.props != null;
    }

    public Object[] makeConvertedMultiFontString(String string) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object[] makeConvertedMultiFontChars(char[] var1_1, int var2_2, int var3_3) throws MalformedInputException, ConversionBufferFullException {
        var4_4 = new Object[2];
        var6_5 = null;
        var7_6 = var2_2;
        var8_7 = 0;
        var9_8 = 0;
        var11_9 = null;
        var12_10 = null;
        var15_11 = var2_2 + var3_3;
        if (var2_2 < 0 || var15_11 > var1_1.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (var7_6 < var15_11) ** GOTO lbl78
        return null;
lbl-1000:
        // 1 sources

        {
            var13_13 = var1_1[var7_6];
            var10_12 = var13_13 & PlatformFont.FONTCACHEMASK;
            var14_14 = (PlatformFontCache)this.getFontCache()[var10_12];
            if (var14_14 == null || var14_14.uniChar != var13_13) {
                var11_9 = this.defaultFont;
                var13_13 = this.defaultChar;
                var16_15 = var1_1[var7_6];
                var17_17 = this.componentFonts.length;
                var18_18 = 0;
                while (var18_18 < var17_17) {
                    var19_19 /* !! */  = (char[])this.componentFonts[var18_18];
                    var19_19 /* !! */ .fontCharset.reset();
                    var19_19 /* !! */ .fontCharset.setSubstitutionMode(false);
                    if (!var19_19 /* !! */ .isExcluded(var16_15) && var19_19 /* !! */ .fontCharset.canConvert(var16_15)) {
                        var11_9 = var19_19 /* !! */ ;
                        var13_13 = var16_15;
                        break;
                    }
                    ++var18_18;
                }
                try {
                    var19_19 /* !! */  = new char[]{var13_13};
                    var14_14 = new PlatformFontCache();
                    var14_14.encodingSize = (byte)var11_9.fontCharset.convert(var19_19 /* !! */ , 0, 1, var14_14.encoding, 0, 3);
                    var14_14.fontDescriptor = var11_9;
                    var14_14.uniChar = var1_1[var7_6];
                    this.getFontCache()[var10_12] = var14_14;
                }
                catch (Exception var19_20) {
                    System.err.println(var19_20);
                    var19_20.printStackTrace();
                    return null;
                }
            }
            if (var12_10 != var14_14.fontDescriptor) {
                if (var12_10 != null) {
                    var4_4[var9_8++] = var12_10;
                    var4_4[var9_8++] = var6_5;
                    if (var6_5 != null) {
                        var6_5[0] = (byte)((var8_7 -= 4) >> 24);
                        var6_5[1] = (byte)(var8_7 >> 16);
                        var6_5[2] = (byte)(var8_7 >> 8);
                        var6_5[3] = (byte)var8_7;
                    }
                    if (var9_8 >= var4_4.length) {
                        var16_16 = new Object[var4_4.length * 2];
                        System.arraycopy(var4_4, 0, var16_16, 0, var4_4.length);
                        var4_4 = var16_16;
                    }
                }
                var6_5 = new byte[(var15_11 - var7_6 + 1) * var14_14.fontDescriptor.fontCharset.getMaxBytesPerChar() + 4];
                var8_7 = 4;
                var12_10 = var14_14.fontDescriptor;
            }
            if (var14_14.encodingSize == 1) {
                var6_5[var8_7++] = var14_14.encoding[0];
            } else if (var14_14.encodingSize == 2) {
                var6_5[var8_7++] = var14_14.encoding[0];
                var6_5[var8_7++] = var14_14.encoding[1];
            } else if (var14_14.encodingSize == 3) {
                var6_5[var8_7++] = var14_14.encoding[0];
                var6_5[var8_7++] = var14_14.encoding[1];
                var6_5[var8_7++] = var14_14.encoding[2];
            } else if (var14_14.encodingSize == 4) {
                var6_5[var8_7++] = var14_14.encoding[0];
                var6_5[var8_7++] = var14_14.encoding[1];
                var6_5[var8_7++] = var14_14.encoding[2];
                var6_5[var8_7++] = var14_14.encoding[3];
            }
            ++var7_6;
lbl78:
            // 2 sources

            ** while (var7_6 < var15_11)
        }
lbl79:
        // 1 sources

        var4_4[var9_8++] = var12_10;
        var4_4[var9_8++] = var6_5;
        if (var6_5 != null) {
            var6_5[0] = (byte)((var8_7 -= 4) >> 24);
            var6_5[1] = (byte)(var8_7 >> 16);
            var6_5[2] = (byte)(var8_7 >> 8);
            var6_5[3] = (byte)var8_7;
        }
        return var4_4;
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    protected final Object[] getFontCache() {
        if (this.fontCache == null) {
            this.fontCache = new Object[FONTCACHESIZE];
        }
        return this.fontCache;
    }

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    private static native void initIDs();

    static {
        NativeLibLoader.loadLibraries();
        PlatformFont.initIDs();
        charsetRegistry = new Hashtable(5);
        FONTCACHESIZE = 256;
        FONTCACHEMASK = FONTCACHESIZE - 1;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof SunGraphicsEnvironment) {
            fprops = ((SunGraphicsEnvironment)graphicsEnvironment).getFontProperties();
        }
    }

    class PlatformFontCache {
        char uniChar;
        FontDescriptor fontDescriptor;
        byte encodingSize;
        byte[] encoding = new byte[4];

        PlatformFontCache() {
        }
    }
}

