/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.util;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.util.Log;
import org.mozilla.util.Utilities;

public class Debug {
    public static final String HELP_FILTER_STRING = "HELP";
    public static final String ALL_FILTER_STRING = "ALL";
    public static final String TIMING_FILTER_STRING = "TIMING";
    public static final String PROGRESS_FILTER_STRING = "PROGRESS";
    static final String PROPERTY_NAME = "Debug.filters";
    static final String SEP = ",";
    static boolean showedColumnTitleHelp = false;
    static Vector filters = null;
    static long initializationTime;
    static long lastTime;
    static long startTime;
    static long lapTime;

    public static synchronized void addFilter(String string) {
        if (string != null) {
            if (filters == null) {
                Log.log("Debugging has been enabled.");
                Log.log("os name: " + System.getProperty("os.name"));
                Log.log("os version: " + System.getProperty("os.version"));
                Log.log("Java version: " + System.getProperty("java.version"));
                Log.log("Java home: " + System.getProperty("java.home"));
                Log.log("User home: " + System.getProperty("user.home"));
                filters = new Vector(1);
            }
            Log.log("Adding debug filter: " + string);
            if (!filters.contains(string)) {
                filters.addElement(string);
            }
            if (string.equalsIgnoreCase(HELP_FILTER_STRING)) {
                Log.log("Set one or more debug filters (usually possible from the commandling), then simply wrap your debug code in a test for a particular debug filter, and only execute the code if that filter has been set.");
                Log.log("Predifined debug filters:");
                Log.log("    HELP   [prints this info]");
                Log.log("    ALL    [causes all calls to \"containsFilter()\" to return \"true\", effectively enabling all filters]");
                Log.log("    TIMING [causes all timing messages generated by this class to print]");
            }
        } else {
            throw new IllegalArgumentException("null filter passed to addFilter()");
        }
    }

    public static synchronized void removeFilter(String string) {
        if (filters != null) {
            filters.removeElement(string);
        }
    }

    public static synchronized void removeAllFilters() {
        if (filters != null) {
            filters.removeAllElements();
        }
    }

    public static synchronized boolean containsFilterWithPrefix(String string) {
        boolean bl = false;
        if (filters != null) {
            Enumeration enumeration = filters.elements();
            while (!bl && enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static synchronized boolean containsFilter(String string, String string2) {
        return string != null && filters != null && filters.contains(string) || filters != null && filters.contains(string2) || string != null && string.equals("");
    }

    public static synchronized boolean containsFilter(String string) {
        return Debug.containsFilter(string, ALL_FILTER_STRING);
    }

    private static synchronized boolean containsTimingFilter(String string) {
        return Debug.containsFilter(string, TIMING_FILTER_STRING);
    }

    private static synchronized void maybeShowColumnHelp() {
        if (!showedColumnTitleHelp) {
            Log.enableTimestampPrefix(false);
            Log.logErrorMessage("************************:");
            Log.logErrorMessage("Debugging time codes:");
            Log.logErrorMessage("  etset=elapsed time since elapsed time (since the previous elapsedTime() call)");
            Log.logErrorMessage("  etsst=elapsed time since start time (since the previous startTime() call)");
            Log.logErrorMessage("  etsit=elapsed time since initialization time (typically since the program was launched)");
            Log.logErrorMessage("************************:");
            showedColumnTitleHelp = true;
            Log.enableTimestampPrefix(false);
        }
    }

    private static synchronized void logTimingMessageString(String string, String string2) {
        String string3 = string2 == null ? (Debug.containsFilter(TIMING_FILTER_STRING) ? TIMING_FILTER_STRING : "UNMATCHED FILTER") : (string2.equals("") ? "ANY" : string2);
        String string4 = Log.getApplicationName();
        if (string4 == null) {
            System.err.println("[" + string3 + "]: " + string);
            System.err.flush();
        } else {
            System.err.println(string4 + "[" + string3 + "]: " + string);
            System.err.flush();
        }
    }

    public static synchronized void startTiming() {
        lapTime = startTime = new Date().getTime();
    }

    public static synchronized void startTiming(String string) {
        Debug.startTiming(string, TIMING_FILTER_STRING);
    }

    public static synchronized void startTiming(String string, String string2) {
        if (Debug.containsTimingFilter(string2)) {
            string = string == null ? "" : " [" + string + "]";
            Debug.maybeShowColumnHelp();
            Debug.startTiming();
            Debug.logTimingMessageString("Resetting start time at etsit of: " + Debug.formatTime(Debug.elapsedTimeSinceInitialization()) + string, string2);
        }
    }

    private static synchronized long elapsedTime(long l) {
        lapTime = new Date().getTime();
        return lapTime - l;
    }

    public static synchronized long elapsedTimeSinceInitialization() {
        return Debug.elapsedTime(initializationTime);
    }

    public static synchronized long elapsedTimeSinceStartTime() {
        if (startTime == 0L) {
            return 0L;
        }
        return Debug.elapsedTime(startTime);
    }

    public static synchronized long elapsedTimeSinceElapsedTime() {
        if (lapTime == 0L) {
            return 0L;
        }
        return Debug.elapsedTime(lapTime);
    }

    public static synchronized void elapsedTime(String string) {
        Debug.elapsedTime(string, TIMING_FILTER_STRING);
    }

    public static synchronized void elapsedTime(String string, String string2) {
        if (Debug.containsTimingFilter(string2)) {
            string = string == null ? "" : " [" + string + "]";
            Debug.maybeShowColumnHelp();
            Debug.logTimingMessageString("etset: " + Debug.formatTime(Debug.elapsedTimeSinceElapsedTime()) + " etsst: " + Debug.formatTime(Debug.elapsedTimeSinceStartTime()) + " etsit: " + Debug.formatTime(Debug.elapsedTimeSinceInitialization()) + string, string2);
        }
    }

    private static synchronized String formatTime(long l) {
        String string = String.valueOf(l % 1000L);
        int n = string.length();
        return String.valueOf(l / 1000L) + "." + "000".substring(n) + string;
    }

    private static synchronized String formatTimeAligned(long l) {
        long l2 = l / 1000L;
        String string = null;
        if (l2 == 0L) {
            string = "     ";
        } else {
            string = String.valueOf(l2);
            int n = string.length();
            string = "     ".substring(n) + string;
        }
        String string2 = String.valueOf(l % 1000L);
        int n = string2.length();
        return string + "." + "000".substring(n) + string2;
    }

    public static synchronized void printTime(String string, String string2) {
        if (filters != null && filters.contains(string2)) {
            long l = System.currentTimeMillis();
            System.out.println(Debug.formatTimeAligned(l - initializationTime) + "  " + Debug.formatTimeAligned(l - lastTime) + "  " + string);
            System.out.flush();
            lastTime = l;
        }
    }

    public static synchronized String getHashCode(Object object) {
        String string = object == null ? "0x0000" : "0x" + Integer.toHexString(object.hashCode());
        return string;
    }

    public static synchronized String getNameAndHashCode(Object object) {
        String string = object == null ? "<null>[0x0000]" : object.getClass().getName() + "[" + Debug.getHashCode(object) + "]";
        return string;
    }

    static {
        lastTime = initializationTime = new Date().getTime();
        startTime = 0L;
        lapTime = 0L;
        String string = System.getProperty(PROPERTY_NAME);
        if (null != string) {
            Vector vector = Utilities.vectorFromString(string, SEP);
            int n = null != vector ? vector.size() : 0;
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)vector.elementAt(n2);
                Debug.addFilter(string2);
                ++n2;
            }
        }
    }
}

