/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient;

import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.util.Utilities;
import org.mozilla.webclient.Bookmarks;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlCanvas;
import org.mozilla.webclient.BrowserType;
import org.mozilla.webclient.CurrentPage;
import org.mozilla.webclient.EventRegistration;
import org.mozilla.webclient.History;
import org.mozilla.webclient.ImplObject;
import org.mozilla.webclient.Navigation;
import org.mozilla.webclient.Preferences;
import org.mozilla.webclient.ProfileManager;
import org.mozilla.webclient.WindowControl;
import org.mozilla.webclient.WrapperFactory;

class BrowserControlImpl
implements BrowserControl {
    private static WrapperFactory wrapperFactory = null;
    private BrowserControlCanvas myCanvas = null;
    private BrowserType myType = null;
    private CurrentPage currentPage = null;
    private EventRegistration eventRegistration = null;
    private WindowControl windowControl = null;
    private Navigation navigation = null;
    private History history = null;
    private static Bookmarks bookmarks = null;
    private static Preferences prefs = null;
    private static ProfileManager profileManager = null;
    private static String browserType = null;
    static /* synthetic */ Class class$org$mozilla$webclient$BrowserControlImpl;

    public BrowserControlImpl(String string, BrowserControlCanvas browserControlCanvas) {
        if (browserType.equals("native")) {
            ParameterCheck.nonNull(browserControlCanvas);
            this.myCanvas = browserControlCanvas;
        }
    }

    void delete() {
        Assert.assert_it(null != this.myCanvas);
        if (this.myCanvas.isShowing()) {
            throw new IllegalStateException("Can't delete a browser control while its canvas is showing");
        }
        this.myCanvas = null;
        if (null != this.eventRegistration) {
            ((ImplObject)((Object)this.eventRegistration)).delete();
            this.eventRegistration = null;
        }
        if (null != this.navigation) {
            ((ImplObject)((Object)this.navigation)).delete();
            this.navigation = null;
        }
        if (null != this.history) {
            ((ImplObject)((Object)this.history)).delete();
            this.history = null;
        }
        if (null != this.currentPage) {
            ((ImplObject)((Object)this.currentPage)).delete();
            this.currentPage = null;
        }
        Assert.assert_it(null != this.windowControl);
        ((ImplObject)((Object)this.windowControl)).delete();
        this.windowControl = null;
    }

    static void appInitialize(String string, String string2) throws Exception {
        browserType = string;
        if (null == wrapperFactory) {
            System.out.println("\n+++ In appInitialize - before createWrapperFactory +++ \n");
            wrapperFactory = BrowserControlImpl.createWrapperFactory();
            System.out.println("\n+++ In appInitialize - after createWrapperFactory +++ \n");
        }
        wrapperFactory.initialize(string2);
    }

    static void appTerminate() throws Exception {
        Assert.assert_it(null != wrapperFactory);
        if (null != bookmarks) {
            ((ImplObject)((Object)bookmarks)).delete();
            bookmarks = null;
        }
        if (null != prefs) {
            ((ImplObject)((Object)prefs)).delete();
            prefs = null;
        }
        if (null != profileManager) {
            ((ImplObject)((Object)profileManager)).delete();
            profileManager = null;
        }
        wrapperFactory.terminate();
    }

    private static WrapperFactory createWrapperFactory() throws ClassNotFoundException {
        String string = null;
        Class<?> clazz = null;
        WrapperFactory wrapperFactory = null;
        string = Utilities.getPackageName(class$org$mozilla$webclient$BrowserControlImpl == null ? (class$org$mozilla$webclient$BrowserControlImpl = BrowserControlImpl.class$("org.mozilla.webclient.BrowserControlImpl")) : class$org$mozilla$webclient$BrowserControlImpl);
        if (null == string) {
            throw new ClassNotFoundException("Can't determine current class name");
        }
        String string2 = "";
        System.out.println("\n+++ browserType is - " + browserType + " +++\n");
        string2 = browserType.equals("native") ? "native" : "nonnative";
        System.out.println("\n+++ PARAMETERIZED_VALUE is " + string2 + " +++\n");
        string = string + "wrapper_" + string2 + "." + WrapperFactory.IMPL_NAME;
        System.out.println("\n+++ WrapperFactory classname is " + string + " +++\n");
        clazz = Class.forName(string);
        try {
            wrapperFactory = (WrapperFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(exception.getMessage());
        }
        return wrapperFactory;
    }

    public Object queryInterface(String string) throws ClassNotFoundException {
        ParameterCheck.nonNull(string);
        Assert.assert_it(null != wrapperFactory);
        if ("webclient.Navigation".equals(string)) {
            if (null == this.navigation) {
                this.navigation = (Navigation)wrapperFactory.newImpl("webclient.Navigation", this);
            }
            return this.navigation;
        }
        if ("webclient.History".equals(string)) {
            if (null == this.history) {
                this.history = (History)wrapperFactory.newImpl("webclient.History", this);
            }
            return this.history;
        }
        if ("webclient.BrowserControlCanvas".equals(string)) {
            Assert.assert_it(null != this.myCanvas);
            return this.myCanvas;
        }
        if ("webclient.BrowserType".equals(string)) {
            if (null == this.myType) {
                this.myType = (BrowserType)wrapperFactory.newImpl("webclient.BrowserType", this);
            }
            return this.myType;
        }
        if ("webclient.CurrentPage".equals(string)) {
            if (null == this.currentPage) {
                this.currentPage = (CurrentPage)wrapperFactory.newImpl("webclient.CurrentPage", this);
            }
            return this.currentPage;
        }
        if ("webclient.WindowControl".equals(string)) {
            if (null == this.windowControl) {
                this.windowControl = (WindowControl)wrapperFactory.newImpl("webclient.WindowControl", this);
            }
            return this.windowControl;
        }
        if ("webclient.EventRegistration".equals(string)) {
            if (null == this.eventRegistration) {
                this.eventRegistration = (EventRegistration)wrapperFactory.newImpl("webclient.EventRegistration", this);
            }
            return this.eventRegistration;
        }
        if ("webclient.Bookmarks".equals(string)) {
            if (null == bookmarks) {
                bookmarks = (Bookmarks)wrapperFactory.newImpl("webclient.Bookmarks", this);
            }
            return bookmarks;
        }
        if ("webclient.Preferences".equals(string)) {
            if (null == prefs) {
                prefs = (Preferences)wrapperFactory.newImpl("webclient.Preferences", this);
            }
            return prefs;
        }
        if ("webclient.ProfileManager".equals(string)) {
            if (null == profileManager) {
                profileManager = (ProfileManager)wrapperFactory.newImpl("webclient.ProfileManager", this);
            }
            return profileManager;
        }
        return wrapperFactory.newImpl(string, this);
    }

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("BrowserControlImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: BrowserControlImpl.java,v 1.7 2001/07/27 20:57:52 ashuk%eng.sun.com Exp $");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

