/* FILEMANAGER  --  An FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
*  Author: Duong Thanh An - technical@anisolution.com (core)
*  Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)
*	
*  Copyright (C) 2004 Anisolution.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Anisolution.com
*  http://www.anisolution.com
*  HCMC Vietnam
*  info@anisolution.com
*/
/*		
	 Copyright notice:
	 XUL File Manager is freeware with open source code. 
	 As long as you keep the copyright message, you can 
	 play with the code for your own purposes but you can
	 not distribute the altered version. You can not sell 
	 XUL File Manager or use it for commercial purposes.
	 Please contact us for commercial uses.

	 BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM
*/


installExtension(new ArchivingExt());

var currentArchiveName = null;
function ArchivingExt() {

	this.acceptExts = "(zip)|([jwe]ar)";
	this.getDisplayInfo = function() {
		var sel = getListSelectionModel();
		if(!sel) return null;
		if(sel.totalFolders == 0 && sel.totalFiles == 0) return null;

		var menuItem = new ExtensionMenuItem();
		menuItem.caption = "Archiving";
		menuItem.iconImage = "images/ext/archiving.png";


		if((sel.totalFolders + sel.totalFiles) > 1) {
			var createArchiveMenuItem = new ExtensionMenuItem();
			createArchiveMenuItem.caption = "Create ZIP archive...";
			createArchiveMenuItem.action = function () {
				var archiveName = "";
				if(currentPath && currentPath.match(/([^\/]+)\/$/)) {
					archiveName = RegExp.$1 + ".zip";
				}
				archiveName = prompt("Please enter the archive name:", archiveName);
				if(!archiveName) return;
				runArchiveCommand(archiveName);
			};
			menuItem.appendChild(createArchiveMenuItem);

			if(currentPath && currentPath.match(/([^\/]+)\/$/)) {
				name = RegExp.$1;
				createArchiveMenuItem = new ExtensionMenuItem();
				currentArchiveName = name + ".zip";
				createArchiveMenuItem.caption = "Create \"" + currentArchiveName + "\"";
				createArchiveMenuItem.action = function () {
					runArchiveCommand(currentArchiveName);
				};
				menuItem.appendChild(createArchiveMenuItem);
			}
		} else if(isFileOfType(sel, this.acceptExts)) {
			var extractMenuItem = new ExtensionMenuItem();
			extractMenuItem.caption = "Extract here";
			extractMenuItem.action = function () {
				runUnArchiveCommand();
			};
			menuItem.appendChild(extractMenuItem);
		} else {

			var list = document.getElementById("contentList");
			var index = list.view.selection.currentIndex;
			if(index < 0) return;
			var item = list.view.getItemAtIndex(index);

			var createArchiveMenuItem = new ExtensionMenuItem();
			currentArchiveName = item.fsData.name + ".zip";
			createArchiveMenuItem.caption = "Create \"" + currentArchiveName + "\"";
			createArchiveMenuItem.action = function () {
				runArchiveCommand(currentArchiveName);
			};
			menuItem.appendChild(createArchiveMenuItem);

			createArchiveMenuItem = new ExtensionMenuItem();
			createArchiveMenuItem.caption = "Create ZIP archive...";
			createArchiveMenuItem.action = function () {
				var archiveName = currentArchiveName;
				archiveName = prompt("Please enter the archive name:", archiveName);
				if(!archiveName) return;
				runArchiveCommand(archiveName);
			};
			menuItem.appendChild(createArchiveMenuItem);

		}


		return menuItem;
	};

	this.getAboutInfo = function() {
		return "Folder Navigation by Duong Thanh An. Email: dgthanhan@yahoo.com";
	};
}
function runArchiveCommand(archiveName) {
	var object = document.getElementById("contentList");
	if(object.view.selection.count <= 0) return;
	var files = "";
	var firstFileName = null;
	var count = 0;
	for(var i = 0; i < object.view.rowCount; i++) {
		if(object.view.selection.isSelected(i)) {
			var item = object.view.getItemAtIndex(i);
			if(files.length > 0) files += "\n";
			files += item.fsData.absolutePath;
			if(!firstFileName) firstFileName = item.fsData.name;
			count ++;
		}
	}
	if(!archiveName) return;
	archiveName = currentPath + archiveName;

	var handler = new Object();
	handler.onLoad = function(){
		runRefreshCommand(archiveName);
		setReadyStatus("ZIP archive created.");
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description + " (" + connection.httpError.code + ")");
		setReadyStatus("Failed to archive selected items.");
	};

	setBusyStatus("Creating ZIP archive...");

	var xHttpConnection = new XHttpConnection();
	xHttpConnection.url = SERVER_ARCHIVER_PATH;

	var postData = "";
	postData +=  "path=" + encodeURIComponent(archiveName);
	postData +=  "&removePath=" + encodeURIComponent(currentPath);
	postData +=  "&content=" + encodeURIComponent(files);
	postData += "&token=" + escape(new Date());

	xHttpConnection.method = "post";
	xHttpConnection.postData = postData;
	xHttpConnection.async = true;
	xHttpConnection.setAsyncHandler(handler);

	xHttpConnection.execute();
}
function runUnArchiveCommand() {
	var object = document.getElementById("contentList");
	if(object.view.selection.count <= 0) return;
	var item = object.view.getItemAtIndex(object.view.selection.currentIndex);
	var handler = new Object();
	handler.onLoad = function(){
		runRefreshCommand();
		setReadyStatus("Archive extracted");
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to extract archive.");
	};
	setBusyStatus("Extracting archive...");

	var xHttpConnection = new XHttpConnection();
	xHttpConnection.url = SERVER_UNARCHIVER_PATH;

	item.fsData.absolutePath.match(/^(.+)\/[^\/]+$/);
	var dest = RegExp.$1;
	var postData = "";
	postData +=  "path=" + encodeURIComponent(item.fsData.absolutePath);
	postData +=  "&dest=" + encodeURIComponent(dest);
	postData += "&token=" + escape(new Date());

	xHttpConnection.method = "post";
	xHttpConnection.postData = postData;
	xHttpConnection.async = true;
	xHttpConnection.setAsyncHandler(handler);

	xHttpConnection.execute();
}
