################################################################################
#
# Java build system:
# Creates Java XPCOM components using BlackConnect.  
# For information on how to use see the comments at the top of this file.
#
# Known Limitations:
# * Only works on Windows for now.
#
# Contributors:
#   Brad GNUberg, bkn3@columbia.edu

#Even if the following are created by intermediate rules don't delete them
.PRECIOUS = %.java %.idl %.class

#The following are variables that are usually automatically defined by
#Autoconf and in config/rules.mk; we include them here just in case
#a programmer is using javarules.mk outside of the context of the Mozilla
#build system

ifndef MOZILLA_BUILD_SYSTEM

DIST = $(DEPTH)/dist

XPIDL_GEN_DIR = _xpidlgen

XPIDL_COMPILE = $(DEPTH)/dist/bin/xpidl

all:: 
	$(MAKE) export
	$(MAKE) libs

endif #MOZILLA_BUILD_SYSTEM

#Make sure our dist/classes directory and our _xpidlgen directory are in the Java
#classpath
JAVAFLAGS += -classpath ".;$(subst /,\,$(DIST))\classes;$(XPIDL_GEN_DIR);$(CLASSPATH)"

JAVAC=$(JDKHOME)/bin/javac $(JAVAFLAGS)

#A complex macro that is used by JAVA_GARBAGE to delete any class files that were produced
#that may be in several different directories.  It works as follows:
#First it grabs just the directory portion of each entry in JAVASRCS,
#such as org/mozilla/xpcom, com/foobar/iota, etc., sorts it to remove duplicate entries,
#filters out any entries that are just ./, and adds *.class onto the end of each one 
#to remove all of the class files in those directories 
CLOBBER_CLASSES = $(addsuffix /*.class,$(filter-out ./,$(sort $(dir $(JAVASRCS)))))

#Things to clobber
JAVA_GARBAGE = $(CLOBBER_CLASSES) $(JAVAMODULE).jar.comp *.class

clean clobber realclean clobber_all::
	rm -fr $(XPIDL_GEN_DIR)
	rm -f $(JAVA_GARBAGE)

#Add in the full dist/idl path to the JAVAIDLREQUIRES variable
JAVADISTIDL = $(JAVAIDLREQUIRES:%=$(DIST)/idl/%)

#Creates the _xpidlgen and _xpidlgen/org/mozilla/xpcom directories if they
#don't exist yet
create-xpidl-directories:
	@if test ! -d $(XPIDL_GEN_DIR); \
	then echo Creating $(XPIDL_GEN_DIR); \
	rm -rf $(XPIDL_GEN_DIR); \
	mkdir $(XPIDL_GEN_DIR); \
	fi
	@if test ! -d $(XPIDL_GEN_DIR)/org; \
	then echo Creating $(XPIDL_GEN_DIR)/org/mozilla/xpcom; \
	rm -rf $(XPIDL_GEN_DIR)/org; \
	mkdir $(XPIDL_GEN_DIR)/org; \
	mkdir $(XPIDL_GEN_DIR)/org/mozilla; \
	mkdir $(XPIDL_GEN_DIR)/org/mozilla/xpcom; \
	fi
	@touch $@
	@#for some reason a 'create-xpidl-directories' file is left behind; clobber it
	@rm create-xpidl-directories

#A method to generate our Java and typelib files into the _xpidlgen/org/mozilla/xpcom directory using the xpidl compiler
#argument 1 : The idl file to compile, such as nsIFooBar.idl
create_java_stubs_from_idl = \
	echo Generating $(1:%.idl=%.java) from $(1); \
	cd $(XPIDL_GEN_DIR)/org/mozilla/xpcom; \
	../../../../$(XPIDL_COMPILE) -m java -w -v $(XPIDL_INCLUDES) -I$(DEPTH)/../../../../dist/idl/ $(notdir $(1)); \
	cd ..

#A method to generate our JavaScript XPCOM typelib files into the _xpidlgen/org/mozilla/xpcom directory
#argument 1 : The idl file to compile, such as nsIFooBar.idl
create_javascript_stubs_from_idl = \
	echo Generating $(1:%.idl=%.xpt) from $(1); \
	cd $(XPIDL_GEN_DIR)/org/mozilla/xpcom; \
	../../../../$(XPIDL_COMPILE) -m typelib -w -v $(XPIDL_INCLUDES) -I$(DEPTH)/../../../../dist/idl/ $(notdir $(1)); \
	cd ..

########## Export phase - generate Java stubs from IDL files

ifdef JAVAXPIDLS
export:: create-xpidl-directories
endif

ifdef JAVAIDLREQUIRES
ifndef JAVAXPIDLS            #Already handled by export:: above
export:: create-xpidl-directories
endif
endif

$(JAVAXPIDLS:%=$(XPIDL_GEN_DIR)/org/mozilla/xpcom/%):
	cp $(notdir $@) $(XPIDL_GEN_DIR)/org/mozilla/xpcom
	cp $(notdir $@) $(DIST)/idl
	@touch $(notdir $@)

$(JAVAXPIDLS): $(JAVAXPIDLS:%=$(XPIDL_GEN_DIR)/org/mozilla/xpcom/%)
	$(call create_java_stubs_from_idl,$@)
	$(call create_javascript_stubs_from_idl,$@)
	cp $(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.xpt $(DIST)/bin/components

$(JAVAIDLREQUIRES:%=$(XPIDL_GEN_DIR)/org/mozilla/xpcom/%):
	cp $(DIST)/idl/$(notdir $@) $(XPIDL_GEN_DIR)/org/mozilla/xpcom
	@touch $(DIST)/idl/$(notdir $@)

$(JAVADISTIDL): $(JAVAIDLREQUIRES:%=$(XPIDL_GEN_DIR)/org/mozilla/xpcom/%)
	$(call create_java_stubs_from_idl,$@)

$(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.java: $(JAVAXPIDLS) $(JAVADISTIDL)

ifdef JAVAXPIDLS
export:: $(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.java
endif

ifdef JAVAIDLREQUIRES
ifndef JAVAXPIDLS            #Already handled by export:: above
export:: $(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.java
endif
endif


########## Libs phase - compile our Java files and Java IDL stubs and create and install our JAR XPCOM file

$(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.class: $(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.java
	$(JAVAC) $?
ifdef JAVAXPIDLS
	@# Copy over any custom Java IDL class files to dist/classes
	cp $(JAVAXPIDLS:%.idl=$(XPIDL_GEN_DIR)/org/mozilla/xpcom/%.class) $(DIST)/classes/org/mozilla/xpcom
endif

$(JAVASRCS:%.java=%.class): $(JAVASRCS)
	$(JAVAC) $(@:%.class=%.java)

ifdef JAVAXPIDLS
libs:: $(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.class
endif

ifdef JAVAIDLREQUIRES
ifndef JAVAXPIDLS            #Already handled by libs:: above         
libs:: $(XPIDL_GEN_DIR)/org/mozilla/xpcom/*.class
endif
endif

libs:: $(JAVASRCS:%.java=%.class)

#Create our JAR file holding the Java XPCOM component
ifdef JAVAXPIDLS

libs:: $(JAVAMODULE).jar.comp

$(JAVAMODULE).jar.comp:
	@echo Creating $(JAVAMODULE).jar.comp
	$(JDKHOME)/bin/jar cvfm $(JAVAMODULE).jar.comp manifest *.class
	@###### All of the following is to ensure that our JAR stores the class's directory starting from 
	@###### org/mozilla/xpcom and not _xpidlgen/org/mozilla/xpcom
	@mv $(JAVAMODULE).jar.comp $(XPIDL_GEN_DIR)
	@cd $(XPIDL_GEN_DIR); \
	$(JDKHOME)/bin/jar uvf $(JAVAMODULE).jar.comp org/mozilla/xpcom/*.class; \
	mv $(JAVAMODULE).jar.comp ..
	@###### Copy everything over to the components directory
	@###### TODO: Make sure the component is regxpcom'ed for non-debug builds
	@cp $(JAVAMODULE).jar.comp $(DIST)/bin/components
	@cp $(JAVAMODULE).jar.info $(DIST)/bin/components

endif # ifdefined JAVAXPIDLS

#A little utility that makes working with the JDKHOME variable easier when
#compiling against the Java include files, such as jni.h, and the Java libs,
#such as jvm.lib.
#
#The problem is that we need JDKHOME to be a cygwin style path, such as /cygdrive/d/jdk1.3.1_06, 
#but when we invoke the Visual C++ command line we need it to be in Win32 style paths,
#such as d:/jdk1.3.1_06 (notice though that the slashes are still forward, like Unix).

to_winstyle_jdkhome = $(subst /cygdrive/$(call get_drive_letter,$(1)),$(call get_drive_letter,$(1)):,$(1))
	
get_drive_letter = $(word 2,$(subst /, ,$(1)))

################################################################################
