/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Sun Microsystems,
 * Inc. Portions created by Sun are
 * Copyright (C) 1999 Sun Microsystems, Inc. All
 * Rights Reserved.
 *
 * Contributor(s):
 * Igor Kushnirskiy <idk@eng.sun.com>
 * Brad GNUberg <bkn3@columbia.edu>
 */
#include <fstream.h>
#include "nsCRT.h"
#include "nsIFile.h"
#include "nsIAllocator.h"
#include "nsXPIDLString.h"
#include "nsCOMPtr.h"
#include "bcJavaModule.h"
#include "bcJavaComponentFactory.h"
#include "nsIComponentRegistrar.h"
#include "nsString.h"


NS_IMPL_ISUPPORTS1(bcJavaModule, nsIModule);
bcJavaModule::bcJavaModule(const char *registryLocation, nsIFile *component) 
    : location(NULL) {
	printf("--bcJavaModule::bcJavaModule\n");
    //NS_INIT_REFCNT(); -- deprecated, bkn3@columbia.edu
    //nsXPIDLCString str; -- bkn3@columbia.edu

	//nsAutoString str;
	//component->GetPath(str);
	component->GetPath(location);

	//printf("--str=%s\n", NS_LossyConvertUCS2toASCII(str).get());

	//location = (char *)NS_LossyConvertUCS2toASCII(str).get(); // is this ok?, bkn3@columbia.edu
	
    //location = nsCRT::strdup(str); -- bkn3@columbia.edu

    printf("--bcJavaModule::bcJavaModule, location=%s\n", NS_LossyConvertUCS2toASCII(location).get());
}

bcJavaModule::~bcJavaModule() {
	/*if (location) {
		nsCRT::free((char*)location);
    }*/
}

/* void getClassObject (in nsIComponentManager aCompMgr, in nsCIDRef aClass, in nsIIDRef aIID, [iid_is (aIID), retval] out nsQIResult result); */
NS_IMETHODIMP bcJavaModule::GetClassObject(nsIComponentManager *aCompMgr, const nsCID & aClass, const nsIID & aIID, void * *result) {
    printf("--JavaModule::GetClassObject\n");
    nsIFactory *f;
    f = new bcJavaComponentFactory(NS_LossyConvertUCS2toASCII(location).get());
    NS_ADDREF(f);
    *result = f;
    return NS_OK;
}

/* void registerSelf (in nsIComponentManager aCompMgr, in nsIFile location, in string registryLocation, in string componentType); */
NS_IMETHODIMP bcJavaModule::RegisterSelf(nsIComponentManager *aCompMgr, nsIFile *_location, const char *registryLocation, const char *componentType) {
    nsresult result = NS_OK;
    printf("--bcJavaModule::RegisterSelf\n");

    ifstream in(NS_LossyConvertUCS2toASCII(location).get());
	char cidStr[500], contractid[1000], desc[1000];
    in.getline(cidStr,1000);
    in.getline(contractid,1000);
    in.getline(desc,1000);
    printf("cidStr=%s\ncontractid=%s\ndesc=%s", cidStr, contractid, desc);
    nsCID  cid;
    cid.Parse((const char *)cidStr);
    nsCOMPtr<nsIComponentRegistrar> registrar (do_QueryInterface(aCompMgr, &result));
    if (NS_FAILED(result))
    {
        NS_ASSERTION(PR_FALSE, "Could not QI to registrar");
        return result;
    }
    registrar->RegisterFactoryLocation(cid, desc, contractid, _location, registryLocation, componentType);
    return result;
}

/* void unregisterSelf (in nsIComponentManager aCompMgr, in nsIFile location, in string registryLocation); */
NS_IMETHODIMP bcJavaModule::UnregisterSelf(nsIComponentManager *aCompMgr, nsIFile *_location, const char *registryLocation) { //nb 
    return NS_OK;
}

/* boolean canUnload (in nsIComponentManager aCompMgr); */
NS_IMETHODIMP bcJavaModule::CanUnload(nsIComponentManager *aCompMgr, PRBool *_retval) {
	printf("--bcJavaModule::CanUnload\n");
    if (!_retval) {
	return NS_ERROR_NULL_POINTER;
    }
    *_retval = PR_TRUE;
    return NS_OK;
}




