/** A testing class where we spawn Java threads and try to make calls 
	back to XPCOM components from the threads. 
	Used so that we can see if proxying calls from Java threads onto
	the main Mozilla thread works. */

import org.mozilla.xpcom.*;

import java.util.Random;

public class bcJavaThreadTest implements bcIJavaThreadTest {
	/** The number of threads to spawn for testing. */
	int NUMBER_OF_THREADS = 10;
	/** The maximum amount of time in milliseconds that a thread can sleep for. */
	int SLEEP_LIMIT_IN_MS = 4000;

    public Object queryInterface(IID iid) {
        Object result;
        if ( iid.equals(nsISupports.IID)
             || iid.equals(bcIJavaThreadTest.IID)) {
            result = this;
        } else {
            result = null;
        }
        return result;
    }

    public void startTest() {
		Thread runMe[] = new Thread[NUMBER_OF_THREADS];
		for (int i = 0; i < NUMBER_OF_THREADS; i++) {
			runMe[i] = new Thread("Java Testing Thread " + (i+1)) {
				public void run() {
						Random randomValue = new Random();
						nsIXPIDLServiceManager sm = Components.getServiceManager();
						while (true) {
							nsIConsoleService console = 
								(nsIConsoleService)sm.getServiceByContractID("@mozilla.org/consoleservice;1", nsIConsoleService.IID)
												.queryInterface(nsIConsoleService.IID);
							int value = Math.abs(randomValue.nextInt() % SLEEP_LIMIT_IN_MS); 
							console.logStringMessage(this.getName() + " is sleeping for " + value + " ms");
							try {
								this.sleep(value);
							}
							catch (Exception e) {
								e.printStackTrace();
							}
							
							// this won't print if from xpcshell, only in the JavaScript console if a debug build of Mozilla is running
							console.logStringMessage(this.getName() + " has woken up and is ready to rumble");
						}
				}
			};
			runMe[i].start();
		}
    }

	// staticly load any XPCOM classes we use in the implementation
	// of our component
    static {
      try {
          Class nsIConsoleServiceClass = 
              Class.forName("org.mozilla.xpcom.nsIConsoleService");
		  InterfaceRegistry.register(nsIConsoleServiceClass);

		  Class nsIConsoleMessageClass = 
              Class.forName("org.mozilla.xpcom.nsIConsoleMessage");
		  InterfaceRegistry.register(nsIConsoleMessageClass);

		  Class nsIConsoleListenerClass = 
              Class.forName("org.mozilla.xpcom.nsIConsoleListener");
		  InterfaceRegistry.register(nsIConsoleListenerClass);
      } catch (Exception e) {
          System.out.println(e);
      }
    }

};




